;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   
;;;   This file contains the lisp vaxima plot functions. 2-D plotting
;;;   is handled completely in lisp, while three-d requires the file
;;;   cplot.c be cfasled in. The points for 3D are generated in lisp
;;;   and passed to the c function for plotting. This plotting package
;;;   works completely with the mouse.
;;;   
(eval-when (compile) (require "//user//vaxima//young//devdep//gelib"))
(declare
    (macros t)
    (special lg-character-x lg-character-y lg-character-x-2 **screen
             lg-character-y-2 linel $xangle $yangle $zangle $fit m_left
	     m_right m_middle m_any kind-of-plot
	     whitehalftone **font $polystyle $polystylelist
	     $hidden **current-window** **top-level-menu**)
)
(setq $polystylelist '(clear hatched doubled))
(setq $polystyle 'clear)
(putprop 'clear 1 'style)
(putprop 'hatched 2 'style)
(putprop 'doubled 3 'style)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: plt
;;;   
;;;      Purpose: 
;;;   PLT-2D expression plotting. Takes f(x), x, and a list low-hi-pts
;;;   which contains the values lowx, hix, number of pts.
;;;   Calls plot2d
;;;
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 22:58:48 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun plt(f x low-hi-pts)
   (prog(low hi pts i  tempx step xx xlist ylist)
	     (setq xlist nil ylist nil)
	     (cond(low-hi-pts
		     (setq low(car low-hi-pts)
			   hi (cadr low-hi-pts)
			   pts (caddr low-hi-pts))))
	     (setq tempx x)
	     (setq step (quotient(float (difference hi low))
					(float (difference pts 1))))
	     (setq i 0)(setq xx (difference low step))
	     (show-status "Generating Points")
	     ;;;
	     pltloop
	     (cond((or( greaterp i pts)(equal i pts))(go pltplot)))
	     (setq xx (plus xx step))
	     (set x xx)
	     (setq xlist (append1 xlist (float xx)))
	     (setq ylist (append1 ylist (meval f)))
	     (setq i (add1 i ))
	     (go pltloop)
	     pltplot
	     (setq kind-of-plot
		   `(plot2d (quote ,xlist) (quote ,ylist) ,low ,hi ,pts))
	     (clear-status)
	     (show-status  "Plotting")
	     (plot2d xlist ylist low hi pts
		     (+ 10. (rect->x (get 'plot 'screenrect)))
		     (+ 10. (rect->y (get 'plot 'screenrect)))
		     (- (rect->w (get 'plot 'screenrect)) 20.)
		     (- (rect->h (get 'plot 'screenrect)) 20.)
		     )
	     (clear-status)
	     (set x tempx)
	     )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PRM
;;;   
;;;      Purpose: plot a 2 dimensional parametric function f(s),g(s)
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 22:59:42 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun prm(fx fy param low-hi-pts)
   (prog(low hi pts step  temppar pp i lo xlist ylist)
	     (setq xlist nil ylist nil)
	     (cond(low-hi-pts
		     (setq low(car low-hi-pts)
			   hi(cadr low-hi-pts)
			   pts(caddr low-hi-pts))))
	     (setq temppar param)

	     (setq step (quotient(float (difference hi low))
					(float (difference pts 1))))
	     (setq i 0)(setq pp (difference low step))
	     (show-status "Generating Points")
	     pltloop
	     (cond((or( greaterp i pts)(equal i pts))(go pltplot)))
	     (setq pp (plus pp step))
	     (set param pp)
	     (setq xlist (append1 xlist  (meval fx)))
	     (setq ylist (append1 ylist  (meval fy)))
	     (setq i (add1 i ))
	     (go pltloop)
	     pltplot
	     (clear-status)
	     (show-status "Plotting")
	     (setq kind-of-plot `(plot2d (quote ,xlist) (quote ,ylist) ,low ,hi ,pts))
	     (plot2d xlist ylist low hi pts
		     (+ 10. (rect->x(get 'plot 'screenrect)))
		     (+ 10. (rect->y(get 'plot 'screenrect)))
		     (- (rect->w(get 'plot 'screenrect)) 20.)
		     (- (rect->h(get 'plot 'screenrect)) 20.)
		     )
	     (clear-status)
	     (set param temppar)
	     )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PLOT3DPAR
;;;   
;;;      Purpose: plots a three D non-parametric function of the
;;;               form z = f(x,y). Calls the C function plot3d.
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:00:29 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		  
(defun plot3dpar(fz varx-vary xy-range)
   (prog (partx party i j  xx yy lowx hix lowy hiy numx numy
		xlist ylist zlist  tempx tempy xt index yt)
      (setq xlist nil ylist nil zlist nil)
      (setq xx (car varx-vary) yy (cadr varx-vary))
      (setq lowx (car  xy-range ))
      (setq hix (cadr  xy-range ))
      (setq numx (caddr xy-range ))
      (setq lowy (cadddr xy-range ))
      (setq hiy (caddddr xy-range ))
      (setq numy (cadddddr xy-range ))
      (setq tempx xx tempy yy)
      ;
      (setq xlist (new-vectori-double (times numx numy)))
      (setq ylist (new-vectori-double (times numx numy)))
      (setq zlist (new-vectori-double (times numx numy)))
      ;
      (cond((not(eq numx 1))
	    (setq partx (quotient
			   (float(difference hix lowx))
			   (difference numx 1))))
		    (t(setq partx (float (difference hix lowx)))))
      (cond((not (eq numy 1))
	    (setq party (quotient
			   (float(difference hiy lowy))
			   (difference numy 1))))
		 (t(setq party (float (difference hiy lowy)))))

      (prog ()
	 ;;; initialize loop counter
	 (setq i 0)(setq xt (difference lowx partx))
	 (setq index 0)
	 ;;;
	 ;;; outer loop
	 ;;;
	 (show-status "Generating Points")
	 uloop
	 (cond((or (greaterp i numx)(equal i numx))(go plot)))
	 (setq xt ( plus xt partx))
	 (set xx xt)
	 ;;; initialize loop
	 (setq j 0)(setq yt (difference lowy party))
	 ;;;
	 ;;;   start inner loop
	 ;;;
	 vloop
	 (cond ((or(greaterp j numy)(equal j numy))(go endv)))
	 (setq yt ( plus yt party))
	 (set yy yt)
	 ;;;
	 ;;; evaluate the function and store in array
	 ;;;
	 (vseti-double xlist index xt)
	 (vseti-double ylist index yt)
	 (vseti-double zlist index (meval fz))
	 ;;; increment loop counter
	 (setq j (add1 j ))(setq index (add1 index))
	 (go vloop)
	 endv
	 ;;; increment outer loop counter
	 (setq i (add1 i))
	 (go uloop)
	 plot
	 (clear-status)
	 (show-status "Plotting")
	 ;;;
	 ;;; cal
	 ;;;
	 (setq kind-of-plot `(plot3d (quote ,xlist)(quote ,ylist)(quote ,zlist)
				     ,lowx ,hix ,lowy ,hiy ,numx ,numy))
	 (plot3d xlist ylist zlist lowx hix lowy
		 hiy numx numy
		 (float $xangle)
		 (float $yangle)
		 (float $zangle)
		 $hidden
		 (+ 10. (rect->x (get 'plot 'screenrect)))
		 (+ 10. (rect->y(get 'plot 'screenrect)))
		 (- (+(rect->w (get 'plot 'screenrect))
			       (rect->x(get 'plot 'screenrect))) 20.)
		 (- (+(rect->h(get 'plot 'screenrect))
				   (rect->y(get 'plot 'screenrect))) 20.)
		 **screen
		 (get $polystyle 'style)		 
		 )
	 (clear-status)
	 (set xx tempx)(set yy tempy)
	 (return 'done)
	 )
      )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: SURF
;;;   
;;;      Purpose: graph a 3D parametric function
;;;               f(s,t) g(s,t) h(s,t)
;;;              Calls the C function plot3d
;;;
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:01:49 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun surf(fx fy fz vars  xy-range )
   (prog (partu partv i j  u v lowu hiu tempu tempv
		xlist ylist zlist lowv hiv numu numv index uu vv )
      (setq xlist nil ylist nil zlist nil)
      (setq u (car vars) v (cadr vars))
      (setq lowu (car  xy-range ))
      (setq hiu (cadr  xy-range ))
      (setq lowv (nthelem 4 xy-range ))
      (setq hiv (nthelem 5 xy-range ))
      (setq numu (nthelem 3 xy-range ))
      (setq numv (nthelem 6 xy-range ))
      (setq tempu u tempv v)
      (setq xlist (new-vectori-double (times numu numv)))
      (setq ylist (new-vectori-double (times numu numv)))
      (setq zlist (new-vectori-double (times numu numv)))
      (cond((not(eq numu 1))
	    (setq partu (quotient
			   (float(difference hiu lowu))
			   (difference numu 1))))
		    (t(setq partu (float (difference hiu lowu)))))
      (cond((not (eq numv 1))
	    (setq partv (quotient
			   (float(difference hiv lowv))
			   (difference numv 1))))
		 (t(setq partv (float (difference hiv lowv)))))
      (prog ()
	 ;;; initialize loop counter
	 (setq i 0
	       uu (difference lowu partu)
	       index 0)
	 ;;;
	 ;;; outer loop
	 ;;;
	 (show-status "Generating Points")
	 uloop
	 (cond((not(lessp i numu))(go plot)))
	 (setq uu (plus uu partu))
	 (set u uu)
	 ;;; initialize loop
	 (setq j 0 vv (difference lowv partv))
	 ;;;
	 ;;;   start inner loop
	 ;;;
	 vloop
	 (cond ((not(lessp j numv))(go endv)))
	 (setq vv (plus vv partv))
	 (set v vv)
	 ;;;
	 ;;; evaluate the function and store
	 ;;; in array
	 ;;;
	 (vseti-double xlist index (meval fx))
	 (vseti-double ylist index (meval fy))
	 (vseti-double zlist index (meval fz))
	 ;;; increment loop counter
	 (setq j (add1 j ))(setq index
				 (add1 index))
	 (go vloop)
	 endv
	 ;;; increment outer loop counter
	 (setq i (add1  i))
	 (go uloop)
	 plot
	 ;;;
	 ;;; cal
	 ;;;
	 (setq kind-of-plot `(plot3d (quote ,xlist)(quote ,ylist)(quote ,zlist)
				     ,lowu ,hiu ,lowv ,hiv
				     ,numu ,numv))
	 (clear-status)
	 (show-status "Plotting")
	 (plot3d xlist ylist zlist lowu hiu lowv
		 hiv numu numv
		 (float $xangle)
		 (float $yangle)
		 (float $zangle)
		 $hidden
		 (+ 10. (rect->x(get 'plot 'screenrect)))
		 (+ 10. (rect->y(get 'plot 'screenrect)))
		 (- (+(rect->w(get 'plot 'screenrect))
				   (rect->x(get 'plot 'screenrect))) 20.)
		 (- (+(rect->h(get 'plot 'screenrect))
				   (rect->y(get 'plot 'screenrect))) 20.)
		 **screen
		 (get $polystyle 'style)
		 )
	 (clear-status)
	 (set v tempv)(set u tempu)
	 )
      )
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: MOUSE_PLOT
;;;   
;;;      Purpose: top level plot function, uses the mouse to select
;;;               expresssions for plotting, and calls the proper
;;;               function.
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:03:17 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun mouse_plot ()
   (prog(cmd exp1 exp2 exp3 y1 exp expcount lastchoice  pt1 button)
	     (setq expcount 0)
	     loop
	     (cond((equal expcount 3)(go plot)))
	     (setq expcount (1+ expcount))
	     (show-status '|Select exp(s) with left button, any other to end|)
	     (setf pt1 (make-point))
	     (setq button (wait-mouse-click m_any))
	     (setf pt1 (get_rel_mposition pt1))
	     (clear-status)
	     (cond((= button m_left)
		   (setq  exp (append1 exp
				       (select-d-line
					  (-(point->y pt1) 2)
					  (+ (point->y pt1) 2))))
		   (go loop)))
	     plot

	     (make-window :name 'plot :rectangle
			  (rect-from-user))
	     (cond ((null exp)(tyo 7)(return))
	           ((equal 1 (length exp))(mplot1 (eval(car exp))))
		   ((equal 2 (length exp))
		    (mplot2 (eval (car exp)) (eval (cadr exp))))
		   ((equal 3 (length exp))
		    (mplot3 (eval (car exp))
			    (eval (cadr exp))
			    (eval (caddr exp))))
		   (t(return)))
	     (mouse-cmd-loop)))

(putprop 'plot 'mouse-cmd-loop 'entry-function)

   (defun mouse-cmd-loop ()

 	     (do((button (get_buttons)(get_buttons))
	         (choice nil nil))
	        ((or(equal lastchoice  '(delete-window **current-window**))
		    (equal lastchoice '(exit-plot-package)))(return))
		(cond((equal button  m_middle)
		      (setq choice (menu-choose **top-level-menu**))
		      (eval choice)
		      (cond((equal choice 
		                   '(delete-window **current-window**))
			    (return))))
		     ((equal button m_right)
		        (setq choice 
			     (menu-choose 
			        (make-menu 
				 `((,(strcat "X Rotation   : " (eval $xangle)) 
				             (set-xangle))
				   (,(strcat "Y Rotation   : " (eval $yangle)) 
				             (set-yangle))
				   (,(strcat "Z Rotation   : " (eval $zangle)) 
				             (set-zangle))
         		           (,(strcat "Hidden Lines : " (eval $hidden))
				             (hidden-lines-toggle))
				 ("Replot" (replott))
				 ("Exit Plot Package" (exit-plot-package)))
				  :title "Plot Options")))
			(setq lastchoice choice)
			(eval choice))))
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: TOGGLE-POLY-STYLE
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Mar 22 18:44:19 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun toggle-poly-style  ( )
   (setq $polystyle (pop $polystylelist))
   (setq $polystylelist (append1 $polystylelist $polystyle))
 )  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: SET-XANGLE
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Feb 22 21:24:30 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun  set-xangle  ( )
   (setup-prompt-area)
   (paint-string 65. 55. " Enter new X Rotation Angle")
   (setq $xangle (read))
   (restore-prompt-area)
   )
(defun  set-yangle  ( )
   (setup-prompt-area)
   (paint-string 65. 55. " Enter new X Rotation Angle")
   (setq $yangle (read))
   (restore-prompt-area)

   )
(defun  set-zangle  ( )
   (setup-prompt-area)
   (paint-string 65. 55. " Enter new X Rotation Angle")
   (setq $zangle (read))
   (restore-prompt-area)
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: TOGGLE-HIDDEN-LINES
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Feb 22 21:42:56 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun hidden-lines-toggle  ( )
   (setq $hidden (not $hidden))
   )  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: EXIT-PLOT-PACKAGE
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Feb 22 21:25:33 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun exit-plot-package  ( )
  (delete-window 'plot)
 )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: REPLOTT
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Sat Feb 22 21:47:00 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun replott  ( )
   (draw-rectangle (get 'plot 'screenrect) :halftone whitehalftone)
   (show-status "Plotting")
   (cond((equal (car kind-of-plot) 'plot3d)
	 (eval(append kind-of-plot
		      (list (float $xangle)
			    (float $yangle)
			    (float $zangle)
			    $hidden
			    (+ (rect->x(get 'plot 'screenrect)) 10.)
			    (+ (rect->y(get 'plot 'screenrect)) 10.)
			    (- (+(rect->w(get 'plot 'screenrect))
					      (rect->x(get 'plot 'screenrect))) 20.)
			    (- (+(rect->h(get 'plot 'screenrect))
					      (rect->y(get 'plot 'screenrect))) 20.)
			    **screen
                            (get $polystyle 'style)
			    ))))
		((equal (car kind-of-plot) 'plot2d)
		 (eval (append kind-of-plot
			       (list (+ 10.  (rect->x(get 'plot 'screenrect)))
				     (+ 10. (rect->y(get 'plot 'screenrect)))
				     (- (rect->w(get 'plot 'screenrect)) 20.)
				     (- (rect->h(get 'plot 'screenrect)) 20.))))))
   (clear-status)
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: GETVARS
;;;   
;;;      Purpose: returns the independant variables in an expression
;;;               works by eliminating known atoms (sin mplus etc)
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:04:33 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun getvars (exp)
   (prog (ll varlist)
      (cond ((atom exp)(setq exp (list exp))))
      (setq ll (strip exp))
      loop
      (cond ((null ll)(return varlist)))
      (cond ((not(or(numberp (car ll))
			     (symfunctionp (car ll))))
	     (if (not (member (car ll) varlist))
		 (push (car ll) varlist))))
      (setq ll (cdr ll))(go loop)))
;;;--------------------------------------------------------------
;;; see if an atom is a macsyma function
;;;--------------------------------------------------------------
(defun symfunctionp (a)
   (member a '( mplus mminus mtimes simp %sin %cos %tan mexpt
		mlist factored irreducible %derivative %integrate
		rat $matrix )))	   

;;;---------------------------------------------------------------
;;; plot function consisting of on exp - could be
;;; y = f(x) 
;;; or
;;; z = f(x,y)
;;;----------------------------------------------------------------

(defun mplot1 (exp)
   (prog (var hi xlo ylo pts xhi yhi lo)
      (cond((listp exp) (setq exp (sublis '(($%pi . 3.1415926535897323846)
					    ($%e . 2.7182818284504523536)
					    ($%phi . 1.61803398874989484820)
					    ($%gamma . 0.5772156649015328606)
					    )
					  exp))))
      (setq var (getvars exp))
      ;;;
      ;;;   If there are no vars then then expression must be a constant
      ;;;
      (cond((= (length var) 0)
	    (plt exp (car var) (list 0 0)))
	       ;;;
	       ;;;   If one expression with one var then the form is y = f(x)
	       ;;;
	       ((= (length var) 1)
		(setup-prompt-area)
		(paint-string 65. 55. (strcat "plotting:   f("
					      (stripdollar(car var))  ")"))
		(paint-string 65. 65. (strcat "enter range low - hi, for "
					      (stripdollar(car var)) ": "))

		(setq lo (float(read)))
		(setq hi (float(read)))
		(restore-prompt-area)
		(setq pts (fix (quotient (rect->w (get 'plot 'rect)) 6.)))
		(plt  exp (car var) (list lo hi pts))
		)
	       ;;;
	       ;;;   if one exp with 2 vars then the form is z = f(x,y)
	       ;;;
	       ((= (length var) 2)

		(setup-prompt-area)
		(paint-string  65. 55. (strcat "plotting:   f("
					       (stripdollar(car var))  ","
					       (stripdollar(cadr var))  ")"))
		(paint-string 65. 65. (strcat "enter range low - hi, for "
					      (stripdollar(car var)) ": "))
		(setq xlo (float(read)))
		(setq xhi (float(read)))

		(paint-string 65. 75. (strcat "enter range low - hi, for "
					      (stripdollar(cadr var)) ": "))
		(setq ylo (float (read)))
		(setq yhi (float (read)))

		(restore-prompt-area)
		(setq pts (fix (quotient (rect->w (get 'plot 'screenrect)) 10.)))
		(plot3dpar  exp  var (list xlo xhi pts ylo yhi pts)))
	       ;;;
	       ;;;   Else the expression is not a type we can handle
	       ;;;
	       (t(setup-prompt-area)
		  (paint 65. 65.  "bad expression")
		  (restore-prompt-area)
		  (delete-window 'plot)))))


;;;---------------------------------------------------------------
;;; plot function consisting of two exps - could be
;;; x = f(s) 
;;; y = f(s)
;;;----------------------------------------------------------------

(defun mplot2 (exp1 exp2)
   (prog ( var1 var2 lo hi pts var)
      (cond((listp exp1)
	    (setq exp1 (sublis '(($%pi . 3.1415926535897323846)
				 ($%e . 2.7182818284504523536)
				 ($%phi . 1.61803398874989484820)
				 ($%gamma . 0.5772156649015328606)
				 )
			       exp1))))
      (cond((listp exp2)
	    (setq exp2 (sublis '(($%pi . 3.1415926535897323846)
				 ($%e . 2.7182818284504523536)
				 ($%phi . 1.61803398874989484820)
				 ($%gamma . 0.5772156649015328606)
				 )
			       exp2))))
      (setq var1 (getvars exp1))
      (setq var2 (getvars exp2))
      ;;; check for errors
      (cond((or (> (length var1) 1)(> (length var2) 1))
	    (beep)(return))
		;;;
		;;; if both are lenght 1
		;;;
		((and (= (length var1) 1)(= (length var2) 1)
		      (not (= (car var1)(car var2))))
		 (beep)(return))
		((= (length var1) 1)
		 (setq var var1))
		((= (length var2) 1)
		 (setq var var2))
		(t(beep)(return)))
      (setup-prompt-area)
      (paint-string 65. 55. (strcat "plotting:   f("
				    (stripdollar(car var))  ")"))
      (paint-string 65. 65. (strcat "enter range low - hi, for "
				    (stripdollar(car var)) ": "))

      (setq lo (float(read)))
      (setq hi (float(read)))
      (restore-prompt-area)
      (setq pts (// (rect->w (get 'plot 'rect)) 4))
      (prm  exp1 exp2 (car var1) (list lo hi pts))
      )
   )



;;;---------------------------------------------------------------
;;; plot function consisting of on exp - could be
;;; x = f(s,t) 
;;; y = g(s,t)
;;; z = h(s,t)
;;;----------------------------------------------------------------

(defun mplot3 (exp1 exp2 exp3)
   (prog ( var1 var2 var3 var xlo ylo xhi yhi pts wpts hpts)
      (cond((listp exp1)
	    (setq exp1 (sublis '(($%pi . 3.1415926535897323846)
				 ($%e . 2.7182818284504523536)
				 ($%phi . 1.61803398874989484820)
				 ($%gamma . 0.5772156649015328606)
				 )
			       exp1))))
      (cond((listp exp2)
	    (setq exp2 (sublis '(($%pi . 3.14159)($%e . 1.78)) exp2))))
      (cond((listp exp3)
	    (setq exp3 (sublis '(($%pi . 3.14159)($%e . 1.78)) exp3))))
      (setq var1 (getvars exp1))
      (setq var2 (getvars exp2))
      (setq var3 (getvars exp3))
      (setq var (append var1 var2 var3))
      (setq var (remove_duplicates var))
      (cond((= (length var) 1)
	    (setup-prompt-area)
	    (paint-string 65. 55. (strcat "plotting:   f("
					  (stripdollar(car var))  ")"))
	    (paint-string 65. 65. (strcat "enter range low - hi, for "
					  (stripdollar(car var)) ": "))
	    (setq xlo (float(read)))
	    (setq yhi (float(read)))
	    (restore-prompt-area)
	    (setq pts (fix(quotient (rect->w (get 'plot 'rect)) 20.)))
	    (surf exp1 exp2 exp3 var
		  (list xlo xhi pts ylo yhi pts)))
	       ((= (length var) 2)
		(setup-prompt-area)
		(paint-string 65. 55. (strcat "plotting:   f("
					      (stripdollar(car var))  ","
					      (stripdollar(cadr var))  ")"))
		(paint-string 65. 65. (strcat "enter range low - hi, for "
					      (stripdollar(car var)) ": "))
		(setq xlo (float(read)))
		(setq xhi (float(read)))
		(paint-string 65. 75. (strcat "enter range low - hi, for "
					      (stripdollar(cadr var)) ": "))
		(setq ylo (float(read)))
		(setq yhi (float(read)))
		(restore-prompt-area)
		(setq wpts (fix (quotient (rect->w (get 'plot 'rect)) 20.)))
		(setq hpts (fix(quotient (rect->h (get 'plot 'rect)) 20.)))
		(surf exp1 exp2 exp3 var
		      (list xlo xhi wpts ylo yhi hpts)))
	       (t(princ '|cant handle this type|)))))
;;;---------------------------------------------------------------
;;; get rid of multiple occurences of the same member of a list
;;;
(defun remove_duplicates (var)
   (prog (ll newvar)
      (cond((= 1 (length var))(return var)))
      (setq ll (car var) var (cdr var))
      loop
      (cond ((null var)
	     (setq newvar (append1 newvar ll))
	     (return newvar)))
      (cond((member ll var))
		    (t (setq newvar (append1 newvar ll))))
      (setq ll (car var) var (cdr var))(go loop)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: PLOT2D
;;;   
;;;      Purpose: Actually plot a two D function
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:05:54 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun plot2d (xlist ylist lo hi pts x1 y1 w1 h1)
   (prog (maxx minx maxy miny startx starty)
      (setq maxx (apply 'max xlist))
      (setq minx (apply 'min xlist))
      (setq maxy (apply 'max ylist))
      (setq miny (apply 'min ylist))
      (draw-axis minx miny maxx maxy x1 y1 w1 h1)
      (setq x1 (+ 40. x1) w1 (- w1 80.))
      (setq y1 (-(+ y1 h1) 20.) h1 (minus (- h1 40.)))
      (setq xlist
	    (mapcar '(lambda (a)
			(fix (plus x1
				   (quotient (times w1
						    (difference a minx))
					     (difference maxx minx)))))
		    xlist))
      (setq ylist
	    (mapcar '(lambda (a)
			(fix(plus y1
				  (quotient (times h1
						   (difference a miny))
					    (difference maxy miny)))))
		    ylist))
      (setq startx (car xlist) starty (car ylist)
	    xlist (cdr xlist)  ylist (cdr ylist))
      loop
      (cond((null xlist)(go end)))
      (draw-line (make-point x startx y starty)
		 (make-point x (car xlist) y (car ylist))
		 :cliprect (get 'plot 'screenrect)
		 )
      (setq startx (car xlist) starty (car ylist)
	    xlist (cdr xlist)  ylist (cdr ylist))
      (go loop)
      end

      ))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: DRAW-AXIS
;;;   
;;;      Purpose: draw an axis and grid in the plot window
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 11 23:06:21 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun draw-axis (minx miny maxx maxy x1 yy w1 hh)
   (prog (x-zero-pt y1 h1 y-mark x-mark y-zero-pt start)
      (setq x1 (+ 40. x1) w1 (- w1 80.)
	    y1 (-(+ yy hh) 20.) h1 (minus (- hh 40.)))
      ;;;
      ;;;   draw y-axis
      ;;;
      (cond((lessp minx 0. maxx)
	    (setq x-zero-pt
		  (fix (plus x1
			     (quotient(times w1
					     (abs minx))
					     (difference maxx minx))))))
		   (t(setq x-zero-pt x1)))
      (setq start y1 y-mark miny)
      (paint-string
	 (fix(difference x-zero-pt
			 (quotient(stringsize(strcat (scalefix y-mark 4.))
						     **font) 2)))
	 (+ start 5.)
	 (strcat (scalefix y-mark 4.))
	 )
      yloop
      (cond((<= start (+ y1 h1))
	    (paint-string
	       (fix (difference x-zero-pt
				(quotient(stringsize
					    (strcat (scalefix y-mark 4.))
					    **font) 2.)))
	       (fix (-(+ y1 h1) lg-character-y 5.))
	       (strcat (scalefix maxy 2.))
	    )
	    (draw-line (make-point x (fix(difference x-zero-pt 3.))
				   y (fix (+ y1 h1)))
		       (make-point x (fix (+ x-zero-pt 3.))
				   y (fix (+ y1 h1)))
		       )
	    (go yend)))
      (draw-line (make-point x (fix (difference x-zero-pt 3.))
			     y  (fix start))
		 (make-point x (fix(+ x-zero-pt 3.))
			     y (fix start))
		 )
      (setq start  (plus start (times h1 0.1)))
      (go yloop)
      yend
      (draw-line (make-point x x-zero-pt y y1)
		 (make-point x x-zero-pt y (plus y1 h1))
		 )

      ;;;
      ;;;   draw x axis
      ;;;
      (cond((lessp miny 0. maxy)
	    (setq y-zero-pt
		  (fix(plus y1 (quotient(times h1
					       (abs miny))
					       (difference maxy miny))))))
		   (t(setq y-zero-pt y1)))

      (setq start x1 x-mark minx)
      (paint-string (- x1 (stringsize
			     (strcat (scalefix y-mark 4.))
			     **font) 2.)
		    (fix (- y-zero-pt lg-character-y-2))
		    (strcat (scalefix x-mark 2.)))
      xloop

      (cond((>= start (+ x1 w1))
	    (paint-string (fix(+ x1 w1  5.))
			  (fix (- y-zero-pt lg-character-y-2))
			  (strcat (scalefix maxx 2.))
	    )
	    (do ((yy y1 (plus yy (times 0.1 h1))))
		((greaterp (plus y1 h1 (minus 2.)) yy))
		(draw-line (make-point x (+ x1 w1) y (fix yy))
			   (make-point x (+ x1 w1) y (fix yy))
			   ))
	    (draw-line (make-point x (+ x1 w1) y (difference y-zero-pt 3.))
		       (make-point x (+ x1 w1) y (+ y-zero-pt 3))
		       )

	    (go xend)))
      (do ((yy y1 (plus yy (times 0.1 h1))))
	  ((greaterp (plus y1 h1 (minus 2.)) yy))
	  (draw-line (make-point x (fix start) y (fix yy))
		     (make-point x (fix start) y (fix yy))
		     ))
      (draw-line (make-point x (fix start) y (difference y-zero-pt 3.))
		 (make-point x (fix start) y (+ y-zero-pt 3.))
		 )
      (setq start (plus start (times w1 0.1)))
      (go xloop)
      xend
      (draw-line (make-point x x1 y y-zero-pt)
		 (make-point x (+  x1 w1) y y-zero-pt))
      )
   )


   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;   Function: SCALEFIX
   ;;;
   ;;;      Purpose: return a flonum rounded to places
   ;;;
   ;;;      Written By: Douglas A. Young
   ;;;      Date: Thu Feb 13 19:59:30 1986
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   (defun scalefix  (number places)
	  (quotient (float (fix (times number (expt 10.0 places)))) 
	                      (expt 10.0 places))
	  )  

   

