;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; entry point to the display package. Displa is the dimensioning pass.
;;; After an expression is dimensioned, the output function draws it
;;; Many of these functions are taken from the Macsyma displa file, and
;;; could be cleaned up considerably. There is a simple unified appraoch
;;; to all functions, but you'd never know it from the original
;;; functions.
;;;   
;;;   
(eval-when (compile) (macsyma-module displa))
(load '//user//vaxima//young//displa//macros)
(declare
   (macros t)
   (special ttyoff writefilep displayp linearray d-moreflush d-moremsg
	    $linel linel smart-tty scrollp $cursordisp ttyheight 
	    $display_format_internal maxht maxdp width height depth level
	    size break lines bkpt bkptwd bkptht bkptdp bkptout
	    bkptlevel $aliases stringdisp $lispdisp $pfeformat whitehalftone
	    old-row  $linenum lg-character-y
	    $derivabbrev lop rop $absboxchar remform $noundisp
	    $boxchar $leftjust right hh mratp ))
(defun displa (form)
   (setq form (sublis greek-list form))
   (prog ()
      (if (or (not (eval ttyoff)) (eval writefilep))
	  (cond
	     (t(let ((displayp t)
		     (linearray (if displayp (make-linearray 80.)
				    linearray))
		     (mratp (checkrat form))
		     ((eval writefilep) (eval writefilep))
		     (maxht   1)   (maxdp   0) (width  0)
		     (height    0) (depth   0) (level   0) (size   2)
		     (break     0) (right   0) (lines   1) bkpt
		     (bkptwd    0) (bkptht  1) (bkptdp  0) (bkptout 0)
		     (bkptlevel 0) in-p
		     (moreflush d-moreflush)
		     more-^w
		     (moremsg d-moremsg))
		  (unwind-protect
		     (progn (setq form
				  (dimension
				     form nil 'mparen 'mparen 0 0))
			    (checkbreak form width)
			    (output form
				    (if (= 2 lines) then
					(- $linel (- width bkptout))
				       else
					    0))
				))))))))
    

(setq $display_format_internal nil)
;;;	 "setting this true can help give the user a greater understanding
;;;	 of the behavior of macsyma on certain of his problems,
;;;	 especially those involving roots and quotients"

(defun nformat-check (form)
   (if (and $display_format_internal
	    (not (or (atom form) (atom (car form))
		     (eq (caar form) 'mrat))))
       form
       (nformat form)))
;;;
(defun dimension (form result lop rop w right)
   (let ((level (1+ level)) (break (if (and w break) (+ w break))))
      (setq form (nformat-check form))
      (cond ((atom form)
	     (dimension-atom form result))
	    ((and (atom (car form)) (setq form (cons '(mprogn) form)) nil))
	    ((or (<= (lbp (caar form)) (rbp lop))
		 (> (lbp rop) (rbp (caar form))))
	     (dimension-paren form result))
	    ((memq 'array (car form)) (dimension-array form result))
	    ((get (caar form) 'dimension)
	     (funcall (get (caar form) 'dimension) form result))
	    (t (dimension-function form result)))))

(defun dim-bigfloat (form result) 
    (dimension-atom (maknam (fpformat form)) result))
(defvar atom-context 'dimension-list)
(declare (*expr dimension-array-object)) ; to be defined someplace else.
;; referenced externally by rat;float.
(defun dimension-atom (form result)
   (cond ((and (symbolp form) (get form atom-context))
	  (funcall (get form atom-context) form result))
	 ((eq (typep form) 'array)
	  (dimension-array-object form result))
	 (t (dimension-string (makestring form) result))))

(defun dim-greek (form result)
    (prog ()
	  (setq width 1)
          (setq n (cadr form))
	  (push  n result)
	  (update-heights height depth)
          (return result)))

(defun dimension-string (dummy result &aux crp)
   (setq width 0 height 1 depth 0)
   (do l dummy (cdr l) (null l)
       (increment width)
       (if (= (car l) 10.) (setq crp t)))

   (if (or (and (checkfit width) (not crp)) (not break))
       (nreconc dummy result)
       (setq width 0)
       (do ((l dummy) (w (- $linel (- break bkptout))))
	   ((null l) (checkbreak result width) result)
	   (setq dummy l l (cdr l))
	   (cond ((= (car dummy) 10.)
		  (forcebreak result width)
		  (setq result nil w (+ $linel width)))
		 (t (increment width)
		    (when (and (= w width) l)
			  (forcebreak (cons #/# result) width)
			  (setq result nil w (+ $linel width))
			  (increment width))
		    (setq result (rplacd dummy result)))))))

(defun makestring (atom)
   (let (dummy)
      (cond ((numberp atom) (exploden atom))
	    #+nil
	    ((not (symbolp atom)) (exploden atom))
	    ((and (setq dummy (get atom 'reversealias))
		  (not (and (memq atom $aliases) (get atom 'noun))))
	     (exploden dummy))
	    ((not (eq (getop atom) atom))
	     (setq dummy (exploden (getop atom)))
	     (if (= #/& (car dummy))
		 (cons #/" (nconc (cdr dummy) (list #/")))
	    (cdr dummy)))
   (t (setq dummy (exploden atom))
      (cond ((= #/$ (car dummy)) (cdr dummy))
	    ((and stringdisp (= #/& (car dummy)))
	     (cons #/" (nconc (cdr dummy) (list #/"))))
   ((or (= #/% (car dummy)) (= #/& (car dummy))) (cdr dummy))
   ($lispdisp (cons #/? dummy))
   (t dummy))))))

(defun dim-mncexpt (form result)
   (dimension-superscript
      (list '(mncexpt) (cadr form) (cons '(mangle) (cddr form)))
      result))

;;;----------------------------------------------------------------
;;; function to dimension the sqrt figure
;;;----------------------------------------------------------------
(defun dimension-sqrt (form result)
   (prog (dummy)
      ;;;
      ;;; dimension the string inside the square root, and store in dummy
      ;;;
      (setq dummy (dimension (cadr form) nil 'mparen 'mparen nil 0))
      ;;;
      ;;; check if it will fit the screen
      ;;;
      (cond((not(checkfit(+ 2 width)))
	    (return (dimension-function
		       (cons '(%sqrt) (cdr form)) result)))
			    ;;;
			    ;;; if it fits, add the d-sqrt function and it's args
			    ;;;
			    (t (setq result (append '( (2 0)) result))
			       (cond((= 1 width)
				     (push `(d-sqrt ,height ,depth ,width ) result))
					(t(push `(d-sqrt ,height ,depth ,(+ 1 width))
						 result)))
			       (push '(begin-list) result)
			       ;;;
			       ;;; add the string be contained in the sqrt symbol
			       ;;;
			       (setq result ( append  dummy result))
			       (setq result (append '((end-list)) result))
			       ;;;
			       ;;; adjust the width to allow for the drawing of the symbol
			       ;;;
			       (setq width (+ 2 width)
				     height (1+ height)
				     ;                        depth (1+ depth)
				     )
			       (update-heights height depth)
			       (return result)
			       )
			    )
      )
   )

;;;-----------------------------------------------------------------
;;; dimension the integral sign, with variable size
;;;-----------------------------------------------------------------
(defun dim-%integrate (form result)
   (prog (dummy dummy1 w h d dummy2 xx xx2 yy yy2 type)
      (declare (fixnum w h d))
      (cond ((null (cddr form)) (wna-err (caar form)))
	    ((null (cdddr form))
	     (setq
		w 2 h 5 d 4))
	    (t (setq dummy1
		     (dimension (cadr (cdddr form))
				nil 'mparen 'mparen nil 0)
		     w width h (+ 2 height) d (+ 2 depth))
	       (setq dummy2
		     (dimension (cadddr form) nil 'mparen 'mparen nil 0))
	       (if (not (checkfit (+ 2 (max w width))))
		   (return (dimension-function form result)))
	       ))
      (setq dummy (dimension (cadr form) dummy '%integrate 'mparen w 2)
	    w (+ w width) h (max h height) d (max d depth))
      (push (list 'end-list) dummy)
      (push (list 'begin-list) dummy)
      (push '(2 0) dummy)
      (push #/d dummy)
      (setq dummy (dimension (caddr form) dummy '%integrate 'mparen w 2)
	    w (+ w width) h (max h height) d (max d depth))
      (cond((not(null dummy1))(setq type 2)
	    (setq h (1+ h) d (1+ d))
	    (setq xx  (-(+ 2 (// (+ h d)4)))
		  xx2 (* 2 (- (abs xx) 2))
		  yy    (-	(+ 1 (// (+ d h) 2)))
		  yy2   (// (+ 2 h d) 2))
	    (setq dummy1 (append (list xx2
				       yy2) dummy1))
	    (setq dummy2 (append  (list xx yy ) dummy2))
	    (setq dummy (append dummy (list '(begin-list))
				(list '(big_char))
				(list dummy1)
				(list dummy2)
				(list '(small_char))
				(list '(2 0)))))
		      (t(setq type 1
			      dummy (append dummy
					    (list '(begin-list))
					    (list '(2 0 ))))))
      (setq dummy
	    (append dummy (list `(d-integralsign ,h ,d ,type))
		    (list '(2 0)) result))
      (cond((= type 1)(setq height (1+ h) depth d width (+ 4 w)))
	       (t(setq height (+ 1 h) depth (+ 2 d) width (+ 4 w))))
      (update-heights height depth)
      (setq dummy (append '((end-list)) dummy))
      (return dummy)))

(defun dim-mabs (form result &aux arg bar)
   (setq arg (dimension (cadr form) nil 'mparen 'mparen nil 0))
   (setq width (+ 2 width))
   (update-heights height depth)
   (append (list '(1 0))(list `(d-vbar-r ,height ,depth ))
	   (list(list 'end-list)) arg
	   (list(list 'begin-list))(list '(1 0))
	   (list `(d-vbar-l ,height ,depth )) result)
   )

(defun dim-%product (form result) (dsumprod form result '(d-prodsign) 5 3 1))

(defun dim-rat (form result)
    (if $pfeformat (dimension-nary form result) (dim-mquotient form result)))

(defun dim-mquotient (form result)
   (if (or (null (cddr form)) (cdddr form)) (wna-err (caar form)))
   (prog (num w h d den)
      (declare (fixnum w h d))
      (if (and (= 1 size) (atom (cadr form)) (atom (caddr form)))
	  (return (dimension-nary form result)))
      (setq num (dimension (cadr form) nil 'mparen 'mparen nil right)
	    w width h height d depth)
      (if (not (checkfit w)) (return (dimension-nary form result)))
      (setq den (dimension (caddr form) nil 'mparen 'mparen nil right))
      (if (not (checkfit width)) (return (dimension-nary form result)))
      (return (dratio result num w h d den width height depth))))


#.(prog2 (setq x1 'h1 x2 'd2) t)

(defun dratio (result num w1 h1 d1 den w2 h2 d2)
   (prog (x1 x2)
   (declare (fixnum w1 h1 d1 w2 h2 d2))
   (setq width (max w1 w2) height (+  1 h1 d1) depth (+ 1 h2 d2))
   (setq x1 (// (- width w1) 2) x2 (// (- (1+ width) w2) 2))
   (update-heights height depth)
   (push `(d-hbar ,width) result)
   (push `(,(- x1 width) ,(1+ d1) .  ,num) result)
   (push `(,(- x2 (+ x1 w1)) ,(- h2) .  ,den) result)
   (push `(,x2 0) result)
   (return result)))


(defun dim-%derivative (form result)
   (prog ()
      (cond ((null (cddr form))
	     (return (dimension-function
			(cons '(%diff) (cdr form)) result))))
      (cond ((null (cdddr form)) (setq form (append form '(1)))))
      (cond ((and $derivabbrev
		  (do ((l (cddr form) (cddr l))) ((null l) t)
		      (cond ((and (atom (car l))
				  (fixp (cadr l)) (> (cadr l) 0)))
			    (t (return nil)))))
	     (return (dmderivabbrev form result)))

	    ((or (> (rbp lop) 130.) (> (lbp rop) 130.)
		 (and (not (atom (cadr form)))
		      (or (> (rbp lop) 110.) (> (lbp rop) 110.))))
	     (return (dimension-paren form result)))
	    (t (return (dmderivlong form result))))))

(defun dmderivabbrev (form result)
   (prog (dummy w) (declare (fixnum w))
      (setq w 0)
      (do ((l (cddr form) (cddr l)) (var))
	  ((null l) (setq dummy (cdr dummy) w (1- w)))
	  (setq var (dimension (car l) nil 'mparen 'mparen nil 0))
	  (do i (cadr l) (1- i) (= 1 i)
	      (setq dummy (cons '(1 0) (append var dummy))))
	  (setq dummy (cons '(1 0) (nconc var dummy))
		w (+ w (cadr l) (* (cadr l) width))))
      (setq result (dimension (cadr form) result lop '%deriv 0 right))
      (setq result (cons (cons 0 (cons (- 0 depth 1) dummy)) result)
	    width (+ w width) depth (max 1 (1+ depth)))
      (update-heights height depth)
      (return result)))

(defun dmderivlong (form result)
   (prog (num w1 h1 d1 den w2 h2 d2 dummy4 dummy5 )
      (declare (fixnum w1 h1 d1 w2 h2 d2))
      (setq remform (lcase (mstring form)))
      (setq num (list (cadddr form))
	    den (cond ((equal 1 (cadddr form))

		       (dimension (caddr form)
				  (list 200. ) 'mparen 'mparen nil 0))
		      (t (dimension-superscript (cons '(diff)
						      (cddr form))
						(list  200.))))
	    w2 (1+ width) h2 height d2 depth)
      ;;;
      ;;; loop for all pairs in the list
      ;;;
      (do l (cddddr form) (cddr l) (null l)
	  (setq num (cons (cadr l) num)
		;;;
		;;; if 1st derivative
		;;;
		den (cond ((equal 1 (cadr l))
			   (dimension (car l) (cons  200.
						     (cons '(1 0) den))
				      'mparen 'mparen nil 0))
			  (t (dimension-superscript
				(cons '(diff) l)
				(cons 200. (cons '(1 0) den))))) 
		w2 (+ 2 w2 width) h2 (max h2 height) d2 (+ d2 depth))) 
      (setq num (nformat-check (addn num t)))
      (cond ((equal 1 num) (setq num (list 200.) w1 1 h1 1 d1 0)
	     )
	    (t (setq num
		     (dimension-superscript (list '(diff)
						  '((mgreek simp) 200.)
						  num) nil)
		     w1 width h1 height d1 depth)
	       ))
      (cond ((atom (setq form (nformat-check (cadr form))))
	     (setq num (dimension form num '%deriv 'mparen nil 0)
		   w1 (+ w1 width))
	     (setq dummy5 (dratio nil num w1 h1 d1 den w2 h2 d2))
	     (push `(d-deriv ,width ,(1- height ) ,depth
			      ,remform) result)
	     (setq result (append dummy5 result))
	     (push '(end-deriv) result)
	     (return result))
	    (t
	       (setq dummy5 (dratio nil num w1 h1 d1 den w2 h2 d2)
		     w1 width h1 height d1 depth)
	       (setq dummy4 (dimension form (cons '(1 0) nil)
				       '%deriv rop w1 right)
		     width (+ 1 w1 width)
		     height (max h1 height)
		     depth (max d1 depth))
	       (push `(d-deriv ,(1+ width) ,(1- height)
				,depth ,remform) result)
	       (setq result (append dummy5 result))
	       (setq result (append dummy4 result))
	       (push '(end-deriv) result)
	       (update-heights height depth)
	       (return result)))))

(defun dim-%at (form result)
   (prog (exp w h d eqs)
      (declare (fixnum w h d))
      (if (or (null (cddr form)) (cdddr form)) (wna-err (caar form)))
      (setq exp (dimension (cadr form) result lop '%at nil 0)
	    w width h height d depth)
      (setq eqs (dimension
		   (cond ((not (eq 'mlist (caar (caddr form))))
			  (caddr form))
			 ((null (cddr (caddr form)))
			  (cadr (caddr form)))
			 (t (cons '(mcomma) (cdaddr form))))
		   nil 'mparen 'mparen nil 0))
      (cond ((not (checkfit (+ 1 w width)))
	     (return (dimension-function form result))))
      (setq result (cons (cons 0 (cons (- 0 1 d) eqs))
			 (cons `(d-vbar-l ,(1+ h) ,(1+ d)
					 ,(getcharn $absboxchar 2)) exp))
	    width (+ 1 w width)
	    height (1+ h)
	    depth (+ 1 d depth))
      (update-heights height depth)
      (return result)))

(defun dim-mplus (form result)
   (cond ((and (null (cddr form))
	       (not (memq (cadar form) '(trunc exact))))
	  (if (null (cdr form))
	      (dimension-function form result)
	      (dimension-prefix (cons '(munaryplus) (cdr form)) result)))
	 (t (setq result (dimension (cadr form) result lop 'mplus 0 0))
	    (checkbreak result width)
	    (do ((l (cddr form) (cdr l))
		 (w width) (h height) (d depth)
		 (trunc (memq 'trunc (cdar form))) (dissym))
		((null l) (cond (trunc (setq width (+ 8 w) height h depth d)
				       (push-string " + . . ." result)))
		 result)
		(declare (fixnum w h d))
		(if (mmminusp (car l))
		    (setq dissym '((1 0) #/- (1 0)) form (cadar l))
		    (setq dissym '((1 0) #/+ (1 0)) form (car l)))
		(cond ((and (not trunc) (null (cdr l)))
		       (setq result (dimension form (append dissym result)
					       'mplus rop (+ 3 w) right)
			     width (+ 3 w width)
			     height (max h height)
			     depth (max d depth))
		       (return result))
		      (t (setq result
			       (dimension form (append dissym result)
					  'mplus 'mplus (+ 3 w) 0)
			       w (+ 3 w width)
			       h (max h height)
			       d (max d depth))
			 (checkbreak result w)))))))

(defun dimension-paren (form result)
   (prog (dummy)
      (setq dummy
	    (dimension form dummy 'mparen 'mparen 1 (1+ right)))
      (setq hh (// (+ height depth) 2))
      (push `(d-paren-l ,height ,depth) result)
      (push (list 1 0) result)
      (setq result (append dummy result))
      (if (> (+ height depth) 1) then (push (list 1 0) result))      
      (push  `(d-paren-r ,height ,depth) result)
      (push (list 2 0) result)
      (setq width (+ width 2)   depth (+ 2 depth))
      (update-heights height depth)
      (return result)))

(defun dimension-array (x result)
   (prog (dummy bas w h d sub) (declare (fixnum w h d))
      (setq w 0)
      (if (eq (caar x) 'mqapply) (setq dummy (cadr x) x (cdr x))
	  (setq dummy (caar x)))
      (cond ((not $noundisp))
	    ((and (get (caar x) 'verb) (get (caar x) 'alias))
	     (push-string "''" result) (setq w 2))
	    ((and (get (caar x) 'noun)
		  (not (memq (caar x) (cdr $aliases)))
		  (not (get (caar x) 'reversealias)))
	     (setq result (cons #/' result) w 1)))
      (setq sub (let ((lop 'mparen) (rop 'mparen) (break nil) (size 1))
		   (dimension-list x nil))
	    w (+ w width) h height d depth)
      (setq bas (if (and (not (atom dummy)) (memq 'array (car dummy)))
		    (let ((break nil) (right 0))
		       (dimension-paren dummy result))
		    (let ((atom-context 'dimension-array))
		       (dimension dummy result lop 'mfunction nil 0))))
      (cond ((not (checkfit (setq width (+ w width))))
	     (return (dimension-function
			(cons '(subscript)
			      (cons dummy (cdr x))) result)))
	    ((= #/) (car bas))
	    (setq result (cons (list* 'd-subscrip 0 (- h) sub) bas)
		  depth (max (+ h d) depth)))
      (t (setq result (cons (list* 'd-subscrip 0 (- (+ depth h)) sub) bas)
	       depth (+ h d depth))))
   (update-heights height depth)
   (return result)))

(defun dimension-function (x result)
   (prog (fun w h d) (declare (fixnum w h d))
      (setq w 0)
      (cond ((not $noundisp))
	    ((and (get (caar x) 'verb) (get (caar x) 'alias))
	     (push-string "''" result) (setq w 2))
	    ((and (get (caar x) 'noun)
		  (not (memq (caar x) (cdr $aliases)))
		  (not (get (caar x) 'reversealias)))
	     (setq result (cons #/' result) w 1)))
      (if (eq (caar x) 'mqapply)
	  (setq fun (cadr x) x (cdr x))
	  (setq fun (caar x)))
      (setq result (let ((atom-context 'dimension-function))
		      (dimension fun result lop 'mparen 0 1))
	    w (+ w width) h height d depth)
      (cond ((null (cdr x))
	     (setq result (list* #/) #/( result) width (+ 2 w)))
	    (t (setq result (let ((lop 'mparen) (rop 'mparen)
				  (break (if break (+ 1 w break))))
			       (cons #/)
			       (dimension-list x (cons #/( result))))
		     width (+ 2 w width)
		     height (max h height)
		     depth (max d depth))))
      (return result)))

(defun dimension-prefix (form result)
   (prog (dissym symlength)
      (declare (fixnum symlength))
      (setq dissym (get (caar form) 'dissym) symlength (length dissym))
      (setq result
	    (dimension (cadr form) (reconc dissym result)
		       (caar form) rop symlength right)
	    width (+ symlength width))
      (return result)))

(defun dimension-infix (form result)
   (if (or (null (cddr form)) (cdddr form)) (wna-err (caar form)))
   (prog (dissym symlength w h d)
      (declare (fixnum symlength w h d))
      (setq dissym (get (caar form) 'dissym) symlength (length dissym)
	    result
	    (dimension (cadr form) result lop (caar form) 0 symlength)
	    w width h height d depth)
      (setq result (reconc dissym result))
      (checkbreak result (+ symlength w))
      (setq result (dimension (caddr form) result
			      (caar form) rop (+ symlength w) right)
	    width (+ w symlength width) height (max h height)
	    depth (max d depth))
      (return result)))

(defun dimension-nary (form result)
   (cond ((null (cddr form)) (dimension-function form result))
	 (t (prog (dissym symlength w h d)
	       (declare (fixnum symlength w h d))
	       (setq dissym (get (caar form) 'dissym)
		     symlength (length dissym)
		     result (dimnary (cadr form) result lop
				     (caar form) (caar form) 0)
		     w width h height d depth)
	       (do ((l (cddr form) (cdr l))) (nil)
		   (checkbreak result w)
		   (setq result (reconc dissym result) w (+ symlength w))
		   (cond ((null (cdr l))
			  (setq result (dimnary (car l)
						result (caar form)
						(caar form) rop w)
				width (+ w width)
				height (max h height)
				depth (max d depth))
			  (return t))
			 (t (setq result
				  (dimnary (car l) result (caar form)
					   (caar form) (caar form) w)
				  w (+ w width)
				  h (max h height)
				  d (max d depth)))))
	       (return result)))))


(defun dimnary (form result lop op rop w)
   (cond ((and (not (atom form)) (eq op (caar form)))
	  (dimension-paren form result))
	 (t (dimension form result lop rop w right))))

(defun dimension-postfix (form result)
   (prog (dissym symlength) (declare (fixnum symlength))
      (setq dissym (get (caar form) 'dissym) symlength (length dissym))
      (setq result
	    (dimension (cadr form) result lop
		       (caar form) 0 (+ symlength right))
	    width (+ symlength width))
      (return (reconc dissym result))))

(defun dimension-nofix (form result)
    (setq form (get (caar form) 'dissym) width (length form))
    (reconc form result))

(defun dimension-match (form result)
   (prog (dissym symlength)
      (declare (fixnum symlength))
      (setq dissym (get (caar form) 'dissym)
	    symlength (length (car dissym)))
      (cond ((null (cdr form))
	     (setq width (+ symlength (length (cdr dissym)))
		   height 1 depth 0)
	     (return (reconc (cdr dissym) (reconc (car dissym) result))))
	    (t (setq result (let ((lop 'mparen) (rop 'mparen)
				  (break (cond (break
						  (+ symlength break)
						  )
					       )
					 )
				  (right (+ symlength right)))
			       (dimension-list form
					       (reconc (car dissym) result))))
	       (setq width (+ (length (cdr dissym)) symlength width))
	       (return (reconc (cdr dissym) result))))))

(defun dimension-superscript (form result)
   (prog (exp w h d bas)
      (declare (fixnum w h d w2 h2 d2))
      (setq exp (let ((size 1))
		   (dimension (caddr form) nil 'mparen 'mparen nil 0))
	    w width h height d depth)
      (cond ((and (not (atom (cadr form))) (memq 'array (cdaadr form)))
	     (prog (sub w2 h2 d2)
		(if (eq 'mqapply (caaadr form))
		    (setq bas (cadadr form) sub (cdadr form))
		    (setq bas (caaadr form) sub (cadr form)))
		(setq sub (let ((lop 'mparen) (break nil) (size 1))
			     (dimension-list sub nil))
		      w2 width
		      h2 height
		      d2 depth)
		(setq bas (dimension bas result lop 'mexpt nil 0))
		(cond ((not (checkfit (+ width (max w w2))))
		       (setq result
			     (dimension-function
				(cons '($expt) (cdr form)) result))
		       (return result)))
		(setq result (cons (cons 0 (cons (+ height d) exp))
				   bas))
		(setq result (cons (cons (- w) (cons (- (+ depth h2))
						     sub)) result))
		(setq result (cons (list (- (max w w2) w2) 0) result)
		      width (+ width (max w w2))
		      height (+ h d height)
		      depth (+ d2 h2 depth)))
	     (update-heights height depth)
	     (return result))
	    ((and (atom (caddr form)) (not (atom (cadr form)))
		  (not (get (caaadr form) 'dimension)))
	     (let (fun args)
		(if (eq 'mqapply (caaadr form))
		    (setq fun (cadadr form) args (cddadr form))
		    (setq fun (caaadr form) args (cdadr form)))
		(return (dimension-function
			   (list* '(mqapply)
				  (list '(mexpt) fun
					(caddr form)) args) result))))
	    (t (setq bas (dimension (cadr form) result lop 'mexpt nil 0)
		     width (+ w width))
	       (if (not (checkfit width))
		   (return (dimension-function
			      (cons '($expt) (cdr form)) result)))
	       (if (and (numberp (car bas))
			(= #/) (car bas)))
	       (setq result (cons (list* 'd-super 0 (1+ d) exp) bas)
		     height (max (+ 1 h d) height))
	       (setq result (cons (list* 'd-super 0 (+ height d) exp) bas)
		     height (+ h d height))
	       )
	    (update-heights height depth)
	    (return result)))))

(defun dsumprod (form result d-form sw sh sd)
   (declare (fixnum w h d sw sh sd))
   (prog (dummy w h d dummy2)
      (setq dummy2 (dimension (caddr form) nil 'mparen 'mequal nil 0)
	    w width h height d depth)
      (push '(end-list) dummy2)
      (push '(1 0) dummy2)
      (push  #/=  dummy2)
      (push '(1 0) dummy2)
      (push '(begin-list) dummy2)
      (setq dummy2 (dimension (cadddr form) dummy2 'mequal 'mparen nil 0)
	    w (+ 3 w width) h (max h height) d (max d depth))
      (setq dummy
	    (dimension (cadr (cdddr form)) nil 'mparen 'mparen nil 0))
      (cond ((not (checkfit (max w width)))
	     (return (dimension-function form result))))
      (setq dummy2 (list (cons (- sw) (cons (- (+ sd h)) dummy2))))
      (setq dummy2 (append dummy2
			   (list '(4 0))
			   (cons d-form result)))
      (cond ((> width sw) (setq sw 0))
	    (t (setq sw (// (- sw width) 2) width (+ sw width))))
      (setq dummy (cons (cons (- sw w) (cons (+ sh depth) dummy)) dummy2)
	    w (max w width) d (+ sd h d) h (+ sh height depth))
      (update-heights h d)
      (setq dummy (append  (list '(begin-list)) dummy))
      (setq dummy
	    (dimension (cadr form) (cons (list (1+ (- w width)) 0) dummy)
		       (caar form) rop w right)
	    width (+ 1 w width) height (max h height) depth (max d depth))
      (setq dummy (append  (list '(end-list)) dummy))
      (return dummy)))


(defun dim-%sum (form result) (dsumprod form result '(d-sumsign) 4 3 2))

(defun dim-%limit (form result)
   (prog (dummy w h d) (declare (fixnum w h d))
      (if (null (cdddr form)) (wna-err (caar form)))
      (setq dummy (dimension (caddr form) nil 'mparen 'mparen nil 0)
	    w width h height d depth)
      (push  '(end-list) dummy)
      (push  '(begin-list) dummy)
      (push  '(d-arrow) dummy)
      (push '(1 0) dummy)
      (push  '(end-list) dummy)
      (push  '(begin-list) dummy)
      (setq dummy (dimension (cadddr form) dummy 'mparen 'mparen nil 0)
	    w (+ 4 w width) h (max h height) d (max d depth))
      (push  '(end-list) dummy)
      (push  '(begin-list) dummy)
      (cond ((null (cddddr form)))
	    ((eq '$plus (caddddr form))
	     (push #/+ dummy)
	     (increment w))
	    (t (push #/- dummy)
	       (increment w)))
      (push '(d-limit) result)
      (setq dummy (cons (list* -4 (- h) dummy) result) d (+ h d))
      (update-heights 1 d)
      (push '(begin-list) dummy)
      (setq dummy (dimension (cadr form)
			     (cons '(1 0) dummy) '%limit rop (1+ w) right))
      (setq width (+ 1 w width)
	    depth (max d depth))
      (push '(end-list) dummy)
      (return dummy)))


(defun dim-$matrix (form result)
   (prog (dmstr rstr cstr listp)
      (if (or (null (cdr form)) (not (memq 'simp (cdar form)))
	      (memalike '((mlist simp)) (cdr form)))
	  (return (dimension-function form result)))
      (do l (cdadr form) (cdr l) (null l)
	  (setq dmstr (cons nil dmstr) cstr (cons 0 cstr)))
      (do ((r (cdr form) (cdr r)) (h1 0) (d1 0))
	  ((or listp (null r))
	   (setq width 0)
	   (do cs cstr (cdr cs) (null cs)
	       (setq width (+ 2 (car cs) width)))
	   (setq h1 (1- (+ h1 d1)) depth (// h1 2) height (- h1 depth)))
	  (declare (fixnum h1 d1))
	  (do ((c (cdar r) (cdr c))
	       (nc dmstr (cdr nc))
	       (cs cstr (cdr cs)) (dummy) (h2 0) (d2 0))
	      ((null c) (setq d1 (+ d1 h1 h2) h1 (1+ d2)))
	      (declare (fixnum h2 d2))
	      (setq dummy (dimension (car c) nil 'mparen 'mparen nil 0)
		    h2 (max h2 height) d2 (max d2 depth))
	      (cond ((not (checkfit (+ 14. width)))
		     (setq listp t) (return nil))
		    (t (rplaca nc (cons
				     (list* width height depth dummy)
				     (car nc)))
		       (rplaca cs (max width (car cs))))))
	  (setq rstr (cons d1 rstr)))
      (if (> (+ height depth) (linearray-dim)) (setq listp t))
      (return
	 (cond ((and (not listp) (checkfit (+ 2 width)))
		(matout dmstr cstr rstr result))
	       ((and (not listp) (<= level 2))
		(colout dmstr cstr result))
	       (t (dimension-function form result))))))

(defun matout (dmstr cstr rstr result)
   (push '(1 0) result)
   (push `(d-matrix left ,height ,depth ,(length dmstr)
		    ,(length (car dmstr))) result)

   (push '(2 0) result)
   (do ((d dmstr (cdr d)) (c cstr (cdr c)) (w 0 0)) ((null d))
       (declare (fixnum w))
       (do ((d (car d) (cdr d)) (r rstr (cdr r))) ((null d))
	   (rplaca (cddar d) (- height (car r)))
	   (rplaca (cdar d) (- (// (- (car c) (caar d)) 2) w))
	   (setq w (// (+ (car c) (caar d)) 2))
	   (rplaca d (cdar d)))
       (setq result (cons (list (+ 2 (- (car c) w)) 0)
			  (nreconc (car d) result))))
   (setq width (+ 2 width))
   (update-heights height depth)
   (rplaca (car result) (1- (caar result)))
   (push `(d-matrix right ,height ,depth
		    ,(length dmstr) ,(length (car dmstr))) result)
   result)

(defun colout (dmstr cstr result)
   (setq width 0 height 1 depth 0)
   (do ((r dmstr (cdr r))
	(c cstr (cdr c)) (col 1 (1+ col)) (w 0 0) (h -1 -1) (d 0))
       ((null r))
       (declare (fixnum col w h d))
       (push-string " col " result)
       (setq result (nreconc (exploden col) result))
       (push-string " = " result)
       (setq width (+ 8 (flatc col) width))
       (do ((r (car r) (cdr r))) ((null r))
	   (setq h (+ 1 h (cadar r) (caddar r)))
	   (rplaca (cddar r) (- h (cadar r)))
	   (rplaca (cdar r) (- (// (- (car c) (caar r)) 2) w))
	   (setq w (// (+ (car c) (caar r)) 2))
	   (rplaca r (cdar r)))
       (setq d (// h 2) h (- h d))
       (push `(d-matrix left ,h ,d) result)
       (push '(1 0) result)
       (push `(0 ,(- d) . ,(nreverse (car r))) result)
       (push `(,(1+ (- (car c) w)) 0) result)
       (push `(d-matrix right ,h ,d) result)
       (setq width (+ 4 (car c) width)
	     height (max h height)
	     depth (max d depth))
       (update-heights h d)
       (checkbreak result width))
   result)




(defun dim-mtext (form result)
    (if (null (cddr form)) (dimension (cadr form) result lop rop 0 0)
	(dimension-nary form result)))



(defun dim-mlabel (form result)
   (prog (dummy w h d) (declare (fixnum w h d))
      (cond ((eq nil (cadr form)) (setq w 0 h 0 d 0))
	    (mratp (setq result
			 (append mratp
				 (dimension-paren (cadr form) result))
			 w (+ 4 width) h height d depth))
	    (t (setq result
		     (cons '(1 0) (dimension-paren (cadr form) result))
		     w (1+ width) h height d depth)))
      (let ((level $linel)) (checkbreak result w))
      (setq dummy (list 0 0))
      (setq result
	    (dimension (caddr form) (cons dummy result) 'mlable
		       rop w right))
      (cond ((and (not $leftjust) (= 0 bkptout))
	     (rplaca dummy (max 0 (- (// (- $linel width) 2) w)))
	     (setq width (+ (car dummy) width))))
      (setq width (+ w width) height (max h height) depth (max d depth))
      (return result)))


(defun checkrat (form)
   (cond ((atom form) nil)
	 ((and (not (atom (car form))) (eq 'mrat (caar form)))
	  (if (memq 'trunc (cdar form))
	      '(32.  #// #/t #//) '(32.  #// #/r #//)))
	 (t (do l (cdr form) (cdr l) (null l)
		(cond ((atom l)
		       (merror "~s has an atomic cdr - displa" form))
		      ((setq form (checkrat (car l))) (return form)))))))

(defun checkfit (w)
   (declare (fixnum w))
   (cond ((not break)) (t (<= (- (+ w break right 1) bkptwd) $linel))))
      

(defun checkbreak (result w)
   (declare (fixnum w))
   (cond ((not break))
	 ((> (- (setq w (+ w break)) bkptout) $linel)
	  (if (or (null bkpt) (eq result bkpt))
	      (merror "expression too wide to be displayed."))
	  (do ((l result (cdr l))) ((eq bkpt (cdr l)) (rplacd l nil))
	      (if (null l)
		  (merror "checkbreak not found in display")))
	  (output bkpt 0)
	  (setq lines (1+ lines) bkpt result bkptout bkptwd bkptwd w
		bkptht maxht bkptdp maxdp bkptlevel level maxht 1 maxdp 0))
	 ((or (null bkpt) (<= level bkptlevel)
	      (> (// $linel 2) (- bkptwd bkptout)))
	  (setq bkpt result bkptwd w bkptlevel level
		bkptht (max maxht bkptht)
		bkptdp (max maxdp bkptdp)
		maxht 1
		maxdp 0))))

(defun forcebreak (result w)
    (output result 0) (mterpri)
    (setq lines (+ 2 lines) bkpt nil bkptout (+ w break) maxht 1 maxdp 0))

(defun update-heights (ht* dp*)
    (declare (fixnum ht* dp*))
    (if break (setq maxht (max maxht ht*) maxdp (max maxdp dp*))))


(defun dim-del (form result)
   (cond((atom (cadr form))
	 (setq dummy (dimension (cadr form) nil 'mparen 'mparen nil 0)))
	       (t(setq dummy (dimension-paren (cadr form) nil))))
   (push '(end-list) dummy)
   (setq width (1+ width))
   (update-heights height depth)
   (push `(,(max (// (- $linel width 5 ) 2) 0) 0) result)
   (push '(d-del) result)
   (push '(1 0) result)
   (push '(begin-list) result)
   (append dummy result))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: REDIMENSION-WINDOW
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Tue Mar 04 22:40:55 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun redimension-window  ( )
   (cond((equal **current-window** 'plot)
	 (replott))
		(t (re-displa-win **current-window**))
		)
   )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Function: RE-DISPLA
;;;   
;;;      Purpose: 
;;;   
;;;      Written By: Douglas A. Young
;;;      Date: Wed Mar 12 21:10:13 1986
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun re-displa-win  (win)
   (prog (temp)
      (draw-rectangle (get win 'screenrect) :halftone whitehalftone)
      (setq temp (get win 'd-lines))
      (cond((null temp)(return)))
      (putprop win nil 'd-lines)
      (setq $linenum (- $linenum (length temp)))
      (setq old-row (//(caar temp) lg-character-y))
      (mapcar
	 '(lambda (a)
             (setplist (caddr a) nil)
	     (displa (list '(mlable)
			   (caddr a)
			   (eval (caddr a))))
	     (setq $linenum (1+ $linenum))
	     )
	 temp))
   )  
