;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; define various definitions and initializations of variables
;;; for display module. Some of these are closely tied to Macsyma
;;;
(include "//user//vaxima//young//displa//macros")
(declare
   (special
   linel		   ;width of screen.
   ttyheight		   ;height of screen.

   width height depth maxht maxdp level size lop rop break right
   bkpt bkptwd bkptht bkptdp bkptlevel bkptout lines 
   oldrow oldcol display-file in-p
   moremsg moreflush more-^w mratp $aliases aliaslist)

(fixnum width height depth maxht maxdp level size right 
	bkptwd bkptht bkptdp bkptlevel bkptout
	linel tyheight oldrow oldcol)

(notype (tyo* fixnum) (setcursorpos fixnum fixnum))

(*expr +tyo setcursorpos mterpri force-output linear-displa
       ttyintson ttyintsoff more-fun getop
       lbp rbp nformat fullstrip1 makstring $listp))


    ;;;---------------------------------------------------------------
    ;;; initialize global parameters
    ;;;---------------------------------------------------------------
    (setq **current-window** nil)
    (setq old-row nil)
    (setq **oldcol** nil)
    (setq $linenum 1)
    (setq $outchar 'c)
    (setq $inchar '|>|)
    (setq $fit 3)
    (setq $xangle 10)
    (setq $yangle 10)
    (setq $zangle 10)
    (setq $hidden nil)    
    (setq lg-character-x 8)
    (setq lg-character-y 8)
    (setq lg-character-x-2 4)
    (setq lg-character-y-2 4)
    (setq old-row 0 **oldcol** 0)
    (setq super nil subscript nil superlevel -1)
    (setq $derivabbrev nil)
    (setq $noundisp nil)
    (setq $linenum 1 )
    (setq stringdisp nil)
    (setq replace_mode nil)    

(setq $typeset nil)
;;;	"causes equations to be output in a typesetter readable form

(setq displayp nil)
;;;    is t when inside of displa
;;;

;; more messages which appear during the middle of display.  different
;; from those which appear during typein.  moremsg and moreflush get
;; bound to these.

(defvar d-moremsg "--more display?--")
(defvar d-moreflush "--display flushed--")

;;;----------------------------
;;; dummy functions
;;;-----------------------------
(defun more-fun (l) t)
(def listen (lexpr (n) t))
;;;-------------------------------------------------------------
;;; properties for dimension functions
;;; This is the table that links a function name with a dimensioning
;;; function. Macsyma represents a function internally as, for example
;;;   ( (%sqrt simp) ((mplus simp) a b c))
;;; The displa function will look on the property list list of
;;; %sqrt for the 'dimension property to find the name of the
;;; function "dimension-sqrt" to execute.
;;;-------------------------------------------------------------

(putprop 'mtimes 'dimension-nary 'dimension)
;(putprop 'mtimes '((1 0) #/* (1 0)) 'dissym)
(putprop 'mtimes '((0 0) #/*) 'dissym)
(putprop 'mnctimes '((1 0) #/. (1 0)) 'dissym)
(putprop '%sqrt 'dimension-sqrt 'dimension)
(putprop '%del 'dim-del 'dimension)
(putprop '%isqrt 'dimension-sqrt 'dimension)

(displa-def bigfloat  dim-bigfloat)
(displa-def mquote    dimension-prefix "'")
(displa-def msetq     dimension-infix  " : ")
(displa-def mset      dimension-infix  " :: ")
(displa-def mdefine   dim-mdefine      " := ")
(displa-def mdefmacro dim-mdefine      " ::= ")
(putprop 'msetq '((1 0) #/: (1 0)) 'dissym)
(putprop 'mset '((1 0) #/: #/: (1 0)) 'dissym)
(putprop 'mdefine '((1 0) #/: #/= (1 0)) 'dissym)
(putprop 'mdefmacro '((1 0) #/: #/: #/= (1 0)) 'dissym)

(displa-def mnctimes dimension-nary " . ")
(putprop 'mnctimes '((1 0) #/. (1 0)) 'dissym)
(displa-def %product dim-%product 115.)

(displa-def marrow    dimension-infix  "->" 80. 80.)
(displa-def mgreaterp dimension-infix  ">")
(displa-def mgeqp     dimension-infix  ">=")
(displa-def mequal    dimension-infix  "=")
(displa-def mnotequal dimension-infix  "#")
(displa-def mleqp     dimension-infix  "<=")
(displa-def mlessp    dimension-infix  "<")
(displa-def mnot      dimension-prefix "not")
(displa-def mand      dimension-nary   "and")
(displa-def mor	      dimension-nary   "or")
(displa-def mcond     dim-mcond)
(putprop 'marrow '((1 0) #/- #/> (1 0)) 'dissym)
(putprop 'mgeqp '((1 0) #/>= (1 0)) 'dissym)
(putprop 'mgreaterp '((1 0) #/> (1 0)) 'dissym)
(putprop 'mequal '((1 0) #/= (1 0)) 'dissym)
(putprop 'notequal '((1 0) #/! #/= (1 0)) 'dissym)
(putprop 'mleqp '((1 0) #/< #/= (1 0)) 'dissym)
(putprop 'mlessp '((1 0) #/< (1 0)) 'dissym)
(putprop 'mnot '((1 0) #/n #/o #/t (1 0)) 'dissym)
(putprop 'mand '((1 0) #/a #/n #/d (1 0)) 'dissym)
(putprop 'mor '((1 0) #/o #/r (1 0)) 'dissym)

(displa-def mfactorial dimension-postfix "!")
(displa-def mexpt      dimension-superscript)
(displa-def mncexpt    dim-mncexpt "^^")
(displa-def rat dim-rat "//")
(displa-def mquotient dim-mquotient "//")
(displa-def %integrate dim-%integrate 115.)
(displa-def %derivative dim-%derivative 125.)
(displa-def %at dim-%at 105. 105.)
(displa-def mminus dimension-prefix "-")
(displa-def mplus  dim-mplus)
(defprop munaryplus (#/+ (1 0)) dissym)
(defprop mminus (#/- (1 0)) dissym)
(displa-def %sum   dim-%sum 110.)
(displa-def %limit dim-%limit 90. 90.)
(displa-def mdo dim-mdo)(displa-def mdoin dim-mdoin)
(displa-def mprogn dimension-match "(" ")")
(displa-def mlist  dimension-match "[" "]")
(displa-def mangle dimension-match "<" ">")
(displa-def mcomma dimension-nary  ", " 20. 20.)
(displa-def mabs   dim-mabs)
(displa-def $matrix dim-$matrix)
(displa-def mbox dim-mbox)
(displa-def mlabox dim-mlabox)(displa-def mtext dim-mtext 1 1)
(displa-def mlable dim-mlabel 0 0)
(defprop mparen -1. lbp)
(defprop mparen -1. rbp)

(putprop 'mgreek 'dim-greek 'dimension)
;;;   
;;;   This is a table for converting the greek function to the correct
;;;   font index

(setq greek-list '(($alpha (mgreek simp) 212.)
		   ($sigma (mgreek simp) 213.) 
		   ($tau (mgreek simp) 214.)
		   ($mu (mgreek simp) 216.)
                   ($zeta (mgreek simp) 215.)
		   ($phi (mgreek simp) 173.)
		   ($beta (mgreek simp) 187.)
		   ($xi (mgreek simp) 190.)
		   ($lambda (mgreek simp) 201.)
		   ($omega (mgreek simp) 218.)
		   ($delta (mgreek simp) 200.)
		   ($del (mgreek simp) 199.)
		   ($inf (mgreek simp) 207.)
		   ($%inf (mgreek simp) 207.)		   
		   ($infinity (mgreek simp) 207.)
		   ($pi (mgreek simp) 251.)
		   ($%pi (mgreek simp) 251.)))
(setq reverse-greek `((212. ,(exploden 'alpha))
                      (213. ,(exploden 'sigma))
                      (214. ,(exploden 'tau))
                      (216. ,(exploden 'mu))
                      (215. ,(exploden 'zeta))
                      (173. ,(exploden 'phi))
                      (187. ,(exploden 'beta))
                      (190. ,(exploden 'xi))
                      (201. ,(exploden 'lambda))
                      (218. ,(exploden 'omega))
                      (200. ,(exploden 'delta))
                      (199. ,(exploden 'del))
                      (207. ,(exploden 'inf))
		      (251. ,(exploden 'pi))))
