

/***********************************************************************

   This software is for research and educational purposes only.

************************************************************************/



#ifndef zz_p__H
#define zz_p__H

#include "ZZ.h"
#include "FFT.h"



class zz_pInfoT {
private:
   zz_pInfoT();                      // disabled
   zz_pInfoT(const zz_pInfoT&);  // disabled
   void operator=(const zz_pInfoT&); // disabled
public:
   zz_pInfoT(long NewP, long maxroot);
   zz_pInfoT(long Index);
   ~zz_pInfoT();

   long p;
   double pinv;

   long index;        // index >= 0 means we are directly using
                     // an FFT prime

   long PrimeCnt;     // 0 for FFT prime;  otherwise same as NumPrimes
                     // used for establishing crossover points

   long NumPrimes;

   long MaxRoot;

   long MinusMModP;  //  -M mod p, M = product of primes

   // the following arrays are indexed 0..NumPrimes-1
   // q = FFTPrime[i]


   long *CoeffModP;    // coeff mod p

   double *x;          // u/q, where u = (M/q)^{-1} mod q
   long *u;            // u, as above
};

extern zz_pInfoT *zz_pInfo;  // current modulus, initially null

class zz_pBak {
private:
long MustRestore;
zz_pInfoT *ptr;

zz_pBak(const zz_pBak&);  // disabled
void operator=(const zz_pBak&);  // disabled

public:
void save();
void move();
void restore();


zz_pBak() { MustRestore = 0; ptr = 0; }
~zz_pBak() { if (MustRestore) restore(); else delete ptr; }


};




class zz_p {


long rep;

// static data

static long _modulus;
static double ModulusInv;


public:

friend void zz_pInit(long NewP, long maxroot=FFTMaxRoot);
friend void zz_pFFTInit(long index);

friend class zz_pBak;


// ****** constructors and assignment

zz_p() : rep(0) { }

zz_p(const zz_p& a) :  rep(a.rep) { }

zz_p(INIT_VAL_TYPE, long);

~zz_p() { } 

void operator=(const zz_p& a) { rep = a.rep; }

// read-only access to representation
friend long rep(zz_p a) { return a.rep; }

// a loop-hole for direct access to rep
long& LoopHole() { return rep; }

static long modulus() { return _modulus; }
static zz_p zero() { return zz_p(); }
static double ModulusInverse() { return ModulusInv; }
static long PrimeCnt() { return zz_pInfo->PrimeCnt; }

friend void clear(zz_p& x)
// x = 0
   { x.rep = 0; }

friend void set(zz_p& x)
// x = 1
   { x.rep = 1; }

friend void swap(zz_p& x, zz_p& y)
// swap x and y

   { long t;  t = x.rep; x.rep = y.rep; y.rep = t; }

// ****** addition

friend void add(zz_p& x, zz_p a, zz_p b)
// x = a + b

   { x.rep = AddMod(a.rep, b.rep, zz_p::_modulus); }

friend void sub(zz_p& x, zz_p a, zz_p b)
// x = a - b

   { x.rep = SubMod(a.rep, b.rep, zz_p::_modulus); }


friend void negate(zz_p& x, zz_p a)
// x = -a

   { x.rep = SubMod(0, a.rep, zz_p::_modulus); }

friend void add(zz_p& x, zz_p a, long b)
   { zz_p t(INIT_VAL, b); add(x, a, t); }

friend void add(zz_p& x, long a, zz_p b)
   { zz_p t(INIT_VAL, a); add(x, t, b); }


friend void sub(zz_p& x, zz_p a, long b)
   { zz_p t(INIT_VAL, b); sub(x, a, t); }

friend void sub(zz_p& x, long a, zz_p b)
   { zz_p t(INIT_VAL, a); sub(x, t, b); }


// ****** multiplication

friend void mul(zz_p& x, zz_p a, zz_p b)
// x = a*b

   { x.rep = MulMod(a.rep, b.rep, zz_p::_modulus, zz_p::ModulusInv); }

friend void mul(zz_p& x, zz_p a, long b)
// x = a*b
   { zz_p t(INIT_VAL, b); mul(x, a, t); }

friend void mul(zz_p& x, long a, zz_p b)
   { zz_p t(INIT_VAL, a); mul(x, t, b); }


friend void sqr(zz_p& x, zz_p a)
// x = a^2

   { x.rep = MulMod(a.rep, a.rep, zz_p::_modulus, zz_p::ModulusInv); }


// ****** division

friend void div(zz_p& x, zz_p a, zz_p b)
// x = a/b

   { x.rep = MulMod(a.rep, InvMod(b.rep, zz_p::_modulus), zz_p::_modulus,
                    zz_p::ModulusInv); }

friend void div(zz_p& x, zz_p a, long b)
// x = a*b
   { zz_p t(INIT_VAL, b); div(x, a, t); }

friend void div(zz_p& x, long a, zz_p b)
   { zz_p t(INIT_VAL, a); div(x, t, b); }

friend void inv(zz_p& x, zz_p a)
// x = 1/a

   { x.rep = InvMod(a.rep, zz_p::_modulus); }


// ****** exponentiation

friend void power(zz_p& x, zz_p a, long e)
// x = a^e

   { x.rep = PowerMod(a.rep, e, zz_p::_modulus); }

// ****** conversion


friend void operator<<(zz_p& x, long a);
// x = (a mod p)

friend void operator<<(zz_p& x, const ZZ& a);
// x = (a mod p)

friend void operator<<(ZZ& x, zz_p a)
   { x << a.rep; }


// ****** comparison

friend long IsZero(zz_p a)
   { return a.rep == 0; }

friend long IsOne(zz_p a)
   { return a.rep == 1; }

friend long operator==(zz_p a, zz_p b)
   { return a.rep == b.rep; }

friend long operator!=(zz_p a, zz_p b)
   { return a.rep != b.rep; }


// ****** random numbers

friend void random(zz_p& x)
// x = random element in zz_p

   { x.rep = RandomBnd(zz_p::_modulus); }


// ****** input/output

friend ostream& operator<<(ostream& s, zz_p a);
   
friend istream& operator>>(istream& s, zz_p& x);


};

#endif
