
#ifndef mat_zz_p__H
#define mat_zz_p__H

#include "matrix.h"
#include "vec_vec_zz_p.h"

matrix_decl(zz_p)
matrix_io_decl(zz_p)
matrix_eq_decl(zz_p)


void add(matrix(zz_p)& X, const matrix(zz_p)& A, const matrix(zz_p)& B); 
void sub(matrix(zz_p)& X, const matrix(zz_p)& A, const matrix(zz_p)& B); 
void mul(matrix(zz_p)& X, const matrix(zz_p)& A, const matrix(zz_p)& B); 
void mul(vector(zz_p)& x, const matrix(zz_p)& A, const vector(zz_p)& b); 
void mul(vector(zz_p)& x, const vector(zz_p)& a, const matrix(zz_p)& B); 
void mul(matrix(zz_p)& X, const matrix(zz_p)& A, zz_p b);
void ident(matrix(zz_p)& X, long n); 
void determinant(zz_p& d, const matrix(zz_p)& A);
long IsIdent(const matrix(zz_p)& A, long n);
void transpose(matrix(zz_p)& X, const matrix(zz_p)& A);
void solve(zz_p& d, vector(zz_p)& X,
           const matrix(zz_p)& A, const vector(zz_p)& b);
void inv(zz_p& d, matrix(zz_p)& X, const matrix(zz_p)& A);

void diag(matrix(zz_p)& X, long n, zz_p d);
long IsDiag(const matrix(zz_p)& A, long n, zz_p d);


long gauss(matrix(zz_p)& M);
long gauss(matrix(zz_p)& M, long w);
void image(matrix(zz_p)& X, const matrix(zz_p)& A);
void kernel(matrix(zz_p)& X, const matrix(zz_p)& A);



#endif
