C      ________________________________________________________
C     |                                                        |
C     |          SOLVE A FACTORED TRIDIAGONAL SYSTEM           |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         L,D,U --TFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE TSOLVE(X,L,D,U,B)
      REAL B(1),D(1),L(1),U(1),X(1),T
      INTEGER I,J,K,M,N
      T = D(1)
      IF ( ABS(T) .EQ. 1234 ) GOTO 10
      IF ( ABS(T) .EQ. 1238 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH TFACT BEFORE SOLVING'
      STOP
10    N = D(2)
      IF ( N .GT. 1 ) GOTO 30
      IF ( T .LT. 0. ) GOTO 20
      X(1) = B(1)/D(4)
      RETURN
20    X(1) = 1.
      RETURN
30    IF ( T .LT. 0. ) GOTO 90
      J = 1
      X(1) = B(1)
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
      DO 40 K = 2,N
           X(K) = B(K) - X(J)*L(J)
40         J = K
C     ---------------------------
C     |*** BACK SUBSTITUTION ***|
C     ---------------------------
      X(N) = X(N)/D(N+3)
      M = N - 1
50    IF ( ABS(T) .EQ. 1238 ) GOTO 70
      DO 60 J = 1,M
           K = N - J
60         X(K) = (X(K)-X(K+1)*U(K))/D(K+3)
      RETURN
70    DO 80 J = 1,M
           K = N - J
80         X(K) = X(K)/D(K+3) - X(K+1)*U(K)
      RETURN
C     -----------------------------
C     |*** COMPUTE NULL VECTOR ***|
C     -----------------------------
90    J = N + 4
      DO 100 I = 1,N
           IF ( D(J-I) .EQ. 0. ) K = I
100        X(I) = 0.
      K = N - K + 1
      X(K) = 1.
      N = K
      M = K - 1
      IF ( K .GT. 1 ) GOTO 50
      RETURN
      END
