C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE EIGENVECTOR CORRESPONDING TO GIVEN EIGENVALUE  |
C     |         FOR A REAL SYMMETRIC TRIDIAGONAL MATRIX        |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         E     --EIGENVALUE ESTIMATE                    |
C     |                                                        |
C     |         A     --SHESS'S OUTPUT                         |
C     |                                                        |
C     |         W     --WORK ARRAY (LENGTH AT LEAST 4N)        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --IMPROVED ESTIMATE FOR EIGENVALUE       |
C     |                                                        |
C     |         X     --EIGENVECTOR                            |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: TVECT                          |
C     |________________________________________________________|
C
      SUBROUTINE SVECT(E,X,A,D,U,W)
      REAL A(1),D(1),U(1),W(1),X(1),E,T
      INTEGER I,J,K,L,N
      T = A(1)
      IF ( T .EQ. 2234 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST PROCESS WITH COEFFICIENT MATRIX USING'
      WRITE(6,*) 'SUBROUTINE SHESS BEFORE COMPUTING AN EIGENVECTOR'
      WRITE(6,*) 'USING SVECT'
      RETURN
10    N = A(2)
      CALL TVECT(E,X,U,D,U,N,W)
      L = 1
      K = N
      J = 1 + (N*(N-3))/2
20    K = K - 1
      L = L + 1
      IF ( K .LE. 1 ) RETURN
      T = 0.
      DO 30 I = K,N
30         T = T + X(I)*A(I+J)
      DO 40 I = K,N
40         X(I) = X(I) - T*A(I+J)
      J = J - L
      GOTO 20
      END
