C
C      ________________________________________________________
C     |                                                        |
C     |    FACTOR A TRIDIAGONAL MATRIX WITH PARTIAL PIVOTING   |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --ROWS 1, 2, AND 3 HOLD SUPERDIAGONAL,   |
C     |                 DIAGONAL, AND SUBDIAGONAL IN THIS ORDER|
C     |                 (LENGTH AT LEAST 3 + 4N)               |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         A     --FACTORED MATRIX                        |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |    PACKAGE SUBROUTINES: RPACK                          |
C     |________________________________________________________|
C
      SUBROUTINE PFACT(A,LA,N)
      REAL A(1),O,P,Q,R,S,T
      INTEGER G,H,I,J,K,L,LA,N
      K = LA*N - LA + 1
      A(K) = 0.
      K = K + 2
      A(K) = 0.
      IF ( LA .GT. 3 ) CALL RPACK(A,LA,3,N)
      K = 3*N
      I = 3 + K + N
      J = K - I
      R = 0.
      S = 0.
C     ------------------------
C     |*** COMPUTE 1-NORM ***|
C     ------------------------
10    IF ( I .EQ. 3 ) GOTO 20
      P = A(I+J)
      A(I) = P
      I = I - 1
      Q = A(I+J)
      A(I) = Q
      T = ABS(P) + ABS(Q)
      I = I - 1
      Q = A(I+J)
      A(I) = Q
      R = R + ABS(Q)
      IF ( S .LT. R ) S = R
      R = T
      I = I - 2
      J = J + 1
      GOTO 10
20    IF ( S .LT. R ) S = R
      A(1) = 1235
      A(2) = N
      A(3) = S
      O = 2.**(-64)
      T = .5*O
      S = T
30    T = .5*T
      P = S
      S = S + T
      IF ( S .GE. O ) GOTO 40
      IF ( S+T .GT. S ) GOTO 30
40    R = A(6)
      L = K + N
      G = 1
50    G = G + 4
      IF ( G .GT. L ) GOTO 90
      H = G - 1
      I = G + 2
      J = G + 5
C     --------------------
C     |*** FIND PIVOT ***|
C     --------------------
      Q = A(I)
      IF ( ABS(R) .GE. ABS(Q) ) GOTO 70
C     -------------------
C     |*** SWAP ROWS ***|
C     -------------------
      T = A(G)
      A(G) = A(J)
      A(J) = T
      T = R/Q
      K = G + 1
      A(K) = Q
      K = J - 1
      S = A(K)
      IF ( S .EQ. 0. ) GOTO 60
      IF ( S .EQ. O ) S = P
      A(K) = -S*T
      A(H) = S
      GOTO 80
60    A(K) = S
      A(H) = O
      GOTO 80
70    A(H) = 0.
      IF ( R .EQ. 0. ) GOTO 100
      T = Q/R
C     -------------------
C     |*** ELIMINATE ***|
C     -------------------
80    R = A(J) - T*A(G)
      A(J) = R
      A(I) = T
      GOTO 50
90    IF ( R .EQ. 0. ) A(1) = -1235
      RETURN
100   A(1) = -1235
      GOTO 50
      END
