C      ________________________________________________________
C     |                                                        |
C     |COMPUTE THE DETERMINANT OF A FACTORED TRIDIAGONAL MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --PFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         PDET,E--DETERMINANT IS PDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION PDET(E,A)
      REAL A(1),D,F,G
      DOUBLE PRECISION C
      INTEGER E,H,I,L,N
      D = A(1)
      IF ( ABS(D) .EQ. 1235 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH PFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( D .LT. 0. ) GOTO 80
      N = A(2)
      IF ( N .EQ. 1 ) GOTO 90
      D = 1.
      F = 2.**64
      G = 1./F
      H = 64
      L = 1 + 4*N
      DO 50 I = 6,L,4
           IF ( A(I-2) .NE. 0. ) D = -D
           D = D*A(I)
20         IF ( ABS(D) .GT. F ) GOTO 40
30         IF ( ABS(D) .GT. G ) GOTO 50
           E = E - H
           D = D*F
           GOTO 30
40         E = E + H
           D = D*G
           GOTO 20
50    CONTINUE
      D = D*A(L+1)
      IF ( E .NE. 0 ) GOTO 60
      PDET = D
      RETURN
60    IF ( D .EQ. 0. ) GOTO 100
      C = ALOG10(ABS(D)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 70
      C = C - 1
      E = E + 1
70    F = 10.**C
      IF ( D .LT. 0. ) F = -F
      PDET = F
      RETURN
80    PDET = 0.
      RETURN
90    PDET = A(6)
      RETURN
100   E = 0
      GOTO 80
      END
