C
C      ________________________________________________________
C     |                                                        |
C     |               INVERT A CIRCULANT MATRIX                |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COMPLEX ARRAY CONTAINING FIRST ROW OF  |
C     |                 MATRIX                                 |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         W     --COMPLEX WORK ARRAY WITH AT LEAST N     |
C     |                 ELEMENTS                               |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         A     --COMPLEX ARRAY CONTAINING FIRST ROW OF  |
C     |                 INVERSE MATRIX                         |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,AIMAG,CONJG,REAL             |
C     |    PACKAGE SUBROUTINES: FFT                            |
C     |________________________________________________________|
C
      SUBROUTINE OVERT(A,N,W)
      COMPLEX A(1),W(1)
      REAL T
      CALL FFT(A,N,W)
      DO 10 I = 1,N
           T = ABS(REAL(A(I))) + ABS(AIMAG(A(I)))
           IF ( T .EQ. 0. ) GOTO 30
10         A(I) = 1./CONJG(A(I))
      CALL FFT(A,N,W)
      DO 20 I = 1,N
20         A(I) = CONJG(A(I))
      RETURN
30    WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
      END
