C
C      ________________________________________________________
C     |                                                        |
C     |     FACTOR A GENERAL MATRIX WITH PARTIAL PIVOTING      |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --ARRAY CONTAINING MATRIX                |
C     |                 (LENGTH AT LEAST 3 + N(N+1))           |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         A     --FACTORED MATRIX                        |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |    PACKAGE SUBROUTINES: PACK                           |
C     |________________________________________________________|
C
      SUBROUTINE FACT(A,LA,N)
      REAL A(1),R,S,T
      INTEGER E,F,G,H,I,J,K,L,LA,M,N,O,P
      IF ( LA .GT. N ) CALL PACK(A,LA,N)
      R = 0.
      O = N + 1
      P = O + 1
      L = 5 + N*P
      I = -N - 3
C     ---------------------------------------------
C     |*** INSERT PIVOT ROW AND COMPUTE 1-NORM ***|
C     ---------------------------------------------
10    L = L - O
      IF ( L .EQ. 4 ) GOTO 30
      S = 0.
      DO 20 K = 1,N
           J = L - K
           T = A(I+J)
           A(J) = T
20         S = S + ABS(T)
      IF ( R .LT. S ) R = S
      I = I + 1
      GOTO 10
30    A(1) = 1230
      A(2) = N
      A(3) = R
      I = 5 - P
      K = 1
40    I = I + P
      IF ( K .EQ. N ) GOTO 110
      E = N - K
      M = I + 1
      H = I
      L = I + E
C     ---------------------------------------
C     |*** FIND PIVOT AND START ROW SWAP ***|
C     ---------------------------------------
      DO 50 J = M,L
50         IF ( ABS(A(J)) .GT. ABS(A(H)) ) H = J
      G = H - I
      J = I - K
      A(J) = G + K
      T = A(H)
      A(H) = A(I)
      A(I) = T
      K = K + 1
      IF ( T .EQ. 0. ) GOTO 100
C     -----------------------------
C     |*** COMPUTE MULTIPLIERS ***|
C     -----------------------------
      DO 60 J = M,L
60         A(J) = A(J)/T
      F = I + E*O
70    J = K + L
      H = J + G
      T = A(H)
      A(H) = A(J)
      A(J) = T
      L = E + J
      IF ( T .EQ. 0. ) GOTO 90
      H = I - J
C     ------------------------------
C     |*** ELIMINATE BY COLUMNS ***|
C     ------------------------------
      M = J + 1
      DO 80 J = M,L
80         A(J) = A(J) - T*A(J+H)
90    IF ( L .LT. F ) GOTO 70
      GOTO 40
100   A(1) = -1230
      GOTO 40
110   IF ( A(I) .EQ. 0. ) A(1) = -1230
      RETURN
      END
