C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE ALL EIGENVALUES OF A COMPLEX HESSENBERG MATRIX |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COEFFICIENTS OF HESSENBERG MATRIX      |
C     |                 PACKED AT START OF COMPLEX ARRAY       |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |         W     --REAL WORK ARRAY WITH AT LEAST          |
C     |                 4N ELEMENTS                            |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: VLS                            |
C     |________________________________________________________|
C
      SUBROUTINE CEVALS(E,A,N,W)
      COMPLEX A(1),E(1)
      REAL W(1)
      INTEGER L,M,N
      M = N + 1
      L = M + N
      CALL VLS(E,A,N,W,W(M),W(L))
      RETURN
      END
