#############################################################################
##
#A  Matrix Group and G-module library                   Derek Holt
#A                                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
#A                                                      Sarah Rees 
##
#A  @(#)$Id$
##
#Y  Copyright 1994 -- School of Mathematical Sciences, ANU   
##
#H  $Log$
##
#c_tensorprod.g
#
###############################################################################
##
#F  TensorProductGMod( m1,m2 ) . . . . . tensor product of two G-modules
##
## TensorProductGMod calculates the tensor product of modules m1 and m2. 
## They are assumed to be modules for the same group so, in particular, they
## should have the same number of generators.
TensorProductGMod := function( m1,m2)
    local mat1, mat2, F1, F2,  gens, i, l;

   mat1 := MatricesFlag(m1); mat2 := MatricesFlag(m2);
   F1 := FieldFlag(m1); F2 := FieldFlag(m2);
   if (F1 <> F2) then
     Error("Modules are defined over different fields.\n");
   fi;
   l := Length(mat1);
   if (l <> Length(mat2)) then
     Error("Modules have different numbers of generators.");
   fi;

   gens := [];
   for i in [1..l] do
     gens[i] := KroneckerProduct(mat1[i],mat2[i]);
   od;

   return GModule(gens,F1);
end;

###############################################################################
##
#F  WedgeGMod( module ) . . . . . wedge product of a G-module
##
## WedgeGMod calculates the wedge product of a G-module.
## That is the action on antisymmetrix tensors.
WedgeGMod := function( module)
    local mats, mat, newmat, row, F, gens, dim, nmats, i, j, k, m, n, x;

   mats := MatricesFlag(module);
   F := FieldFlag(module);
   nmats := Length(mats);
   dim := Length(mats[1]);

   gens := [];
   for i in [1..nmats] do
      mat := mats[i];
      newmat := [];
      for j in [1..dim] do
        for k in [1..j-1] do
          row := [];
          for m in [1..dim] do
            for n in [1..m-1] do
              x := mat[j][m]*mat[k][n] - mat[j][n]*mat[k][m];
              Add(row,x);
            od;
          od;
          Add(newmat,row);
        od;
      od;
      Add(gens,newmat);
   od;

   return GModule(gens,F);
end;
