      SUBROUTINE ZERO(F,B,C,ABSERR,RELERR,IFLAG,NF)
C
      EXTERNAL F
      DOUBLE PRECISION F,B,C,ABSERR,RELERR
      INTEGER IFLAG
C
C  ZERO COMPUTES A ROOT OF THE NONLINEAR EQUATION F(X) = 0
C  WHERE F(X) IS A CONTINUOUS REAL FUNCTION OF A SINGLE REAL
C  VARIABLE X.  THE METHOD USED IS A COMBINATION OF BISECTION
C  AND THE SECANT RULE.
C
C  INPUT PARAMETERS
C     F = FUNCTION PROGRAM DEFINING F(X).  F SHOULD HAVE THE
C         FORM:
C            DOUBLE PRECISION FUNCTION F(X)
C            DOUBLE PRECISION X
C            F = ...
C            RETURN
C            END
C         THE FUNCTION NAME F MUST APPEAR IN AN EXTERNAL STATE-
C         MENT IN THE CALLING PROGRAM.
C     B,C = VALUES 0F X SUCH THAT F(B)*F(C) .LE. 0
C     ABSERR,RELERR = ABSOLUTE AND RELATIVE ERROR TOLERANCES.
C        THE STOPPING CRITERION IS: ABS(B-C) .LE. 2.0*MAX(ABSERR,
C        ABS(B)*RELERR)
C  OUTPUT PARAMETERS
C     B,C = SEE IFLAG RETURNS
C     IFLAG = 0 FOR NORMAL RETURN; F(B)*F(C) .LT. 0 AND THE
C               STOPPING CRITERION IS MET.  B IS ALWAYS SELECTED
C               SO THAT ABS(F(B)) .LE. ABS(F(C)).
C           = 1 IF F(B)=0; B,C MAY NOT SATISFY THE STOPPING 
C               CRITERION.
C           = 2 IF B IS TOO CLOSE TO C: B+ABS(B-C) =  B.
C           = 3 IF ABS(F(B)) EXCEEDS MAX(ABS(F(B)),ABS(F(C)))
C               ON INPUT; IN THIS CASE IT IS LIKELY THAT B IS CLOSE
C               TO A POLE OF F.
C           = 4 IF NO ODD ORDER ZERO WAS FOUND IN THE INTERVAL;
C               A LOCAL MINIMUM MAY HAVE BEEN OBTAINED.
C           = 5 IF TOO MANY FUNCTION EVALUATIONS WERE MADE;
C               IN THIS VERSION 500 ARE ALLOWED.
C           = -1 INVALID INPUT PARAMETERS: ABSERR AND RELERR
C               BOTH ZERO; ABSERR OR RELERR LESS THAN 0.
C     NF = NUMBER OF FUNCTION EVALUATIONS
C
C  LOCAL VARIABLES
      DOUBLE PRECISION ACBS,A,FA,FB,FC,FX,CMB,ACMB,TOL,P,Q,
     &  DSIGN,DABS,TEMP
      INTEGER IC,NF
C
      IF(RELERR .EQ. 0.0 .AND. ABSERR .EQ. 0.0) GOTO 14
      IF(RELERR .LT. 0.0 .OR. ABSERR .LT. 0.0) GOTO 14
      IC = 0
      ACBS = DABS(B-C)
      A = C
      FA = F(A)
      FB = F(B)
      FC = FA
      NF = 2
      FX = DMAX1(DABS(FB),DABS(FC))
    1 IF(DABS(FC) .GE. DABS(FB)) GOTO 2
C
C  INTERCHANGE B AND C SO THAT DABS(F(B)) .LE. DABS(F(C)).
C
      A = B
      FA = FB
      B = C
      FB = FC
      C = A
      FC = FA
    2 CMB = 0.5D0*(C-B)
      ACMB = DABS(CMB)
      TOL = DMAX1(ABSERR,DABS(B)*RELERR)
C
C  TEST STOPPING CRITERION AND FUNCTION COUNT.
C
      TEMP = B+DABS(B-C)
   20 IF(TEMP .EQ. B) GOTO 10
      IF(ACMB .LE. TOL) GOTO 8
      IF(NF .GE. 500) GOTO 13
C
C  CALCULATE NEW ITERATE IMPLICITLY AS B+P/Q
C  WHERE WE ARRANGE P .GE. 0.  THE IMPLICIT
C  FORM IS USED TO PREVENT OVERFLOW.
C
      P = (B-A)*FB
      Q = FA-FB
      IF(P .GE. 0.0) GOTO 3
      P = -P
      Q = -Q
C
C  UPDATE A, CHECK IF REDUCTION IN THE SIZE OF BRACKETING
C  INTERVAL IS SATISFACTORY.  IF NOT, BISECT UNTIL IT IS.
C
    3 A = B
      FA = FB
      IC = IC+1
      IF(IC .LT. 4) GOTO 4
      IF(8.0*ACMB .GE. ACBS) GOTO 6
      IC = 0
      ACBS = ACMB
C
C  TEST FOR TOO SMALL A CHANGE.
C
    4 IF(P .GT. DABS(Q)*TOL) GOTO 5
C
C  INCREMENT BY TOLERANCE.
C
      B = B+DSIGN(TOL,CMB)
      GOTO 7
C
C  ROOT OUGHT TO BE BETWEEN B AND (C+B)/2.
C
    5 IF(P .GE. CMB*Q) GOTO 6
C
C  USE SECANT RULE.
C
      B = B+P/Q
      GOTO 7
C
C  USE BISECTION.
C
    6 B = 0.5D0*(C+B)
C
C  HAVE COMPLETED COMPUTATION FOR NEW ITERATE B.
C
    7 FB = F(B)
      IF(FB .EQ. 0.0) GOTO 9
      NF = NF+1
      IF(DSIGN(1.0D0,FB) .NE. DSIGN(1.0D0,FC)) GOTO 1
      C = A
      FC = FA
      GOTO 1
C
C  FINISHED.  SET IFLAG.
C
    8 IF(DSIGN(1.0D0,FB) .EQ. DSIGN(1.0D0,FC)) GOTO 12
      IF(DABS(FB) .GT. FX) GOTO 11
      IFLAG = 0
      RETURN
    9 IFLAG = 1
      RETURN
   10 IFLAG = 2
      RETURN
   11 IFLAG = 3
      RETURN
   12 IFLAG = 4
      RETURN
   13 IFLAG = 5
      RETURN
   14 IFLAG = -1
      RETURN
      END
