      SUBROUTINE HQR(NM,N,LOW,IGH,H,WR,WI,IERR) 
C 
      INTEGER I,J,K,L,M,N,EN,LL,MM,NA,NM,IGH,ITN,ITS,LOW,MP2,ENM2,IERR 
      DOUBLE PRECISION H(NM,N),WR(N),WI(N) 
      DOUBLE PRECISION P,Q,R,S,T,W,X,Y,ZZ,NORM,TST1,TST2 
      LOGICAL NOTLAS 
C 
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE HQR, 
C     NUM. MATH. 14, 219-231(1970) BY MARTIN, PETERS, AND WILKINSON. 
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 359-371(1971). 
C 
C     THIS SUBROUTINE FINDS THE EIGENVALUES OF A REAL 
C     UPPER HESSENBERG MATRIX BY THE QR METHOD. 
C 
C     ON INPUT 
C 
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL 
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM 
C          DIMENSION STATEMENT. 
C 
C        N IS THE ORDER OF THE MATRIX. 
C 
C        LOW AND IGH ARE INTEGERS DETERMINED BY THE BALANCING 
C          SUBROUTINE  BALANC.  IF  BALANC  HAS NOT BEEN USED, 
C          SET LOW=1, IGH=N. 
C 
C        H CONTAINS THE UPPER HESSENBERG MATRIX.  INFORMATION ABOUT 
C          THE TRANSFORMATIONS USED IN THE REDUCTION TO HESSENBERG 
C          FORM BY  ELMHES  OR  ORTHES, IF PERFORMED, IS STORED 
C          IN THE REMAINING TRIANGLE UNDER THE HESSENBERG MATRIX. 
C 
C     ON OUTPUT 
C 
C        H HAS BEEN DESTROYED.  THEREFORE, IT MUST BE SAVED 
C          BEFORE CALLING  HQR  IF SUBSEQUENT CALCULATION AND 
C          BACK TRANSFORMATION OF EIGENVECTORS IS TO BE PERFORMED. 
C 
C        WR AND WI CONTAIN THE REAL AND IMAGINARY PARTS, 
C          RESPECTIVELY, OF THE EIGENVALUES.  THE EIGENVALUES 
C          ARE UNORDERED EXCEPT THAT COMPLEX CONJUGATE PAIRS 
C          OF VALUES APPEAR CONSECUTIVELY WITH THE EIGENVALUE 
C          HAVING THE POSITIVE IMAGINARY PART FIRST.  IF AN 
C          ERROR EXIT IS MADE, THE EIGENVALUES SHOULD BE CORRECT 
C          FOR INDICES IERR+1,...,N. 
C 
C        IERR IS SET TO 
C          ZERO       FOR NORMAL RETURN, 
C          J          IF THE LIMIT OF 30*N ITERATIONS IS EXHAUSTED 
C                     WHILE THE J-TH EIGENVALUE IS BEING SOUGHT. 
C 
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW, 
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY 
C 
C     THIS VERSION DATED APRIL 1983. 
C 
C     ------------------------------------------------------------------ 
C 
      IERR = 0 
      NORM = 0.0D0 
      K = 1 
C     .......... STORE ROOTS ISOLATED BY BALANC 
C                AND COMPUTE MATRIX NORM .......... 
      DO 50 I = 1, N 
C 
         DO 40 J = K, N 
   40    NORM = NORM + DABS(H(I,J)) 
C 
         K = I 
         IF (I .GE. LOW .AND. I .LE. IGH) GO TO 50 
         WR(I) = H(I,I) 
         WI(I) = 0.0D0 
   50 CONTINUE 
C 
      EN = IGH 
      T = 0.0D0 
      ITN = 30*N 
C     .......... SEARCH FOR NEXT EIGENVALUES .......... 
   60 IF (EN .LT. LOW) GO TO 1001 
      ITS = 0 
      NA = EN - 1 
      ENM2 = NA - 1 
C     .......... LOOK FOR SINGLE SMALL SUB-DIAGONAL ELEMENT 
C                FOR L=EN STEP -1 UNTIL LOW DO -- .......... 
   70 DO 80 LL = LOW, EN 
         L = EN + LOW - LL 
         IF (L .EQ. LOW) GO TO 100 
         S = DABS(H(L-1,L-1)) + DABS(H(L,L)) 
         IF (S .EQ. 0.0D0) S = NORM 
         TST1 = S 
         TST2 = TST1 + DABS(H(L,L-1)) 
         IF (TST2 .EQ. TST1) GO TO 100 
   80 CONTINUE 
C     .......... FORM SHIFT .......... 
  100 X = H(EN,EN) 
      IF (L .EQ. EN) GO TO 270 
      Y = H(NA,NA) 
      W = H(EN,NA) * H(NA,EN) 
      IF (L .EQ. NA) GO TO 280 
      IF (ITN .EQ. 0) GO TO 1000 
      IF (ITS .NE. 10 .AND. ITS .NE. 20) GO TO 130 
C     .......... FORM EXCEPTIONAL SHIFT .......... 
      T = T + X 
C 
      DO 120 I = LOW, EN 
  120 H(I,I) = H(I,I) - X 
C 
      S = DABS(H(EN,NA)) + DABS(H(NA,ENM2)) 
      X = 0.75D0 * S 
      Y = X 
      W = -0.4375D0 * S * S 
  130 ITS = ITS + 1 
      ITN = ITN - 1 
C     .......... LOOK FOR TWO CONSECUTIVE SMALL 
C                SUB-DIAGONAL ELEMENTS. 
C                FOR M=EN-2 STEP -1 UNTIL L DO -- .......... 
      DO 140 MM = L, ENM2 
         M = ENM2 + L - MM 
         ZZ = H(M,M) 
         R = X - ZZ 
         S = Y - ZZ 
         P = (R * S - W) / H(M+1,M) + H(M,M+1) 
         Q = H(M+1,M+1) - ZZ - R - S 
         R = H(M+2,M+1) 
         S = DABS(P) + DABS(Q) + DABS(R) 
         P = P / S 
         Q = Q / S 
         R = R / S 
         IF (M .EQ. L) GO TO 150 
         TST1 = DABS(P)*(DABS(H(M-1,M-1)) + DABS(ZZ) + DABS(H(M+1,M+1))) 
         TST2 = TST1 + DABS(H(M,M-1))*(DABS(Q) + DABS(R)) 
         IF (TST2 .EQ. TST1) GO TO 150 
  140 CONTINUE 
C 
  150 MP2 = M + 2 
C 
      DO 160 I = MP2, EN 
         H(I,I-2) = 0.0D0 
         IF (I .EQ. MP2) GO TO 160 
         H(I,I-3) = 0.0D0 
  160 CONTINUE 
C     .......... DOUBLE QR STEP INVOLVING ROWS L TO EN AND 
C                COLUMNS M TO EN .......... 
      DO 260 K = M, NA 
         NOTLAS = K .NE. NA 
         IF (K .EQ. M) GO TO 170 
         P = H(K,K-1) 
         Q = H(K+1,K-1) 
         R = 0.0D0 
         IF (NOTLAS) R = H(K+2,K-1) 
         X = DABS(P) + DABS(Q) + DABS(R) 
         IF (X .EQ. 0.0D0) GO TO 260 
         P = P / X 
         Q = Q / X 
         R = R / X 
  170    S = DSIGN(DSQRT(P*P+Q*Q+R*R),P) 
         IF (K .EQ. M) GO TO 180 
         H(K,K-1) = -S * X 
         GO TO 190 
  180    IF (L .NE. M) H(K,K-1) = -H(K,K-1) 
  190    P = P + S 
         X = P / S 
         Y = Q / S 
         ZZ = R / S 
         Q = Q / P 
         R = R / P 
         IF (NOTLAS) GO TO 225 
C     .......... ROW MODIFICATION .......... 
         DO 200 J = K, N 
            P = H(K,J) + Q * H(K+1,J) 
            H(K,J) = H(K,J) - P * X 
            H(K+1,J) = H(K+1,J) - P * Y 
  200    CONTINUE 
C 
         J = MIN0(EN,K+3) 
C     .......... COLUMN MODIFICATION .......... 
         DO 210 I = 1, J 
            P = X * H(I,K) + Y * H(I,K+1) 
            H(I,K) = H(I,K) - P 
            H(I,K+1) = H(I,K+1) - P * Q 
  210    CONTINUE 
         GO TO 255 
  225    CONTINUE 
C     .......... ROW MODIFICATION .......... 
         DO 230 J = K, N 
            P = H(K,J) + Q * H(K+1,J) + R * H(K+2,J) 
            H(K,J) = H(K,J) - P * X 
            H(K+1,J) = H(K+1,J) - P * Y 
            H(K+2,J) = H(K+2,J) - P * ZZ 
  230    CONTINUE 
C 
         J = MIN0(EN,K+3) 
C     .......... COLUMN MODIFICATION .......... 
         DO 240 I = 1, J 
            P = X * H(I,K) + Y * H(I,K+1) + ZZ * H(I,K+2) 
            H(I,K) = H(I,K) - P 
            H(I,K+1) = H(I,K+1) - P * Q 
            H(I,K+2) = H(I,K+2) - P * R 
  240    CONTINUE 
  255    CONTINUE 
C 
  260 CONTINUE 
C 
      GO TO 70 
C     .......... ONE ROOT FOUND .......... 
  270 WR(EN) = X + T 
      WI(EN) = 0.0D0 
      EN = NA 
      GO TO 60 
C     .......... TWO ROOTS FOUND .......... 
  280 P = (Y - X) / 2.0D0 
      Q = P * P + W 
      ZZ = DSQRT(DABS(Q)) 
      X = X + T 
      IF (Q .LT. 0.0D0) GO TO 320 
C     .......... REAL PAIR .......... 
      ZZ = P + DSIGN(ZZ,P) 
      WR(NA) = X + ZZ 
      WR(EN) = WR(NA) 
      IF (ZZ .NE. 0.0D0) WR(EN) = X - W / ZZ 
      WI(NA) = 0.0D0 
      WI(EN) = 0.0D0 
      GO TO 330 
C     .......... COMPLEX PAIR .......... 
  320 WR(NA) = X + P 
      WR(EN) = X + P 
      WI(NA) = ZZ 
      WI(EN) = -ZZ 
  330 EN = ENM2 
      GO TO 60 
C     .......... SET ERROR -- ALL EIGENVALUES HAVE NOT 
C                CONVERGED AFTER 30*N ITERATIONS .......... 
 1000 IERR = EN 
 1001 RETURN 
      END 
