      DOUBLE PRECISION FUNCTION FMIN(AX,BX,F,TOL)
      DOUBLE PRECISION AX,BX,F,TOL
      external f
C
C      AN APPROXIMATION  X  TO THE POINT WHERE  F  ATTAINS A MINIMUM  ON
C  THE INTERVAL  (AX,BX)  IS DETERMINED.
C
C
C  INPUT..
C
C  AX    LEFT ENDPOINT OF INITIAL INTERVAL
C  BX    RIGHT ENDPOINT OF INITIAL INTERVAL
C  F     FUNCTION SUBPROGRAM WHICH EVALUATES  F(X)  FOR ANY  X
C        IN THE INTERVAL  (AX,BX)
C  TOL   DESIRED LENGTH OF THE INTERVAL OF UNCERTAINTY OF THE FINAL
C        RESULT ( .GE. 0.0D0)
C
C
C  OUTPUT..
C
C  FMIN  ABCISSA APPROXIMATING THE POINT WHERE  F  ATTAINS A MINIMUM
C
C
C      THE METHOD USED IS A COMBINATION OF  GOLDEN  SECTION  SEARCH  AND
C  SUCCESSIVE PARABOLIC INTERPOLATION.  CONVERGENCE IS NEVER MUCH SLOWER
C  THAN  THAT  FOR  A  FIBONACCI SEARCH.  IF  F  HAS A CONTINUOUS SECOND
C  DERIVATIVE WHICH IS POSITIVE AT THE MINIMUM (WHICH IS NOT  AT  AX  OR
C  BX),  THEN  CONVERGENCE  IS  SUPERLINEAR, AND USUALLY OF THE ORDER OF
C  ABOUT  1.324....
C      THE FUNCTION  F  IS NEVER EVALUATED AT TWO POINTS CLOSER TOGETHER
C  THAN  EPS*ABS(FMIN) + (TOL/3), WHERE EPS IS  APPROXIMATELY THE SQUARE
C  ROOT  OF  THE  RELATIVE  MACHINE  PRECISION.   IF   F   IS A UNIMODAL
C  FUNCTION AND THE COMPUTED VALUES OF   F   ARE  ALWAYS  UNIMODAL  WHEN
C  SEPARATED BY AT LEAST  EPS*ABS(X) + (TOL/3), THEN  FMIN  APPROXIMATES
C  THE ABCISSA OF THE GLOBAL MINIMUM OF  F  ON THE INTERVAL  AX,BX  WITH
C  AN ERROR LESS THAN  3*EPS*ABS(FMIN) + TOL.  IF   F   IS NOT UNIMODAL,
C  THEN FMIN MAY APPROXIMATE A LOCAL, BUT PERHAPS NON-GLOBAL, MINIMUM TO
C  THE SAME ACCURACY.
C      THIS FUNCTION SUBPROGRAM IS A SLIGHTLY MODIFIED  VERSION  OF  THE
C  ALGOL  60 PROCEDURE  LOCALMIN  GIVEN IN RICHARD BRENT, ALGORITHMS FOR
C  MINIMIZATION WITHOUT DERIVATIVES, PRENTICE - HALL, INC. (1973).
C
C
      DOUBLE PRECISION  A,B,C,D,E,EPS,XM,P,Q,R,TOL1,TOL2,U,V,W
      DOUBLE PRECISION  FU,FV,FW,FX,X
      DOUBLE PRECISION  DABS,DSQRT,DSIGN
C
C  C IS THE SQUARED INVERSE OF THE GOLDEN RATIO
C
      C = 0.5D0*(3. - DSQRT(5.0D0))
C
C  EPS IS APPROXIMATELY THE SQUARE ROOT OF THE RELATIVE MACHINE
C  PRECISION.
C
      EPS = 1.0D00
   10 EPS = EPS/2.0D00
      TOL1 = 1.0D0 + EPS
      IF (TOL1 .GT. 1.0D00) GO TO 10
      EPS = DSQRT(EPS)
C
C  INITIALIZATION
C
      A = AX
      B = BX
      V = A + C*(B - A)
      W = V
      X = V
      E = 0.0D0
      FX = F(X)
      FV = FX
      FW = FX
C
C  MAIN LOOP STARTS HERE
C
   20 XM = 0.5D0*(A + B)
      TOL1 = EPS*DABS(X) + TOL/3.0D0
      TOL2 = 2.0D0*TOL1
C
C  CHECK STOPPING CRITERION
C
      IF (DABS(X - XM) .LE. (TOL2 - 0.5D0*(B - A))) GO TO 90
C
C IS GOLDEN-SECTION NECESSARY
C
      IF (DABS(E) .LE. TOL1) GO TO 40
C
C  FIT PARABOLA
C
      R = (X - W)*(FX - FV)
      Q = (X - V)*(FX - FW)
      P = (X - V)*Q - (X - W)*R
      Q = 2.0D00*(Q - R)
      IF (Q .GT. 0.0D0) P = -P
      Q =  DABS(Q)
      R = E
      E = D
C
C  IS PARABOLA ACCEPTABLE
C
   30 IF (DABS(P) .GE. DABS(0.5D0*Q*R)) GO TO 40
      IF (P .LE. Q*(A - X)) GO TO 40
      IF (P .GE. Q*(B - X)) GO TO 40
C
C  A PARABOLIC INTERPOLATION STEP
C
      D = P/Q
      U = X + D
C
C  F MUST NOT BE EVALUATED TOO CLOSE TO AX OR BX
C
      IF ((U - A) .LT. TOL2) D = DSIGN(TOL1, XM - X)
      IF ((B - U) .LT. TOL2) D = DSIGN(TOL1, XM - X)
      GO TO 50
C
C  A GOLDEN-SECTION STEP
C
   40 IF (X .GE. XM) E = A - X
      IF (X .LT. XM) E = B - X
      D = C*E
C
C  F MUST NOT BE EVALUATED TOO CLOSE TO X
C
   50 IF (DABS(D) .GE. TOL1) U = X + D
      IF (DABS(D) .LT. TOL1) U = X + DSIGN(TOL1, D)
      FU = F(U)
C
C  UPDATE  A, B, V, W, AND X
C
      IF (FU .GT. FX) GO TO 60
      IF (U .GE. X) A = X
      IF (U .LT. X) B = X
      V = W
      FV = FW
      W = X
      FW = FX
      X = U
      FX = FU
      GO TO 20
   60 IF (U .LT. X) A = U
      IF (U .GE. X) B = U
      IF (FU .LE. FW) GO TO 70
      IF (W .EQ. X) GO TO 70
      IF (FU .LE. FV) GO TO 80
      IF (V .EQ. X) GO TO 80
      IF (V .EQ. W) GO TO 80
      GO TO 20
   70 V = W
      FV = FW
      W = U
      FW = FU
      GO TO 20
   80 V = U
      FV = FU
      GO TO 20
C
C  END OF MAIN LOOP
C
   90 FMIN = X
      RETURN
      END
