      SUBROUTINE DGEEVX(LDA,N,D,X,WORK,JOB)
      INTEGER LDA,N,JOB
      DOUBLE PRECISION D(*),X(LDA,*),WORK(*)
C
C     This rearranges the real storage used by EISPACK to produce 
C     results that act like Fortran complex storage.  It also
C     normalizes the eigenvectors.
C
C     Let  dj = aj + i*bj be the eigenvalues.  Then on input the real
C     array D contains
C           a1, a2, ..., an, b1, b2, ..., bn
C     On output, D should contain
C           a1, b1, a2, b2, ..., an, bn
C     Subsequent operations may then access D as a complex array.
C     
C     Let  xj = yj + i*zj be the eigenvectors.  On input, if  dj  is
C     real, then  xj = yj  is real and is stored in  X(:,j).  If  dj
C     is complex with positive imaginary part, then  yj  is stored 
C     in  X(:,j)  and  zj  is stored in  X(:,j+1).  This must be
C     rearranged so that each individual element of X corresponding
C     to a real component is immediately following by the imaginary
C     component.
C
C     LOBO.LIB. This version dated 08/04/84 .
C     Cleve Moler, University of New Mexico.
C
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      DOUBLE PRECISION PYTHAG,P,Q,S,T
      INTEGER I,J,M
C
      DO 10 J = 1, N
         WORK(J) = D(J)
   10 CONTINUE
      DO 20 J = 1, N
         D(2*J-1) = WORK(J)
         D(2*J) = D(N+J)
   20 CONTINUE
      IF (JOB .EQ. 0) RETURN
C
      J = N
   30 CONTINUE
         IF (D(2*J) .NE. 0) GO TO 50
C
C        Real eigenvalue and vector
C
         M = 1
         DO 40 I = 1, N
            IF (DABS(X(I,J)) .GT. DABS(X(M,J))) M = I
   40    CONTINUE
         T = X(M,J)
         DO 45 I = N, 1, -1
            X(2*I,2*J-1) = 0.0D0
            X(2*I-1,2*J-1) = X(I,J)/T
   45    CONTINUE
         J = J - 1
         GO TO 70
C
C        Complex conjugate pair
C
   50    T = 0.0D0
         DO 60 I = 1, N
            S = PYTHAG(X(I,J-1),X(I,J))
            IF (S .LT. T) GO TO 60
               M = I
               T = S
   60    CONTINUE
         S = X(M,J-1)
         T = X(M,J)
         DO 65 I = N, 1, -1
            CALL CDIV(X(I,J-1),X(I,J),S,T,P,Q)
            X(2*I,2*J-1) = -Q
            X(2*I-1,2*J-1) = P
            X(2*I,2*J-3) = Q
            X(2*I-1,2*J-3) = P
   65    CONTINUE
         J = J - 2
         GO TO 70
C
   70 IF (J .GT. 0) GO TO 30
C
      RETURN
      END
