      SUBROUTINE DGEEV (A,LDA,N,D,X,WORK,JOB,INFO)
      INTEGER LDA,N,JOB,INFO
      DOUBLE PRECISION A(LDA,*),WORK(*)
C     COMPLEX*16 D(*),X(LDA,*)
C
C     DGEEV, Double precision GEneral Eigenvales and Vectors.
C     DGEEV computes the eigenvalues and, optionally, the eigenvectors
C     of a real matrix.  If the matrix is symmetric, DSYEV should be
c     used instead.
C
C     IMPORTANT NOTE: The input is real, but the output is complex.
C
C     ON ENTRY
C
C        A       DOUBLE PRECISION (LDA,N)
C                The matrix.
C
C        LDA     INTEGER
C                The leading dimension of the arrays A and X.
C
C        N       INTEGER
C                The order of the matrices A and X.
C
C        JOB     INTEGER
C                = 0  Eigenvalues only.
C                = 1  Eigenvalues and eigenvectors.
C
C        WORK    DOUBLE PRECISION (N)
C                WORK is a scratch array.
C
C     ON RETURN
C
C        A       Completely altered.
C
C        D       COMPLEX DOUBLE PRECISION (N)
C                The eigenvalues.  Complex conjugate pairs of
C                eigenvalues appear consecutively with the eigenvalues
C                having the positive imaginary part first.
C
C        X       COMPLEX DOUBLE PRECISION (LDA,N)
C                X(:,J) is an eigenvector associated with D(J).
C                Each vector is normalized so that its largest component
C                is 1.0.  If the input matrix A does not have a full 
C                set of linearly independent eigenvectors, then X 
C                will be singular or badly conditioned.
C
C        INFO    INTEGER
C                = 0, usual case, results are satisfactory.
C                = nonzero, very unusual, the iteration did not converge.
C
C     LOBO.LIB. This version dated 08/04/84 .
C     Cleve Moler, University of New Mexico.
C
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C     Here is some tricky business.  EISPACK does all real
C     arithmetic, so the actual declarations of D and X are:
      DOUBLE PRECISION D(*),X(LDA,*)
C     We regard D and each column of X as having 2*N real components.
C     They will be rearranged at the end to be complex.
C
      INTEGER LOW,HIGH
C
C     Initial scaling and reduction
C
      CALL BALANC(LDA,N,A,LOW,HIGH,WORK)
      CALL ORTHES(LDA,N,LOW,HIGH,A,D)
      IF (JOB .NE. 0) GO TO 10
C
C     Find eigenvalues only
C
      CALL HQR(LDA,N,LOW,HIGH,A,D(1),D(N+1),INFO)
      GO TO 20
C
C     Find both eigenvalues and eigenvectors
C
   10 CALL ORTRAN(LDA,N,LOW,HIGH,A,D,X)
      CALL HQR2(LDA,N,LOW,HIGH,A,D(1),D(N+1),X,INFO)
      IF (INFO .NE. 0) GO TO 20
C
C     Undo the scaling
C
      CALL BALBAK(LDA,N,LOW,HIGH,WORK,N,X)
C
C     Convert to complex form and normalize the vectors
C
   20 CALL DGEEVX(LDA,N,D,X,WORK,JOB)
      RETURN
      END
