.TH GRAND L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST  *
.tr ~
.hy 0
.SH NAME
GRAND
.SH DECLARATIONS
.nf
real function GRAND(iy)
integer iy
.fi
.SH SYNOPSIS
.PP
FORTRAN function that returns a
random number from the normal (Gaussian) distribution.
Note, the value returned is a single precision number.
.PP
This random number generator is based on a method developed by
Box and Muller, as described in
in Knuth[2].  This routine was originally written by Cleve Moler
for use in MATLAB and was modified for use in LOBO.LIB.
.PP
For random numbers generated from a uniform distribution,
see URAND.
.SH PARAMETERS
.TP 8
iy
The seed to initialize the sequence of random numbers
generated, then is used by the routine to store information
used by subsequent calls.
.br
Prior to the first call to GRAND, \fIiy\fR
should be initialized to an arbitrary, non-negative
integer.  A common choice is to set \fIiy\fR~=~0.
The calling program should not alter the value of \fIiy\fR
between subsequent calls to GRAND.
.sp
Warning, if URAND is used in the same program, different
named seeds should be used for URAND and GRAND.
.SH Details
.PP
GRAND falls in the classification of \fIpseudorandom\fR number
generators.  That is, the
sequence of random numbers is reproducible.
.PP
With two uniform random numbers, \fIV1\fR and \fIV2\fR,
on [-1,1) such
that \fIS\fR~=~\fIV1\fR\*(ST\*(ST2~+~\fIV2\fR\*(ST\*(ST2, let
\fIX\fR~=~\fIV1\*(STsqrt(\fR\|-2.0\|\fI\*(STln(S)\fR/\fIS)\fR.
As proved in Knuth, \fIX\fR is chosen from the normal
distribution with mean zero and variance 1.
Note that the number, \fIV2\*(STsqrt(\fR\|-2.0\|\fI\*(STln(S)\fR/\fIS)\fR,
is also from the normal distribution, but GRAND only returns
one value.
.br
.SH EXAMPLE
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
c		Program to demonstrate expansion of a sequence of
c		random numbers from a normal distribution with
c		mean 0 and variance 1, to a normal distribution
c		with mean 100 and variance 10.
c
c		For example, suppose we need a sample of 100 values
c		representing IQ scores, and we want the sample to
c		fit a normal distribution.  We make the assumption
c		that the standard deviation of IQ scores is 10.
		integer iseed, it, i
		integer iscores(100)
		iseed = 0
		i = 1
	10	continue
			int(10.0*grand(iseed) + 100.0)
			if (it .ge. 0.0) then
				iscores(i) = it
				i = i+1
			endif
		if (i .le. 100) go to 10
		.
		.
c		rest of program that uses the scores
		.
		.
		end
.fi
.SH SEE ALSO
URAND
.SH REFERENCES
.IP [1]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.IP [2]
Knuth, D. E., \fISeminumerical Algorithms\fR,
\fBThe Art of Computer Programming, Vol  2.\fR
Addison-Wesley, 1969.
.SH FURTHER INFORMATION
.nf
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM 87131
