.TH DGECO L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
DGECO, DGEFA, DGESL, DGEDI
.SH DECLARATIONS
.nf
subroutine DGECO(A, lda, n, ipvt, rcond, work)
integer lda, n, ipvt(n)
double precision A(lda,n), work(n), rcond

subroutine DGEFA(A, lda, n, ipvt, info)
integer lda, n, ipvt(n), info
double precision A(lda,n)

subroutine DGESL(A, lda, n, ipvt, b, job)
integer lda, n, ipvt(n), job
double precision A(lda,n), b(n)

subroutine DGEDI(A, lda, n, ipvt, det, work, job)
integer lda, n, ipvt(n), job
double precision A(lda,n), det(2), work(n)
.fi
.SH SYNOPSIS
FORTRAN subroutines from LINPACK
for performing linear algebra operations on
general square matrices.
.PP
DGECO calls DGEFA to obtain the \fILU\fR factorization of a matrix, then
estimates the reciprocal of the condition number, \fIrcond\fR,
of the matrix.
.PP
DGESL uses the \fILU\fR factorization obtained from DGECO
to solve a system of linear equations.
.PP
DGEDI uses the \fILU\fR factorization obtained from DGECO
to estimate the determinant of the matrix and to provide the
inverse of the matrix.
.PP
The output parameters \fIA\fR and \fIipvt\fR from DGECO
must not be changed before subsequent calls to DGESL or DGEDI.
.PP
For positive definite matrices, non-square matrices,
orthogonal decompositions  or singular value decompositions
see DPOCO, DQRDC, DSVDC.
.PP
For more details see the LINPACK Users' Manual.
.SH PARAMETERS
.TP 10
A(lda,n)
Used by all routines.
.br
As input to DGECO or DGEFA, \fIA\fR contains the matrix to be factored.
Upon return from DGECO or DGEFA, \fIA\fR has been overwritten by
the \fILU\fR factorization of the input matrix, with \fIU\fR in its
upper triangle and in its strict lower triangle the multipliers
necessary to construct a matrix \fIL\fR so that \fIA\fR~=~\fILU\fR.
The input to DGESL and DGEDI must be this \fILU\fR factorization.
DGESL does not change \fIA\fR,
but DGEDI overwrites \fIA\fR with
the inverse of the original matrix.
.TP 10
lda
Input to all routines.
.br
The leading dimension of the array \fIA\fR.
.TP 10
n
Input to all routines.
.br
The order of the matrix.
.TP 10
ipvt(n)
Used by all routines.
.br
Contains the
pivot information from DGECO or DGEFA.
Specifically, \fIipvt(k)\fR is the index of the \fIk\fR-th pivot row.
.TP 10
rcond
Output from DGECO.
.br
An estimate of the reciprocal of the condition number of \fIA\fR.
If \fIrcond\fR is so
small that \fI(1.0~+~rcond~=~1.0)\fR,
then \fIA\fR can usually be regarded as singular to working precision.
In this event, neither DGESL nor DGEDI should be called.
See discussion of condition number under Details.
.TP 10
work(n)
Work space provided for DGECO and DGEDI.
.br
On return from DGECO, if \fIA\fR is close to a singular matrix,
then \fIwork\fR will contain an approximate
null vector of \fIA\fR.
.TP 10
info
Output from DGEFA.
.br
If \fIinfo\fR~=~0, it indicates that DGESL
and DGEDI can be safely used.
.br
If \fIinfo\fR~=~\fIk\fR~>~0, then \fIU(k,k)\fR~=~0.0.
If \fIU\fR has several zero diagonal elements,
\fIk\fR will be the index of the last one.  Although a nonzero
\fIinfo\fR certainly
indicates singularity, because of roundoff error in any computer,
\fIrcond\fR is a more reliable indicator of singularity.
See \fIrcond\fR under parameters.
.TP 10
b(n)
Input, output from DGESL.
.br
Input is the right hand side \fIb\fR of a system of
simultaneous linear equations \fIAx~=~b\fR, or \fItrans(A)x~=~b\fR.
DGESL overwrites \fIb\fR with the solution, \fIx\fR.
.TP 10
job
Input to DGESL, DGEDI.
.br
Indicator of what is to be computed by DGESL, DGEDI.
.RS
.ns
.IP DGESL
.br
.ns
.IP " 0 - " 7
the system \fIAx~=~b\fR is to be solved
.br
.ns
.IP " 1 - "
the system \fItranspose(A)x~=~b\fR is to be solved
.IP DGEDI
.br
.ns
.IP " 1 - "
return the inverse only
.br
.ns
.IP "10 - "
return the determinant only
.br
.ns
.IP "11 - "
return both the determinant and the inverse
.RE
.TP 10
det(2)
Output from DGEDI.
.br
If the determinant is requested, (see \fIjob\fR), DGEDI returns
the determinant of the matrix \fIA\fR in the form
\fIdet(A)~=~det(1)~\*(ST~10.0\*(ST\*(STdet(2)\fR with
\fI(1.0~<=~|det(1)^|~<~10.0)\fR or \fI(det(1)~=~0.0)\fR.
.SH DETAILS
.TP 5
DGEFA
For any square matrix, \fIA\fR, there is a factorization such
that \fIA~=~LU\fR, where \fIU\fR is an upper triangular matrix and
\fIL\fR is a matrix which is the product of elementary lower
triangular and permutation matrices.  In this routine, the
\fILU\fR factorization is obtained through Gaussian elimination
with partial pivoting.
.TP 5
DGECO
DGECO obtains the \fILU\fR factorization of a matrix from
DGEFA then uses those factors to estimate the reciprocal
of the condition number.
.TP 5
Condition Number
Given a linear system, \fIAx~=~b\fR, the condition number of \fIA\fR
measures the sensitivity of the solution \fIx\fR to errors in the matrix
\fIA\fR and the right hand side \fIb\fR.
For the purpose of evaluating the effect of machine precision
on calculations performed by these subroutines, a matrix
can be considered to at least have errors relative to
machine precision.
.sp
In order to avoid overflow problems,
DGECO computes the reciprocal of the condition number
such that
\fIrcond(A)~=~1/(^||A^||\*(ST(estimate of ||inverse(A)^||))\fR.
The estimate of \fI||inv(A)^||\fR is calculated without explicitly
forming the inverse.
If \fIrcond(A)\fR
is approximately \fI10\*(ST\*(ST-d\fR then the elements of \fIx\fR
can usually be expected to
have \fId\fR fewer significant digits of accuracy than
the elements of \fIA\fR.
If \fIrcond\fR
is small enough that \fIrcond\fR~+~1.0~=~1.0, then the matrix \fIA\fR
is probably singular to working precision, i.e. the solution \fIx\fR
or the inverse of \fIA\fR cannot be calculated accurately, and
may cause overflow problems in the routines DGESL and DGEDI.
For further discussion of the condition number of a matrix, see
the Introduction to the LINPACK Users' Guide.
.TP 5
DGESL
DGESL provides the solution \fIx\fR to the linear system
\fIAx~=~b\fR,
by first solving \fILy~=~b\fR, then \fIUx~=~y\fR,
or the system \fItrans(A)x~=~b\fR by solving \fItrans(U)y~=~b\fR
then \fItrans(1)x~=~y\fR.
.TP 5
DGEDI
DGEDI returns the determinant of \fIA\fR such that
\fIdet(A)~=~det(1)\*(STdet(U)\fR, and/or
the inverse of \fIA\fR such that
\fIinv(A)~=~inv(U)\*(STinv(1)\fR.
.LP
Ordinarily, DGECO is called once to factor a particular matrix
and then DGESL can be called to apply the factorization
as many times as needed.
If you are certain the matrix is well conditioned, DGEFA can
be called directly instead of using DGECO.
.SH EXAMPLES
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
c		Program to factor a matrix, then solves the system
c		Ax = b, if A is not near singular.
		double precision a(50,50),b(50),work(50),rcond
		integer n,lda,ipvt(50)
		data lda /50/
		n = ...
		do 20 j = 1,n
			do 10 i = 1,n
				a(i,j) = ...
	10		continue
	20	continue
		call dgeco(a,lda,n,ipvt,rcond,work)
		if (rcond +1.d0 .eq. 1.d0) then
			write(6,*) 'matrix is singular to working precision'
			write(6,*) 'rcond = ',d9.5
		else
			do 30 i = 1,n
				b(i) = ...
	30		continue
		call dgesl(a,lda,n,ipvt,b,0)
		do 40 i = 1,n
			write(6,*) b(i)
	40	continue
		endif
		end


c		Program segment to show how to overwrite an n by k matrix
c		C with inv(A)\*(STC without explicitly forming inv(A).
c
		call dgefa(a,lda,n,ipvt,info)
		do 10 j = 1,k
			call dgesl(a,lda,n,ipvt,c(1,j),0)
	10	continue


c		Program segment to show how to overwrite an k by n matrix
c		C with C\*(STinv(A) without explicitly forming inv(A).
c		Since this involves rows rather that columns of C, we
c		must send each row, j, of C to DGESL as a separate vector.
c
		call dgefa(a,lda,n,ipvt,info)
		if (info .ne. 0) then
		do 30 i = 1,k
			do 10 j = 1,n
				z(j) = c(i,j)
	10		continue
		call dgesl(a,lda,n,ipvt,z,1)
			do 20 j = 1,n
				c(i,j) = z(j)
	20 		continue
	30	continue
		endif

c		Program segment to print the determinant of a matrix
c		in simulated E format that allows a 4-digit exponent
c		and avoids underflow/overflow problems.
		call dgeco(a,lda,n,ipvt,rcond,work)
		call dgedi(a,lda,n,ipvt,det,work,10)
		k = int(det(2))
		write(6,10) det(1),k
	10	format('determinant = ',f20.15,' ',i5)
.fi
.SH SECONDARY ROUTINES
.nf
BLAS: DAXPY, DDOT, DSCAL, DASUM, IDAMAX, DSWAP
.SH SEE ALSO
DPOCO, DQRDC, DSVDC, BLAS
.SH REFERENCES
.fi
Dongarra, J. J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR,
Society for Industrial and Applied Mathematics, Philadelphia, 1979.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
