;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1990, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; This section deals with functions which are non-algebraic or
;;; unspecified.  These functions are canonicalized with regard to
;;; symmetric, antisymmetric, even, odd, distributive and anti-distributive
;;; properties on a per argument basis.  This does not canonicalize
;;; functions because there are many other functional properties.  What is
;;; possible in this area?  What other properties are important to include?

;;; f(x,y,z) = f(y,x,z)		f is symmetric in arguments 1 and 2.
;;; f(x,y,z) = -f(y,x,z)	f is anti-symmetric in arguments 1 and 2.
;;; f(x,y) = f(-x,y)		f is even in argument 1.
;;; f(x,y) = -f(-x,y)		f is odd in argument 1.
;;; f(g(x,y),z) = g(f(x,z),y)	f and g distribute over argument 1.
;;; f(g(x,y),z) = -g(f(x,z),y)	f and g anti-distribute over argument 1.
;;; f(f(x,z),z) = f(x,z)	f idempotent over argument 1.

;;; When one of the functions in a distributive pair is '+' (and '-') the
;;; system knows that constant factors can be pulled out.  When one of the
;;; functions in a distributive pair is '*' the system knows that it applies
;;; to '/' and exponentiated terms also. 

;;; Normalization procedure:

;;; First, apply distributive rules to pairs (to sets?) of distributive
;;; functions in such a was as to push the lower priority function to the
;;; bottom (smallest terms).  '+' followed by '*' and exponentiation are the
;;; highest priority functions. 

;;; Colapse any idempotent cases.

;;; Starting with the innermost terms conditionally negate arguments in
;;; order to make the highest order term of the argument positive (negating
;;; the function if odd). 

;;; Finally, sort sets of symmetric arguments by highest order term ranking.
