;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(set (proof-log-port) '#f)

(load-section knaster-fixed-point-theorem)

;; (include-files
;;   (files (theories reals/reals-supplements))
;;   )

;; (include-files
;;  (files 
;;   (home imps/theories/alf-roots)))
;; 


(def-script command-on-direct-descendents 1
  ((label-node compound)
   direct-and-antecedent-inference-strategy
   (jump-to-node compound)
   (for-nodes
    (unsupported-descendents)
    $1)))

(def-script raise-all-conditionals 0

  ((while (progresses? (raise-conditional (0))) (skip)))

  (applicability-recognizer
   (lambda (sqn)
     (rc-i-applicable? (sequent-node-assertion sqn)))))

(def-script justify-forced-substitution 0
  ((move-to-sibling 1)
   (command-on-direct-descendents simplify)))
  
(def-script force-substitution-then-justify 2
  ((force-substitution $1 $2 (0))
   justify-forced-substitution))

(def-script cut-and-justify 2
  ;; First arg is the cut formula, second arg is the command for justification 
  ((cut-with-single-formula $1)
   (move-to-sibling 1)
   $2))


(set (proof-log-port)(standard-output))


(def-theorem strict-monotone-product-lemma
  "forall(x,y,z,u:rr, 0<x and x<y and 0<=u and u<z implies x*u<y*z)"
  (proof
   (
    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "x*u<x*z and x*z<y*z")
    simplify
    (apply-macete-with-minor-premises strict-monotonicity-for-multiplication)
    (apply-macete-with-minor-premises commutative-law-for-multiplication)
    (apply-macete-with-minor-premises strict-monotonicity-for-multiplication)
    simplify))
  (theory h-o-real-arithmetic))


(def-theorem power-fn-is-strictly-monotone
  "forall(n:zz, x,y:rr, 1<=n and 0<=x and x<y implies x^n < y^n)"
  (theory h-o-real-arithmetic)
  lemma
  (proof
   (    
    (induction integer-inductor ("n"))
    (apply-macete-with-minor-premises exp-out)
    (case-split ("x=0"))
    simplify
    (apply-macete-with-minor-premises positivity-for-r^n)
    (apply-macete-with-minor-premises strict-monotone-product-lemma)
    simplify
    (force-substitution "0<=x^t" "0<x^t" (0))
    (apply-macete-with-minor-premises positivity-for-r^n)
    direct-and-antecedent-inference-strategy
    simplify)))

(def-theorem exponentiation-discloses-order
  "forall(x,y:rr,n:nn, 0<=y and 1<=n and x^n<y^n implies x<y)"
  (theory h-o-real-arithmetic)
  (proof
   (
    direct-and-antecedent-inference-strategy
    (contrapose "with(r:rr,r<r);")
    (force-substitution "not(x^n<y^n)" "(y^n<=x^n)" (0))
    (apply-macete-with-minor-premises power-fn-is-monotone)
    simplify
    simplify)))


(def-theorem exponentiation-discloses-weak-order
  "forall(x,y:rr,n:nn, 0<=y and 1<=n and x^n<=y^n implies x<=y)"
  (theory h-o-real-arithmetic)
  (proof
   (
    direct-and-antecedent-inference-strategy
    (contrapose "with(y:rr,n:nn,x:rr,x^n<=y^n);")
    (force-substitution "not(x^n<=y^n)" "(y^n<x^n)" (0))
    (apply-macete-with-minor-premises power-fn-is-strictly-monotone)
    simplify
    simplify)))

(def-constant inth%root
  "lambda(n:nn, x:rr, floor(nth%root(n,x)))"
  (theory h-o-real-arithmetic))

(def-theorem inth%root-definedness
  "forall(x:rr,n:nn, 0<=x and 0<n implies #(inth%root(n,x),nn))"
  (theory h-o-real-arithmetic)
  (usages d-r-convergence)
  (proof
   (
    (unfold-single-defined-constant-globally inth%root)
    (apply-macete-with-minor-premises nn-defining-axiom_h-o-real-arithmetic)
    simplify
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    (apply-macete-with-minor-premises nth%root-non-negative)
    simplify)))

(def-theorem inth%root-definedness-2
  "forall(x:rr,n:nn, 0<=x and 0<n implies #(inth%root(n,x)))"
  (theory h-o-real-arithmetic)
  (usages d-r-convergence)
  (proof
   (
    unfold-defined-constants
    simplify)))


(def-theorem inth%root-non-negative-for-nonnegative-arg
  "forall(x:rr,n:nn, 0<=x and 0<n implies 0<=inth%root(n,x))"
  (theory h-o-real-arithmetic)
  (proof
   (
    unfold-defined-constants
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    (apply-macete-with-minor-premises nth%root-non-negative)
    simplify)))

(def-theorem inth%root-to-the-nth-is-lower-bound
  "forall(x:rr,n:nn, 0<=x and 0<n implies inth%root(n,x)^n<=x)"
  (theory h-o-real-arithmetic)
  (proof
   (
    (unfold-single-defined-constant-globally inth%root)
    (force-substitution "x" "nth%root(n,x)^n" (2))
    (apply-macete-with-minor-premises power-fn-is-monotone)
    simplify
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    (apply-macete-with-minor-premises nth%root-non-negative)
    simplify
    (apply-macete-with-minor-premises nth%root-power))))

(def-theorem inth%root-plus-one-to-the-nth-is-upper-bound
  "forall(x:rr,n:nn,  0<=x and 0<n implies x<(1+inth%root(n,x))^n)"
  (theory h-o-real-arithmetic)
  (proof
   (
    (unfold-single-defined-constant-globally inth%root)
    direct-and-antecedent-inference-strategy
    (force-substitution "x" "nth%root(n,x)^n" (0))
    (apply-macete-with-minor-premises power-fn-is-strictly-monotone)
    (apply-macete-with-minor-premises floor-plus-1-exceeds-arg)
    (apply-macete-with-minor-premises nth%root-non-negative)
    simplify
    (apply-macete-with-minor-premises nth%root-power))))

(def-theorem floor-inequality-characterization
  "forall(x,y:rr, (floor(x)<=floor(y) iff floor(x)<=y))"
  (theory h-o-real-arithmetic)
  (proof
   (
    direct-and-antecedent-inference-strategy
    simplify
    (case-split ("floor(x)+1<=floor(y)"))
    simplify
    (contrapose "with(p:prop,not(p));")
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    simplify)))

;; Same proof verbatim!!

(def-theorem floor-strict-inequality-characterization
  "forall(x,y:rr, (floor(x)<=floor(y) iff x<floor(y)+1))"
  reverse
  (theory h-o-real-arithmetic)
  (proof
   (
    direct-and-antecedent-inference-strategy
    simplify
    (case-split ("floor(x)+1<=floor(y)"))
    simplify
    (contrapose "with(p:prop,not(p));")
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    simplify)))

(def-theorem monotonicity-of-floor
  "forall(x,y:rr, x<=y implies floor(x)<=floor(y))"
  (theory h-o-real-arithmetic)
  (proof
   (
    (apply-macete-with-minor-premises floor-inequality-characterization)
    direct-and-antecedent-inference-strategy
    (cut-with-single-formula "floor(x)<=x")
    simplify
    simplify)))

(def-theorem floors-equal-unless-separated-by-nonnegative
  "forall(x,y:rr,
  0<=x
   implies 
  floor(x)=floor(y)
   iff 
  forall(m:zz,0<=m implies m<=x iff m<=y));"
  (theory h-o-real-arithmetic)
  (proof
   (
    direct-and-antecedent-inference-strategy
    (let-script
     do-case 1
     ((incorporate-antecedent "with(z:zz,z=z);")
      (apply-macete-with-minor-premises floor-characterization)
      (apply-macete-with-minor-premises rev%floor-strict-inequality-characterization)
      (apply-macete-with-minor-premises floor-inequality-characterization)
      (cut-with-single-formula (% "m<=floor( ~a )" $1))
      simplify
      (apply-macete-with-minor-premises floor-not-much-below-arg)))
    ($do-case "x")
    ($do-case "y")
    (let-script
     discharge-cut 0
     ((label-node top)
      direct-and-antecedent-inference-strategy
      (jump-to-node top)
      (for-nodes (unsupported-descendents)
		 (block (apply-macete-with-minor-premises floor-not-much-below-arg)
			simplify))))
    (cut-and-justify "0<=y and 0<=floor(y) and 0<=floor(x)" $discharge-cut)
    (case-split ("x<=y"))
    (let-script
     do-case-2 2
     ((instantiate-universal-antecedent "with(p:prop,forall(m:nn,p));"
					((% "floor( ~a )" $1)))
      (contrapose (% "with(x,y:rr,floor( ~a )<= ~a );" $1 $2))
      simplify
      (contrapose (% "with(y:rr,not(floor( ~a )<= ~a ));" $1 $1))
      simplify))
    ($do-case-2 "y" "x")
    ($do-case-2 "x" "y"))))


(def-theorem floor-nth%root-floor
  "forall(n:zz, x:rr, 0<=x and 1<=n implies 
                    floor(nth%root(n,x))=floor(nth%root(n,floor(x))))"
  reverse
  (theory h-o-real-arithmetic)
  (proof
   (
    (apply-macete-with-minor-premises floors-equal-unless-separated-by-nonnegative)
    (script-comment "First observe that the root is non-negative.")
    (move-to-sibling 1)
    (apply-macete-with-minor-premises nth%root-non-negative)
    (script-comment "Now show that the root and root of the floor are not separated 
by an integer.")
    direct-and-antecedent-inference-strategy
    (move-to-ancestor 2)
    (move-to-descendent (1 0))
    (apply-macete-with-minor-premises transitivity-of-<=)
    auto-instantiate-existential
    (apply-macete-with-minor-premises monotonicity-of-nth%root)
    simplify
    (script-comment "Move on to hard case.")
    (apply-macete-with-minor-premises exponentiation-discloses-weak-order)
    (instantiate-existential ("n"))
    (apply-macete-with-minor-premises nth%root-non-negative)
    (apply-macete-with-minor-premises nth%root-power)
    (contrapose "with(x:rr,n,m:zz,m<=nth%root(n,x));")
    (force-substitution "not(m<=nth%root(n,x))" "(nth%root(n,x)<m)" (0))
    (apply-macete-with-minor-premises exponentiation-discloses-order)
    (instantiate-existential ("n"))
    (apply-macete-with-minor-premises nth%root-power)
    (contrapose "with(p:prop,not(p));")
    (apply-macete-with-minor-premises floor-not-much-below-arg)
    simplify
    simplify)))


(comment
 here is an alternative proof that replaces the asserted equality with the pair
 of inequalities.   It requires only one "exponentiation-discloses-order"
 theorem.
 
 (force-substitution-then-justify
  "floor(nth%root(n,x))=floor(nth%root(n,floor(x)))"
  "floor(nth%root(n,x))<=floor(nth%root(n,floor(x))) 
  and floor(nth%root(n,floor(x)))<=floor(nth%root(n,x))")
 direct-and-antecedent-inference-strategy
 (script-comment "First prove the easy inequality.")
 (move-to-ancestor 2)
 (move-to-descendent (1 0))
 (apply-macete-with-minor-premises monotonicity-of-floor)
 (apply-macete-with-minor-premises monotonicity-of-nth%root)
 simplify
 (script-comment "Now the harder inequality.")
 (apply-macete-with-minor-premises floor-inequality-characterization)
 (apply-macete-with-minor-premises exponentiation-discloses-weak-order)
 (instantiate-existential ("n"))
 (apply-macete-with-minor-premises nth%root-non-negative)
 (apply-macete-with-minor-premises nth%root-power)
 (apply-macete-with-minor-premises floor-not-much-below-arg)
 (apply-macete-with-minor-premises transitivity-of-<=)
 (instantiate-existential ("(nth%root(n,x))^n"))
 (apply-macete-with-minor-premises power-fn-is-monotone)
 (apply-macete-with-minor-premises floor-not-much-below-arg)
 (apply-macete-with-minor-premises nth%root-non-negative)
 simplify
 (apply-macete-with-minor-premises nth%root-power)
 simplify)





(def-theorem iterated-inth%root
  "forall( x:rr, n,m:nn, 1<=n and 1<=m and 0<=x implies 
	inth%root(n*m,x) = inth%root(n,(inth%root(m,x))))"
  (theory h-o-real-arithmetic)
  (proof
   (
    (unfold-single-defined-constant-globally inth%root)
    (apply-macete-with-minor-premises rev%floor-nth%root-floor)
    (apply-macete-with-minor-premises iterated-nth%root)
    simplify
    (apply-macete-with-minor-premises nth%root%existence)
    (apply-macete-with-minor-premises nth%root-non-negative)
    simplify
    (apply-macete-with-minor-premises nth%root-non-negative))))


;; Just for the record, here is the generalized version of Alf's lemma, with a
;; proof, although we did not use it in our proof of the iterated-inth%root.  




(def-theorem alfs-lemma-generalized
  "forall(x, y, z, n : nn, 0<=y and 1<=n and (x^n <= y and y < z^n)
    implies (x <= inth%root(n,y) and inth%root(n,y) < z))"
  (theory h-o-real-arithmetic)
  (proof
   (
    (force-substitution "x<=inth%root(n,y)" "x<inth%root(n,y)+1" (0))
    (script-comment "first justify the substitution.")
    (move-to-sibling 1)
    simplify
    (script-comment "now use the substitution.")
    direct-and-antecedent-inference-strategy
    (block (script-comment "first prove that x<=inth%root.")
	   (apply-macete-with-minor-premises exponentiation-discloses-order)
	   (instantiate-existential ("n"))
	   (force-substitution "0<=inth%root(n,y)+1" "0<=inth%root(n,y)" (0))
	   (apply-macete-with-minor-premises inth%root-non-negative-for-nonnegative-arg)
	   simplify
	   (instantiate-theorem inth%root-plus-one-to-the-nth-is-upper-bound ("y" "n"))
	   simplify)
    (block (script-comment "next prove that inth%root<z")
	   (apply-macete-with-minor-premises exponentiation-discloses-order)
	   (instantiate-existential ("n"))
	   simplify
	   (instantiate-theorem inth%root-to-the-nth-is-lower-bound ("y" "n"))
	   (simplify-antecedent "with(p:prop,not(p));")
	   simplify))))

