;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald streams)

(define-syntax (cons-stream head tail)
  `(cons ,head
	 (delay ,tail)))

(define (head stream)
  (comment "return head of possibly infinite stream.")
  (car stream))

(define (tail stream)
  (force
   (cdr stream)))

(define-constant the-empty-stream 'the-empty-stream)

(define (empty-stream? stream)
  (eq? the-empty-stream stream))

(define (nth-stream s n)
  (if (<= n 0)
      (head s)
      (nth-stream (tail s) (-1+ n))))

(define (filter pred stream)
  (cond ((empty-stream? stream) the-empty-stream)
	((pred (head stream))
	 (cons-stream (head stream)
		      (filter pred (tail stream))))
	(else
	 (filter pred (tail stream)))))

(define (map-stream proc stream)
  (if (empty-stream? stream)
      the-empty-stream
      (cons-stream (proc (head stream))
		   (map-stream proc (tail stream)))))

(define (mapcdr-stream proc stream)
  (if (empty-stream? stream)
      the-empty-stream
      (cons-stream (proc stream)
		   (mapcdr-stream proc (tail stream)))))

(define (for-each proc stream)
  (if (empty-stream? stream)
      'done
      (block
	(proc (head stream))
	(for-each proc (tail stream)))))

(define (prepend-list lst stream)
  (if (null? lst)
      stream
      (cons-stream
       (car lst)
       (prepend-list
	(cdr lst)
	 stream))))

(define (cross-streams stream1 stream2)
  (iterate iter ((l1 nil)
		 (l2 nil)
		 (stream1 stream1)
		 (stream2 stream2))
    (if
     (or (empty-stream? stream1)
	 (empty-stream? stream2))
     the-empty-stream
     (let ((s1-elem (head stream1))
	   (s2-elem (head stream2)))
       (cons-stream
	(cons s1-elem s2-elem)
	(prepend-list
	 (cross-elem-with-list s1-elem l2)
	 (prepend-list
	  (cross-list-with-elem l1 s2-elem)
	  (iter
	   (cons s1-elem l1)
	   (cons s2-elem l2)
	   (tail stream1)
	   (tail stream2)))))))))
  
(define (cross-elem-with-list elem lst)
  (map
   (lambda (x)
     (cons elem x))
   lst))

(define (cross-list-with-elem lst elem)
  (map
   (lambda (x)
     (cons x elem))
   lst))
