;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(herald def-forms)

(define (collect-modifier-and-keyword-arguments-for-def-form args)
  (iterate loop ((modifiers '())
		 (keyword-args '())
		 (args args))
    (if (null? args)
	(return modifiers keyword-args)
	(if (symbol? (car args))
	    (loop (cons (car args) modifiers)
		  keyword-args
		  (cdr args))
	    (if (and (proper-list? (car args))
		     (symbol? (caar args)))
		(loop modifiers
		      (cons (car args) keyword-args)
		      (cdr args))
		(imps-error "COLLECT-MODIFIER-AND-KEYWORD-ARGUMENTS-FOR-DEF-FORM: Bad argument ~A:" (car args)))))))

(define (modifier-and-keyword-check-for-def-form
	 modifiers
	 keyword-args
	 admissible-modifiers
	 admissible-keywords
	 required-keywords)
  (walk (lambda (modifier)
	  (or (memq? modifier admissible-modifiers)
	      (imps-error "MODIFIER-AND-KEYWORD-CHECK-FOR-DEF-FORM: Bad modifier ~A." modifier)))
	 modifiers)
  (walk (lambda (keyword-arg)
	  (or (memq? (car keyword-arg) admissible-keywords)
	      (imps-error "MODIFIER-AND-KEYWORD-CHECK-FOR-DEF-FORM: Bad keyword ~A." (car keyword-arg))))
	keyword-args)
  (walk (lambda (keyword)
	  (or (memq? keyword (map car keyword-args))
	      (imps-error "MODIFIER-AND-KEYWORD-CHECK-FOR-DEF-FORM: The required keyword ~A is missing." keyword)))
	required-keywords))

(define (wrap-with-def-form-bind the-name the-kind sexp)
  `(bind (((def-form-end-line)
	   (and (line-numbered-port? (current-imps-port))
		(port-line-number (current-imps-port))))
	  ((def-form-name) ',the-name)
	  ((def-form-kind) ',the-kind))
     (block0
      ,sexp
      (register-current-imps-obarray-entry))))
				      
(define-syntax (DEF-COMPOUND-MACETE the-name form)
  (wrap-with-def-form-bind
   the-name 'COMPOUND-MACETE
   `(build-and-install-macete-from-sexp ',form ',the-name)))

(define-syntax (DEF-SCHEMATIC-MACETE the-name formula . args)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form args)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(null transportable) '(theory) '(theory))
    (let* ((theory-or-language-name
	    (cadr (assq 'theory keyword-args))))

      (if (subset? '(null transportable)  modifiers) 
	  (wrap-with-def-form-bind
	   the-name 'SCHEMATIC-MACETE
	   `(add-unsafe-transportable-macete
	     ',the-name
	     (qr ,formula (theory-language (name->theory ',theory-or-language-name)))
	     (name->theory ',theory-or-language-name)))
	  (let ((proc-name 
		 (if (subset?  '(transportable) modifiers)
		     'install-transportable-macete
		     (if (subset?  '(null) modifiers)
			 'add-unsafe-elementary-macete
			 'add-elementary-macete))))
	    (wrap-with-def-form-bind
	     the-name 'SCHEMATIC-MACETE
	     `(,proc-name ',the-name
			  (qr ,formula (or (name->language ',theory-or-language-name)
					   (theory-language (name->theory ',theory-or-language-name)))))))))))

(define-syntax (DEF-LANGUAGE the-name . language-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form language-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(extensible sorts base-types embedded-language embedded-languages constants) 
     '())
    (wrap-with-def-form-bind
     the-name 'LANGUAGE
     `(language-from-definition '(,the-name ,@language-definition-forms)))))

(define-syntax (DEF-SUBLANGUAGE the-name . sublanguage-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form sublanguage-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(superlanguage languages sorts constants) 
     '(superlanguage))
    (let ((superlanguage-name (cadr (assq 'superlanguage keyword-args)))
	  (language-names (cdr (assq 'languages keyword-args)))
	  (sort-names (cdr (assq 'sorts keyword-args)))
	  (constant-names (cdr (assq 'constants keyword-args))))
      (wrap-with-def-form-bind
       the-name 'SUBLANGUAGE
       `(make-sublanguage
	',the-name
	',superlanguage-name 
	',language-names 
	',sort-names 
	',constant-names)))))

(define-syntax (DEF-THEORY the-name . theory-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form theory-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(language component-theories axioms distinct-constants) 
     '())
    (let ((axioms (assq 'axioms theory-definition-forms)))
      (if axioms
	  (set (cdr axioms)
	       (map (lambda (axiom-spec)
		      (if (string? (car axiom-spec))
			  `(() ,(car axiom-spec) ,(cdr axiom-spec))
			  `(,(car axiom-spec) ,(cadr axiom-spec) ,(cddr axiom-spec))))
		    (cdr axioms))))
      (wrap-with-def-form-bind
       the-name 'THEORY
       `(theory-from-definition '(,the-name ,@theory-definition-forms))))))

(define-syntax (DEF-ATOMIC-SORT the-name quasi-sort-string . sort-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form sort-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(theory usages witness)
     '(theory))
    (let ((theory-name (cadr (assq 'theory keyword-args)))
	  (usage-list (cdr (assq 'usages keyword-args)))
	  (witness-string (cadr (assq 'witness keyword-args))))
      (if (not witness-string)
	  (wrap-with-def-form-bind
	   the-name 'ATOMIC-SORT
	   `(apply
	     theory-build-sort-definition
	     (name->theory ',theory-name)
	     ',the-name 
	     (qr ,quasi-sort-string (theory-language (name->theory ',theory-name)))
	     ',usage-list))
	  (wrap-with-def-form-bind
	   the-name 'ATOMIC-SORT
	   `(apply
	     theory-build-sort-definition-with-witness
	     (name->theory ',theory-name)
	     ',the-name 
	     (qr ,quasi-sort-string (theory-language (name->theory ',theory-name)))
	     (qr ,witness-string (theory-language (name->theory ',theory-name)))
	     ',usage-list))))))

(define-syntax (DEF-CONSTANT the-name defining-expr-string . direct-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form direct-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(theory sort usages) 
     '(theory))
    (let ((theory-name (cadr (assq 'theory keyword-args)))
	  (sort-string (cadr (assq 'sort keyword-args)))
	  (usage-list (cdr (assq 'usages keyword-args))))
      (if sort-string
	  (wrap-with-def-form-bind
	   the-name 'CONSTANT
	   `(let ((theory (name->theory ',theory-name)))
	      (theory-build-definition 
	       theory 
	       ',the-name 
	       (qr ,defining-expr-string (theory-language theory))
	       (string->sort (theory-language theory) ,sort-string)
	       ',usage-list)))
	  (wrap-with-def-form-bind
	   the-name 'CONSTANT
	   `(let ((theory (name->theory ',theory-name)))
	      (theory-build-definition 
	       theory 
	       ',the-name 
	       (qr ,defining-expr-string (theory-language theory))
	       (expression-sorting 
		(qr ,defining-expr-string (theory-language theory)))
	       ',usage-list)))))))

(define-syntax (DEF-RECURSIVE-CONSTANT the-names defining-func-strings . rec-def-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form rec-def-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(theory definition-name usages) 
     '(theory))
    (let ((theory-name (cadr (assq 'theory keyword-args)))
	  (constant-name-list (if (list? the-names)
				  the-names
				  (list the-names)))
	  (functional-string-list (if (list? defining-func-strings)
				      defining-func-strings
				      (list defining-func-strings)))
	  (definition-name (cadr (assq 'definition-name keyword-args)))
	  (usage-list (cdr (assq 'usages keyword-args))))
      (wrap-with-def-form-bind
       (cond ((symbol? the-names) the-names)
	     ((symbol? (car the-names)) (car the-names))
	     (else '()))
       'RECURSIVE-CONSTANT
       `(apply
	 theory-build-recursive-definition
	 (name->theory ',theory-name)
	 ',constant-name-list
	 (map
	  (lambda (fs)
	    (qr fs (theory-language (name->theory ',theory-name))))
	  ',functional-string-list)
	 ',definition-name
	 ',usage-list)))))

(define-syntax (DEF-RENAMER the-name . renamer-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form renamer-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(pairs) 
     '(pairs))
    (let ((pairs (cdr (assq 'pairs keyword-args))))
    (wrap-with-def-form-bind
     the-name 'RENAMER
     `(define ,the-name
       (lambda (x)
	 (let ((pair (assq x ',pairs)))
	   (if pair
	       (cadr pair)
	       x))))))))

(define-syntax (DEF-QUASI-CONSTRUCTOR the-name lambda-expr-string . quasi-constructor-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form quasi-constructor-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(language fixed-theories) 
     '(language))
    (let ((language-or-theory-name (cadr (assq 'language keyword-args)))
	  (fixed-theories-name-list (cdr (assq 'fixed-theories keyword-args))))
      (wrap-with-def-form-bind
       the-name 'QUASI-CONSTRUCTOR
       `(build-quasi-constructor-from-lambda-expression
	',the-name
	(let ((language
	       (or (name->language ',language-or-theory-name)
		   (theory-language (name->theory ',language-or-theory-name)))))
	  (qr ,lambda-expr-string language))
	(map name->theory ',fixed-theories-name-list))))))

(define (theory-verify-etc lemma? . rest)
  (if (not lemma?)
      (block0 
       (apply theory-verify-modify-and-add-theorem-aux rest)
       (clear-em))
      '#f))

(define-syntax (DEF-THEOREM the-name formula-spec . theorems-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form theorems-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(reverse lemma) 
     '(theory usages translation macete home-theory proof)
     '(theory))
    (let* ((lemma (memq? 'lemma modifiers))
	   (reverse (car (memq 'reverse modifiers)))
	   (theory-name (cadr (assq 'theory keyword-args)))
	   (translation-name (cadr (assq 'translation keyword-args)))
	   (macete-name (cadr (assq 'macete keyword-args)))
	   (usage-list (cdr (assq 'usages keyword-args)))
	   (home-theory-name (cond ((cadr (assq 'home-theory keyword-args)))
				   (translation-name
				    (name 
				     (translation-source-theory 
				      (name->translation translation-name))))
				   (else			    
				    theory-name)))
	   (proof-spec (cadr (assq 'proof keyword-args))))
      (if reverse
	  (wrap-with-def-form-bind
	   the-name 'THEOREM
	   `(list (theory-verify-etc
		   (and ',lemma (quick-load?))
		   ',theory-name ',formula-spec ',the-name ',usage-list
		   ',translation-name ',macete-name ',home-theory-name ',proof-spec)
		  (theory-verify-etc
		   (and ',lemma (quick-load?))
		   ',theory-name ',formula-spec ',the-name ',usage-list
		   ',translation-name ',macete-name ',home-theory-name ',proof-spec '#t)))
	  (wrap-with-def-form-bind
	   the-name 'THEOREM
	   `(theory-verify-etc
	     (and ',lemma (quick-load?))
	     ',theory-name ',formula-spec ',the-name ',usage-list
	     ',translation-name ',macete-name ',home-theory-name ',proof-spec))))))

(define-syntax (DEF-INDUCTOR the-name induction-principle . inductor-definition-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form inductor-definition-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(theory dont-unfold translation base-case-hook induction-step-hook) '(theory))
    (let* ((theory-name (cadr (assq 'theory keyword-args)))
	   (dont-unfold-names (cdr (assq 'dont-unfold keyword-args)))

	   (base-case-name (cadr (assq 'base-case-hook keyword-args)))
	   (induction-step-name (cadr (assq 'induction-step-hook keyword-args)))
	   (base-case-hook (or (name->macete base-case-name)
			       (name->command base-case-name)))
	   (induction-step-hook (or (name->macete induction-step-name)
				    (name->command induction-step-name)))
	   (translation-name (cadr (assq 'translation keyword-args))))			
      (if (and induction-step-name (null? induction-step-hook))
	  (imps-error "DEF-INDUCTOR: No macete or command with name ~A." induction-step-name))
      (if (and base-case-name (null? base-case-hook))
	  (imps-error "DEF-INDUCTOR: No macete or command with name ~A." base-case-name))

      (wrap-with-def-form-bind
       the-name 'INDUCTOR
       `(let* ((theory (name->theory ',theory-name))
	       (target-theory ,(if translation-name
				   `(translation-target-theory
				     (name->translation ',translation-name))
				   'theory)))
	  (reset-dont-unfold
	   ,(if translation-name
		`(build-translated-inductor-from-induction-principle
		  (name->translation ',translation-name)
		  ,(if (string? induction-principle)
		       `(qr ,induction-principle (theory-language theory))
		       `(name->theorem ',induction-principle))
		  ',the-name
		  (or (name->macete ',base-case-name)
		      (name->command ',base-case-name))
		  (or (name->macete ',induction-step-name)
		      (name->command ',induction-step-name)))
		`(build-inductor-from-induction-principle
		  ,(if (string? induction-principle)
		       `(qr ,induction-principle (theory-language theory))
		       `(name->theorem ',induction-principle))	
		  ',the-name
		  (or (name->macete ',base-case-name)
		      (name->command ',base-case-name))
		  (or (name->macete ',induction-step-name)
		      (name->command ',induction-step-name))))
	   ',dont-unfold-names
	   target-theory))))))

(define (reset-dont-unfold inductor dont-unfold-names theory)
  (set (inductor-dont-unfold inductor)
       (if (memq? '#t dont-unfold-names)
	   '#t
	   (map (lambda (symb)
		  (find-constant
		   (theory-language theory)
		   symb))
		dont-unfold-names)))
  inductor)

(define-syntax (DEF-THEORY-ENSEMBLE the-name . theory-ensemble-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form theory-ensemble-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(replica-renamer fixed-theories) '())
    (let ((renamer (cadr (assq 'replica-renamer keyword-args)))
	  (fixed-theories (cdr (assq 'fixed-theories keyword-args))))
      (or (null? renamer)
	  (symbol? renamer)
	  (imps-error "DEF-THEORY-ENSEMBLE: renamer must be a symbol."))
     (wrap-with-def-form-bind
      the-name 'THEORY-ENSEMBLE
      `(build-theory-ensemble
	(name->theory ',the-name)
	,(if fixed-theories
	     `(list ,@(map (lambda (x) `(name->theory ',x)) fixed-theories))
	     `(fixed-theories-set))
	,(if renamer renamer 'subscripting-renamer))))))


(define (digest-processor-specs type forms)
  (if (symbol? forms)
      (list (list type forms))
      (if (null? forms)
	  forms
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(commutes use-numerals-for-ground-terms) '(scalars operations) '(operations))
    (if (memq? 'commutes modifiers)
	(push keyword-args '(commutes #t)))
    (if (memq? 'use-numerals-for-ground-terms modifiers)
	(push keyword-args '(numerals-for-ground-terms? #t)))
    (list (list type keyword-args))))))

(define-syntax (DEF-ALGEBRAIC-PROCESSOR the-name . processor-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form processor-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(cancellative) '(language base exponent coefficient) '(language))
    (let ((cancellative (memq? 'cancellative  modifiers))
	  (language-name (cadr (assq 'language keyword-args)))
	  (base-forms (cadr (assq 'base keyword-args)))
	  (exponent-forms (cadr (assq 'exponent keyword-args)))
	  (coefficient-forms (cadr (assq 'coefficient keyword-args))))
      (wrap-with-def-form-bind
       the-name 'ALGEBRAIC-PROCESSOR
       `(let ((processor (algebraic-processor-from-definition
			  '(,the-name
			    (language ,language-name)
			    ,@(digest-processor-specs 'base base-forms)
			    ,@(digest-processor-specs 'exponent exponent-forms)
			    ,@(digest-processor-specs 'coefficient coefficient-forms)))))
	  (set (algebraic-processor-cancellation-valid? processor)
	       (or ',cancellative (algebraic-processor-cancellation-valid? processor)))
	  processor)))))

(define-syntax (DEF-ORDER-PROCESSOR the-name . processor-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form processor-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(algebraic-processor operations discrete-sorts) '(algebraic-processor operations))
    (let ((algebraic-processor-name (cadr (assq 'algebraic-processor keyword-args)))
	  (operations (cdr (assq 'operations keyword-args)))
	  (discrete-sorts (cdr (assq 'discrete-sorts keyword-args))))
      (wrap-with-def-form-bind
       the-name 'ORDER-PROCESSOR
       `(order-processor-from-definition
	 '(,the-name
	   (algebraic-processor ,algebraic-processor-name)
	   (operations ,@operations)
	   (discrete-sorts ,@discrete-sorts ))))))) 

(define (fixed-theories-from-keywords args)
  (cond ((assq 'fixed-theories args)
	 =>
	 (lambda (x)
	   `(list ,@(map (lambda (x) `(name->theory ',x)) (cdr x)))))
	('(fixed-theories-set))))

(define-syntax (DEF-THEORY-ENSEMBLE-MULTIPLE ensemble-name multiple . args)
  (let ((fixed-theories (fixed-theories-from-keywords args)))
    `(let ((ensemble (find-theory-ensemble
		      (name->theory ',ensemble-name) ,fixed-theories)))
       (theory-ensemble-find-theory-multiple ensemble ,multiple))))

;;(copy-syntax 'def-theory-ensemble-multiple 'theory-ensemble-install-multiple)

(define-syntax (DEF-THEORY-ENSEMBLE-OVERLOADINGS ensemble-name  multiples . args)
  (let ((fixed-theories (fixed-theories-from-keywords args)))
    `(let ((ensemble (find-theory-ensemble
		      (name->theory ',ensemble-name) ,fixed-theories)))
       (walk (lambda (x)
	       (theory-ensemble-install-overloadings-for-defined-constants ensemble x))
	     ',multiples)
       '#t)))

;;(copy-syntax 'def-theory-ensemble-overloadings 'theory-ensemble-install-overloadings)

(define-syntax (DEF-THEORY-ENSEMBLE-INSTANCES ensemble-name  . args)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form args)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(force force-under-quick-load)
     '(sorts constants
	     target-theories
	     target-multiple
	     multiples
	     permutations
	     theory-interpretation-check
	     fixed-theories
	     special-renamings)
     '())
    (let* ((force (car (memq 'force modifiers)))
	   (force-under-quick-load (car (memq 'force-under-quick-load modifiers)))
	   (sort-name-associations (cdr (assq 'sorts keyword-args)))
	   (fixed-theories (fixed-theories-from-keywords keyword-args))	
	   (multiples (cdr (assq 'multiples keyword-args)))
	   (target-multiple (cadr (assq 'target-multiple keyword-args)))
	   (target-theory-names  (cdr (assq 'target-theories keyword-args)))
	   (permutations (cdr (assq 'permutations keyword-args)))
	   (constant-name-associations  (cdr (assq 'constants keyword-args)))

	   (check-methods
	    (list force
		  force-under-quick-load
		  (cadr (assq 'theory-interpretation-check keyword-args))))
	  
	   (special-renamings (cdr (assq 'special-renamings keyword-args))))
      (or permutations multiples
	  (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES: missing keyword ~A or ~A."
		      'permutations 'multiples))
      (or target-multiple target-theory-names
	  (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES:  missing keyword ~A or ~A."
		      'target-multiple 'target-theories))
      (and target-multiple target-theory-names
	   (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES:  exclusive keywords ~A or ~A."
		       'target-multiple 'target-theories))
;;;      (and target-multiple (any? identity check-methods)
;;;	   (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES:  exclusive keywords ~A or ~A."
;;;		       'target-multiple 'theory-interpretation-check))
      (if target-theory-names
	  (or (and constant-name-associations sort-name-associations)
	      (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES:  missing keyword argument ~A or ~A." 'sorts 'constants)))
      (build-def-theory-ensemble-instances-form
       ensemble-name
       fixed-theories
       sort-name-associations
       multiples
       target-multiple 
       target-theory-names
       permutations
       constant-name-associations
       check-methods
       special-renamings))))
       

(define (build-def-theory-ensemble-instances-form
	 ensemble-name
	 fixed-theories
	 sort-name-associations
	 multiples
	 target-multiple 
	 target-theory-names
	 permutations
	 constant-name-associations
	 check-methods
	 special-renamings)
  `(let ((ensemble (find-theory-ensemble (name->theory ',ensemble-name) ,fixed-theories)))
     (if (null? ensemble)
	 (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES: No ensemble with name ~A." ',ensemble-name))
	     
     ,@(if target-theory-names
	   `((let ((target-theories (map name->theory ',target-theory-names)))
	       (walk (lambda (theory-name theory)
		       (if (null?  theory)
			   (imps-error "DEF-THEORY-ENSEMBLE-INSTANCES: No theory with name ~A." theory-name)))
		     ',target-theory-names target-theories)
	       (map (lambda (x)
		      (theory-interpretation-check-using-method x ',check-methods '#t))
		    (set-union
		     (transport-definitions-from-theory-multiples
		      ensemble
		      ',multiples
		      target-theories
		      ',sort-name-associations
		      ',constant-name-associations
		      ',special-renamings)
		     (theory-ensemble-transport-definitions-from-theory-multiples-using-multiple-permutations
		      ensemble
		      target-theories
		      ',permutations
		      ',sort-name-associations
		      ',constant-name-associations
		      ',special-renamings)))))
	   '())

     ,@(if target-multiple
	   `((transport-defined-sorts-and-constants-to-theory-multiple
	      ensemble
	      ',multiples
	      ,target-multiple)
	     (transport-defined-sorts-and-constants-to-theory-multiple-using-permutations
	      ensemble
	      ',permutations
	      ,target-multiple))
	   '())))


;;(copy-syntax 'def-theory-ensemble-instances 'theory-ensemble-install-instances)

(define-syntax (DEF-THEORY-INSTANCE the-name . th-instance-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form th-instance-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(source target translation fixed-theories renamer new-translation-name)
     '(source target translation))
    (let* ((source-theory-name (cadr (assq 'source keyword-args)))
	   (target-theory-name (cadr (assq 'target keyword-args)))
	   (trans-name (cadr (assq 'translation keyword-args)))
	   (fixed-theories-name-list (cdr (assq 'fixed-theories keyword-args)))
	   (renamer (cadr (assq 'renamer keyword-args)))
	   (new-trans-name (cadr (assq 'new-translation-name keyword-args))))
      `(transport-theory (name->translation ',trans-name)
			 (name->theory ',source-theory-name)
			 (name->theory ',target-theory-name)
			 (map name->theory ',fixed-theories-name-list)
			 ,(or renamer '(lambda (x) (concatenate-symbol x '%)))
			 ',new-trans-name
			 '#f
			 ',the-name))))

(define-syntax (DEF-TRANSLATION the-name . translation-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form translation-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(force force-under-quick-load dont-enrich) 
     '(source target assumptions fixed-theories 
       sort-pairs constant-pairs 
       core-translation theory-interpretation-check)
     '(source target))
    (let* ((force (car (memq 'force modifiers)))
	   (force-under-quick-load (car (memq 'force-under-quick-load modifiers)))
	   (dont-enrich (car (memq 'dont-enrich modifiers)))
	   (source-theory-name (cadr (assq 'source keyword-args)))
	   (target-theory-name (cadr (assq 'target keyword-args)))
	   (assumptions-string-list (cdr (assq 'assumptions keyword-args)))
	   (fixed-theories-name-list (cdr (assq 'fixed-theories keyword-args)))
	   (sort-pair-list (cdr (assq 'sort-pairs keyword-args)))
	   (constant-pair-list (cdr (assq 'constant-pairs keyword-args)))
	   (check-methods 
	    (list force 
		  force-under-quick-load
		  (cadr (assq 'theory-interpretation-check keyword-args))))
	   (core-translation-name (cadr (assq 'core-translation keyword-args)))
	   (enrich-trans? (if dont-enrich '#f '#t))
	   (translation
	    (wrap-with-def-form-bind
	     the-name 'TRANSLATION
	     `(translation-from-definition
	       '(,the-name
		 (source ,source-theory-name)
		 (target ,target-theory-name)
		 (assumptions ,@assumptions-string-list)
		 (fixed-theories ,@fixed-theories-name-list)
		 (sort-pairs ,@sort-pair-list)
		 (constant-pairs ,@constant-pair-list)
		 (core-translation ,core-translation-name)
		 (enrich? ,enrich-trans?))))))
      `(theory-interpretation-check-using-method ,translation ',check-methods '#t))))

(define-syntax (DEF-THEORY-PROCESSORS theory-name . keyword-arguments)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form keyword-arguments)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(algebraic-simplifier algebraic-order-simplifier algebraic-term-comparator)
     '())
    (let ((listify (lambda (x) (list (car x) (cdr x)))))
      (let ((alg-simp (map listify 
			   (cdr (assq 'algebraic-simplifier keyword-arguments))))
	    (order-simp (map listify 
			     (cdr (assq 'algebraic-order-simplifier keyword-arguments))))
	    (term-comp (cdr (assq 'algebraic-term-comparator keyword-arguments))))
	`(term-simplifier-from-definition
	  '((theory ,theory-name)
	    (algebraic-simplifier ,@alg-simp)
	    (algebraic-order-simplifier ,@order-simp)
	    (algebraic-term-comparator ,@term-comp)))))))



;;(copy-syntax 'def-theory-processors 'theory-install-processors)
	

(define-syntax (DEF-PARSE-SYNTAX constant-name . keywords)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form keywords)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(binding token left-method null-method table)
     '(binding))

    (let ((left-method (cadr (assq 'left-method keyword-args)))
	  (null-method (cadr (assq 'null-method keyword-args)))
	  (binding (cadr (assq 'binding keyword-args)))
	  (token (cadr (assq 'token keyword-args)))
	  (table (cadr (assq 'table keyword-args))))
      (or left-method null-method (imps-error "DEF-PARSE-SYNTAX: no parsing method provided for constant ~A" constant-name))
      `(let ((table ,(if table table '*parse*))
	     (token ',(if token token constant-name)))
	 (coerce-symbol-to-token
	  (parser-tokenizer table)
	  token)
	  
	 (make-operator
	   table
	   token
	   ',constant-name
	   ,(if null-method null-method ''())
	   ,(if left-method left-method ''())
	   ',binding)))))
      
;;(copy-syntax 'def-parse-syntax 'add-parse-syntax)

(define-syntax (DEF-PRINT-SYNTAX constant-name . keywords)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form keywords)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(tex) 
     '(binding method token table)
     '(binding method))
     (let ((method (cadr (assq 'method keyword-args)))
	   (binding (cadr (assq 'binding keyword-args)))
	   (token (cadr (assq 'token keyword-args)))
	   (table (if (memq? 'tex modifiers)
		      '*tex-form*
		      (cadr (assq 'table keyword-args)))))
       `(make-presentation-format 
	 ,(if table table '*form*)
	 ',constant-name
	 ',(if token token constant-name)
	 ,method
	 ',binding))))

;;(copy-syntax 'def-print-syntax 'add-print-syntax)

(define-syntax (DEF-RECORD-THEORY theory-name . args)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form args)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(type accessors) '(type accessors)))
  (let ((type (cadr (assq 'type args)))
	(accessors (cdr (assq 'accessors args))))
    `(make-record-theory-with-sortnames (name->theory ',theory-name) ',type ',accessors)))

(define-syntax (DEF-TRANSPORTED-SYMBOLS the-names . ts-def-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form ts-def-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(translation renamer) 
     '(translation))
    (let ((translation-name (cadr (assq 'translation keyword-args)))
	  (renamer (cadr (assq 'renamer keyword-args))))
      (wrap-with-def-form-bind
       the-names 'TRANSPORTED-SYMBOLS
       `(let* ((translation (name->translation ',translation-name))
	       (source-language (theory-language (translation-source-theory translation))))
	  (transport-defined-sorts-and-constants
	   translation
	   (map 
	    (lambda (sym)
	      (or (find-constant source-language sym)
		  (name->sort source-language sym)))
	    (if (list? ',the-names)
		',the-names
		(list ',the-names)))
	   ,(or renamer '(lambda (x) x))))))))


(define-syntax (DEF-CARTESIAN-PRODUCT product-sort-name component-sort-names . args)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form args)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(constructor accessors theory) '(theory))
    (let ((builder-name (cadr (assq 'constructor args)))
	  (accessor-names (cdr (assq 'accessors args)))
	  (theory (cadr (assq 'theory args))))
      (wrap-with-def-form-bind
       the-name 'CARTESIAN-PRODUCT
       `(let ((theory (name->theory ',theory)))
	 (block0
	  (cartesian-product theory ',product-sort-name ',component-sort-names)
	  (cartesian-product-builder-and-selectors-build-definitions
	   theory	
	   ',product-sort-name 
	   ',component-sort-names
	   ',builder-name
	   ',accessor-names)))))))

(define-syntax (def-imported-rewrite-rules theory . args)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form args)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(source-theories source-theory) '())
    (let ((source-theory-names (set-union
				(cdr (assq 'source-theories args))
				(cdr (assq 'source-theory args)))))
      `(import-rewrite-rules ',theory ',source-theory-names))))

(define (import-rewrite-rules theory-name source-theory-names)
  (theory-import-transportable-rewrite-rules
   (name->theory theory-name)
   (map name->theory source-theory-names)))



(define-syntax (DEF-OVERLOADING symbol . theory-name-pairs)
  `(install-overloaded-name-for-symbol-names ',symbol ',theory-name-pairs))


(define-syntax (DEF-BNF theory-name . form-alist)
  (wrap-with-def-form-bind
   the-name 'BNF
   `(bnf-build-theory ',theory-name ',form-alist)))

(define-syntax (DEF-PRIMITIVE-RECURSIVE-CONSTANT constant-name bnf . clauses)
  (let ((target-theory-form (assq 'theory clauses))
	(range-sort-form (assq 'range-sort clauses)))
    (cond
     ((not target-theory-form)
      (imps-error
       "def-primitive-recursive-constant:~%~A"
       "Target theory form missing; must look like (theory <theory-name>)."))
     ((not (theory? (name->theory (cadr target-theory-form))))
      (imps-error "def-primitive-recursive-constant:~%    ~A ~A"
		  (cadr target-theory-form)
		  "does not name a theory currently known to IMPS"))
     ((not (bnf? (name->bnf bnf)))
      (imps-error "def-primitive-recursive-constant:~%    ~A ~A"
		  bnf
		  "does not name a BNF theory currently known to IMPS"))
     ((not range-sort-form)
      (imps-error "def-primitive-recursive-constant:~%~A"
		  "Target range form missing; must look like (range-sort <sorting>)."))
     (else
      (let ((sort (string-or-list->sort
		   (theory-language (name->theory (cadr target-theory-form)))
		   (cadr range-sort-form))))
	(if (not sort)
	    (imps-error "def-primitive-recursive-constant:~%~A ~S ~A ~A."
			"Target range form" (cadr range-sort-form)
			"does not evaluate to a sort in language"
			(theory-language (name->theory (cadr target-theory-form))))
	    (wrap-with-def-form-bind
	     constant-name 'PRIMITIVE-RECURSIVE-CONSTANT
	     `(bnf-build-pr-constant
	       ',constant-name
	       ',(name->bnf bnf)
	       ',(name->theory (cadr target-theory-form))
	       ',sort
	       ',clauses))))))))

(define-syntax (DEF-SCRIPT the-name arg-count script . forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() '(retrieval-protocol applicability-recognizer) '())
    (wrap-with-def-form-bind
     the-name 'SCRIPT
     (let ((protocol (or (cadr (assq 'retrieval-protocol forms))
			 'general-argument-retrieval-protocol))
	   (recognizer (cadr (assq 'applicability-recognizer forms))))
       `(block0
	 (build-script ,arg-count ',script ',protocol ',recognizer ',the-name)
	 (emacs-eval
	  (string-downcase
	   (format nil "(add-imps-command \"~A\" '~A)" ',the-name ',protocol))))))))

(define-syntax (DEF-SECTION the-name . renamer-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form renamer-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '() 
     '(component-sections files auxiliary-file) 
     '())
    (let ((components (cdr (assq 'component-sections keyword-args)))
	  (filespecs (cdr (assq 'files keyword-args)))
	  (auxiliary-filespec (cadr (assq 'auxiliary-file keyword-args))))
      (wrap-with-def-form-bind
       the-name 'SECTION
       `(build-section
	 ',the-name
	 ',components
	 ',filespecs
	 ,(if (string? auxiliary-filespec)
	      auxiliary-filespec
	      `',auxiliary-filespec))))))


