;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(provide 'tags-reader)

(defun make-obarray ()
  (make-vector 511 0))

(defconst imps-theorem-obarray (make-obarray))
(defconst imps-theory-obarray (make-obarray))
(defconst imps-translation-obarray (make-obarray))
(defconst imps-recursive-constant-obarray (make-obarray))
(defconst imps-constant-obarray (make-obarray))
(defconst imps-inductor-obarray (make-obarray))
(defconst imps-macete-obarray (make-obarray))

(defconst imps-pattern-obarray-alist
  (list (cons "theorem" imps-theorem-obarray)
	(cons "theory" imps-theory-obarray)
	(cons "translation" imps-translation-obarray)
	(cons "constant" imps-constant-obarray)
	(cons "recursive-constant" imps-recursive-constant-obarray)
	(cons "inductor" imps-inductor-obarray)
	(cons "schematic-macete" imps-macete-obarray)
	(cons "compound-macete" imps-macete-obarray)))

(defvar imps-tags-file (expand-file-name (substitute-in-file-name "$IMPS/theories/TAGS")))
(defvar imps-user-tags-file (expand-file-name (substitute-in-file-name "~/theories/TAGS")))
(defvar tmp-tags-file
  (expand-file-name
   (substitute-in-file-name
    (format "$IMPS/tmp/TAGS-%s" (user-login-name)))))

(defun imps-intern-from-tags ()
  (interactive)
  (imps-intern-from-tags-1 imps-tags-file)
  (imps-intern-from-tags-1 imps-user-tags-file))

(defun imps-intern-from-tags-1 (filename)
  (and
   (file-readable-p filename)
   (let ((tags-buff (find-file-noselect filename)))
     (set-buffer tags-buff)
     (setq buffer-read-only t)
     (goto-char (point-min))
     (while (<
	     (progn (forward-page 1) (point))
	     (point-max))
       (narrow-to-page)
       (imps-intern-from-page)
       (widen)))))

(defun imps-intern-from-page ()
  (let ((fn (next-symbol-string (point))))
    (let ((dir (file-name-directory fn))
	  (file (file-name-nondirectory fn)))
      (mapcar
       (function
	(lambda (pattern-obarray)
	  (let ((pattern (car pattern-obarray))
		(array   (cdr pattern-obarray)))
	    (goto-char (point-min))
	    (while (search-forward (concat "(def-" pattern) (point-max) t)
	      (let ((sym (intern (downcase (next-symbol-string (point))) array))
		    (line (progn (search-forward "")
				 (car (read-from-string (next-symbol-string (point)))))))
		(put sym 'directory dir)
		(put sym 'file file)
		(put sym 'line line))))))
       imps-pattern-obarray-alist))))
  
(defun imps-find-definition (array)
  (interactive
   (list
    (let ((kind-name (completing-read "Kind of definition: "
				      '(("theorem") ("theory") ("translation")
					("constant") ("recursive-constant") ("inductor"))
				      (function (lambda (a) t))
				      t
				      nil)))
      (cdr (assoc kind-name imps-pattern-obarray-alist)))))
  (let ((sym (intern-soft
	      (completing-read  "Name: " array (function (lambda (a) t)) t nil)
	      array)))
    (find-file-other-window
     (expand-file-name
      (substitute-in-file-name
       (format "$THEORIES/%s%s.t"
	       (get sym 'directory)
	       (get sym 'file)))))
    (goto-line (get sym 'line))))

(defun imps-theorem-defining-file (theorem)
  (interactive
   (list (intern-soft
	  (completing-read "Theorem name: " imps-theorem-obarray
			   'always t nil)
	  imps-theorem-obarray)))
  (message "$THEORIES/%s%s.t"
	   (get theorem 'directory)
	   (get theorem 'file)))

(defun imps-theorem-loaded-p (thm-name)
  (let ((sym (intern-soft thm-name imps-theorem-obarray)))
    (not
     (not
      (get-literal-from-tea
       (format "(and (file-loaded? \"%s\" imps-implementation-env) 1)"
	       (expand-file-name
		(substitute-in-file-name
		 (format "$THEORIES/%s%s.t"
			 (get sym 'directory)
			 (get sym 'file))))))))))

(defun imps-require-theorem (thm-name)
  (interactive
   (list
    (completing-read "Theorem name: " imps-theorem-obarray 'always t nil)))
  (let ((sym (intern-soft thm-name imps-theorem-obarray)))
    (if (y-or-n-p
	 (format "Really require file $THEORIES/%s%s? "
		 (get sym 'directory)
		 (get sym 'file)))
	(tea-eval-expression
	 (format "(*require nil '(theories %s%s) imps-implementation-env)"
		 (get sym 'directory)
		 (get sym 'file)))
      (error "Not requiring file $THEORIES/%s%s."
	     (get sym 'directory)
	     (get sym 'file)))))

(defun imps-get-theorem-var-sorts (thm-name)
  (let ((var-sorts
	 (get-literal-from-tea
	  (format
	   "(theorem-name->var-sort-list '%s)"
	   thm-name))))
    (put (intern thm-name imps-theorem-obarray)
	 'var-sorts
	 var-sorts)))

(defun complete-macete-name (str)
  (let ((thm-completion (try-completion str imps-theorem-obarray))
	(macete-completion (try-completion str imps-macete-obarray)))
    (cond ((or (eq thm-completion t) (eq macete-completion t)) str)
	  ((and (<= 3 (length str))
		(string= "tr%" (substring str 0 3)))
	   (let* ((eff-str (substring str 3))
		  (tr-macete-completion
		   (try-completion eff-str imps-theorem-obarray))
		  (completion
		   (try-completion
		    eff-str
		    (mapcar
		     'list
		     (list thm-completion macete-completion tr-macete-completion)))))
	     (if (stringp completion)
		 (concat "tr%" completion)
	       completion)))
	  (t (try-completion
	      str
	      (mapcar
	       'list
	       (list thm-completion macete-completion)))))))

(defun all-macete-completions (str)
  (append
   (all-completions str imps-macete-obarray)
   (mapcar '(lambda (str2)
	      (concat "tr%" str2))
	   (and (<= 3 (length str))
		(string= "tr%" (substring str 0 3))
		(all-completions (substring str 3) imps-theorem-obarray)))
   (all-completions str imps-theorem-obarray)))


(defun insert-complete-macete-name ()
  (interactive)
  (let ((str (buffer-string)))
    (let ((completion (complete-macete-name str)))
      (cond ((or (eq t completion)
		 (string= completion str))
	     (with-output-to-temp-buffer " *Completions*"
	       (display-completion-list (all-macete-completions str))))
	    ((stringp completion)
	     (erase-buffer)
	     (insert completion))
	    ((null completion)
	     (ding)
	     (message "No match."))))))
	   
	   
(defconst macete-minibuffer-map (copy-keymap minibuffer-local-map))
(define-key macete-minibuffer-map " " 'insert-complete-macete-name)
  

(defun read-macete ()
  (interactive)
  (let ((minibuffer-local-map macete-minibuffer-map))
    (read-minibuffer "Macete name: ")))
      

(define-key scheme-mode-map "\C-c." 'imps-find-definition)
(define-key inferior-tea-mode-map "\C-c." 'imps-find-definition)


