;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


;;; IMPS startup under Emacs.

;;; You must define the environment variable IMPS to be the 
;;; root of the IMPS T source directory.

;;; Add the following to your .emacs file:
;;; (autoload 'run-imps
;;;	  (concat (getenv "IMPS") "/../el/pre-imps")
;;;	  "Run IMPS"
;;;	  t)
;;; (autoload 'run-imps-thunk
;;;	  (concat (getenv "IMPS") "/../el/pre-imps")
;;;	  "Run IMPS"
;;;	  t)

;;; Start IMPS with "M-x run-imps".

(defvar imps-alter-load-path t "Non-nil (default) means loading IMPS will alter load path.")
(defvar imps-alter-tea-program-name t "Non-nil (default) means loading IMPS will alter variable  tea-program-name.")
(defvar imps-default-size "16000000" "*Default size for starting up an IMPS process.")
(defvar imps-edit-window-configuration nil "Stores window configuration for use in IMPS-edit")

(defvar *imps-emacs-version* 1)

(defvar imps-grep-path
  '("$IMPS" "$EXPRESSIONS" "$SUBSTITUTION" "$INFERENCES" "$PRESENTATION"
    "$THEORY_MECHANISM" "$THEORY_INFERENCE" "$TRANSLATIONS" "$THEORIES/*"))
(defvar imps-remote nil "*If non-nil, execute IMPS remotely on fatima or $T_HOST.  Default: nil") 
(defvar imps-preferred-directory
  (let ((dir (expand-file-name "~/imps/theories/")))
    (if (file-exists-p dir)
	dir
      (substitute-in-file-name "$IMPS/theories/")))
  "Directory in which to run IMPS, normally ~/imps/theories/ if that exists; otherwise 
$IMPS/theories/.")
  
;;;(defvar imps-dump-name "$IMPS/../bin/imps_dump"
;;;  "*Special executable dump to use to start up IMPS.  Nil for the usual dump.")

(if imps-alter-load-path
    (setq load-path (append load-path '("$IMPS/../el"))))

(setq imps-alter-load-path nil)
;;(defvar *imps-instruction-mode* nil)

(require 'tea)
(require 'imps)
(provide 'pre-imps)
(setq tea-exit-breakpoint-char ?\^E)

(defvar imps-dump-name
 (cond ((getenv "EXECUTABLE"))
       (t (substitute-in-file-name "$IMPS/../executables/foundation")))

  "*Special executable dump to use to start up IMPS.")

(or (fboundp 'make-shell)
    (fset 'make-shell 'make-comint))


(defun maintain-imps (arg)
  (interactive
   (list (if (or (not (boundp 'tea-process))
		 (null tea-process)
		 (not (eq 'run (process-status tea-process)))
		 (y-or-n-p "Tea process running; really load IMPS? "))
	     (read-from-minibuffer
	      (format "Heap size for IMPS: (default %s)"
		      "24000000"))
	   (pop-to-buffer "*tea*")
	   (error "Tea process running."))))
  (let ((tea-program-name
	 (concat (getenv "IMPS") "/../bin/maintain_imps")))
    (tea (if (string-equal arg "")
	     (format "-h %s" "24000000")
	   (concat "-h " arg))))
  (let ((process-name "*tea*"))
    (tea-eval-expression "(load-quietly '(imps pre-imps) standard-env)\n")
    (tea-eval-expression "(set (repl-env) imps-implementation-env) \n")
    (turn-on-process-filter process-name)
    (tea-eval-expression "(load-imps t) \n")))

(defun maintain-new-imps (arg)
  (interactive
   (list (if (or (not (boundp 'tea-process))
		 (null tea-process)
		 (not (eq 'run (process-status tea-process)))
		 (y-or-n-p "Tea process running; really load IMPS? "))
	     (read-from-minibuffer
	      (format "Heap size for IMPS: (default %s)"
		      "24000000"))
	   (pop-to-buffer "*tea*")
	   (error "Tea process running."))))
  (let ((tea-program-name
	 (concat (getenv "IMPS") "/../bin/maintain_imps")))
    (tea (if (string-equal arg "")
	     (format "-h %s" "24000000")
	   (concat "-h " arg))))
  (let ((process-name "*tea*"))
    (tea-eval-expression "(load-quietly '(imps new-pre-imps) standard-env)\n")
    (tea-eval-expression "(set (repl-env) imps-implementation-env) \n")
    (turn-on-process-filter process-name)
    (tea-eval-expression "(load-imps t) \n")))

(defun run-imps (arg)
  (interactive
   (list (if (or (not (boundp 'tea-process))
		 (null tea-process)
		 (not (eq 'run (process-status tea-process)))
		 (y-or-n-p "Tea process running; really load IMPS? "))
	     (read-from-minibuffer
	      (format "Heap size for IMPS: (default %s)"
		      imps-default-size))
	   (pop-to-buffer "*tea*")
	   (error "Tea process running."))))
  (let ((tea-program-name
	 (concat (getenv "IMPS") "/../bin/imps")))
    (tea (cond ((string-equal arg "")
		(format "%s -h %s"
			(substitute-in-file-name imps-dump-name) imps-default-size))
	       (t (format "%s -h %s"
			  (substitute-in-file-name imps-dump-name) arg)))))
  (let ((process-name "*tea*"))
    (tea-chdir imps-preferred-directory)
    (tea-eval-expression 
     "(load-quietly '(imps user-imps-init) imps-implementation-env)\n")
    (turn-on-process-filter process-name)
    (if (v19-fsf-p)
	(sit-for 2 0 t)
      (sit-for 2 t))
    (tea-eval-expression "(finish-load '())\n")))

;;;(defun run-tutorial-for-imps (arg)
;;;  (interactive
;;;   (list (if (or (not (boundp 'tea-process))
;;;		 (null tea-process)
;;;		 (not (eq 'run (process-status tea-process)))
;;;		 (y-or-n-p "Tea process running; really load IMPS? "))
;;;	     (read-from-minibuffer
;;;	      (format "Heap size for IMPS: (default %s)"
;;;		      imps-default-size))
;;;	   (pop-to-buffer "*tea*")
;;;	   (error "Tea process running."))))
;;;  (setq *imps-instruction-mode* t)
;;;  (run-imps arg))

(defun run-imps-thunk ()
  (interactive)
  (call-interactively 'run-imps))

(defun quit-imps ()
  (interactive)
  (if (y-or-n-p "Confirm: Quit IMPS? ")
      (let ((process-name "*tea*"))
	(process-send-string process-name "(exit)\n")
	(set-buffer tea-script-buffer)
	(save-buffer))
    (ding)
    (recenter)))


(defun imps-grep (target)
  "run grep asynchronously, ignoring case, searching for TARGET throughout the IMPS files" 
  (interactive "sTarget: ")
  (let ((shell-file-name "/bin/sh"))
    (grep (apply
	   'format (make-imps-grep-format)
	   target
	   (mapcar
	    '(lambda (var)
	       (concat var "/*.t"))
	    imps-grep-path)))))

(if (v19-fsf-p)
    
    (defun make-imps-grep-format ()
      "makes format string for imps-grep"
      (apply 'concat
	     "grep -i %s"
	     (mapcar
	      '(lambda (str)
		 " %s")
	      imps-grep-path)))
  (defun make-imps-grep-format ()
    "makes format string for imps-grep"
    (apply 'concat
	   "-i %s"
	   (mapcar
	    '(lambda (str)
	       " %s")
	    imps-grep-path))))


(defun run-imps-maybe (imps)
  "Run IMPS with prefix argument, but run tea only otherwise.
Gets heap size from the variable  imps-default-size (qv)."
  (interactive "P")
  (if (and imps
	   tea-process
	   (not (eq 'run (process-status tea-process))))
      (progn (require 'pre-imps)
	     (run-imps imps-default-size))
    (tea (concat "-h " imps-default-size))))

(defconst major-version (read (substring emacs-version  0 2))
  "Number of major version of this incarnation of emacs, either 18 or 19")

(setq tea-use-comint (= major-version 19))

