;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(defvar def-form-name "")

(defvar df-regexp "^(\\(\\(def\\|load\\|include\\)-[a-zA-Z---]+\\)")
(defvar df-height 7)
(defvar df-number-regexp "^[ ]*\\([0-9]*\\)")

(defvar df-list-map
  (let ((map (make-sparse-keymap)))
    (define-key map "." 'df-show-current-def-form)
    (define-key map "n" 'df-show-next-def-form)
    (define-key map "p" 'df-show-previous-def-form)
    (define-key map "q" 'df-quit)
    (define-key map "e" 'df-evaluate-def-form)
    (define-key map " " 'df-page-def-form)
    (define-key map "\er" 'df-refresh-listing)
    (define-key map "\177" 'df-page-back-def-form)
    map))

(defun df-listing-mode (buff config)
  (kill-all-local-variables)
  (use-local-map df-list-map)
  (make-variable-buffer-local 'df-main-buffer)
  (make-variable-buffer-local 'df-previous-window-config)
  (setq major-mode 'df-listing-mode)
  (setq mode-name "DF-List")
  (setq df-previous-window-config config)
  (setq df-main-buffer buff)
  (setq buffer-read-only 't)
  (run-hooks 'df-listing-mode-hook))
  
(defun df-in-buffer-list ()
  (save-excursion
    (save-restriction
      (widen)
      (goto-char (point-min))
      (let ((accum '())
	    (match-begin nil))
	(while (re-search-forward df-regexp (point-max) t)
	  (setq match-begin (match-beginning 1))
	  (setq accum 
		(cons
		 (buffer-substring match-begin (progn (end-of-line) (point)))
			 
		 accum)))
	(nreverse accum)))))

(defun df-list-in-buffer ()
  "Provide a list of def-forms in current buffer."
  (interactive)
  (let ((dfs (df-in-buffer-list))
	(save (current-buffer))
	(n 1))
    (set-buffer
     (get-buffer-create (concat (format "Def-Forms (%s)" (buffer-name)))))
    (setq buffer-read-only nil)
    (erase-buffer)
    (while dfs
      (insert (format "%4s  " n))
      (setq n (+ 1 n))
      (insert (car dfs))
      (setq dfs (cdr dfs))
      (if dfs (newline)))

    (df-listing-mode save (current-window-configuration))
    (goto-char (point-min))
    (switch-to-buffer (current-buffer))
    (df-show-current-def-form)))

(defun df-refresh-listing ()
  (interactive)
  (set-buffer df-main-buffer)
  (widen)
  (let* ((here (point))

    ;;counting occurrences backwards

	(occurrences
	   (let ((count 0)
		 (beg (point-min)))
	     (end-of-line)
	     (while (re-search-backward df-regexp beg t)
	       (setq count (1+ count)))
	     count)))
    (df-list-in-buffer)
    (df-show-numbered-def-form occurrences)
    (goto-line occurrences)))

(defun df-show-next-def-form ()
  "Show def-form on previous line."
  (interactive)
  (forward-line 1)
  (beginning-of-line)
;  (recenter 't)
  (df-show-current-def-form))

(defun df-show-previous-def-form ()
  "Show def-form on following line."
  (interactive)
  (forward-line -1)
  (beginning-of-line)            
; (recenter 't)
  (df-show-current-def-form)) 

(defun df-show-current-def-form ()
  "Show def-form cursor is on."
  (interactive)
  (let ((num nil))
    (save-excursion
      (beginning-of-line)
;      (set-window-point (selected-window) (point))
      (looking-at df-number-regexp)
      (setq num (car (read-from-string
		      (buffer-substring (match-beginning 1) (match-end 1))))))
    (df-show-numbered-def-form num)))


(defun df-check-window-display-and-resize ()
  (let ((swin (selected-window)))
    (and (eq (next-window (minibuffer-window)) swin)
	 (= 2 (count-windows))
	 (or (= (window-height) df-height)
	     (shrink-window (- (window-height) df-height))
	     't))))

(defun df-show-numbered-def-form (num)
  (interactive "p")
  (let ((save-buf (current-buffer)))
    (save-excursion
      (set-buffer df-main-buffer)
      (let ((bufpos (save-excursion 
		      (save-restriction 
			(widen)
			(goto-char (point-min))
			(re-search-forward df-regexp (point-max) nil num)
			(let ((beg (match-beginning 1))
			      (end (match-end 1)))
			  (setq df-name 
				(downcase
				 (buffer-substring (match-beginning 1) (match-end 1)))))
			(point)))))
	(widen)
	(goto-char bufpos)
	(beginning-of-line)
      
	(let ((beg (point)))
	  (forward-sexp 1)
	  (narrow-to-region beg (point))
	  (goto-char (point-min)))
	(or (df-check-window-display-and-resize)
	    (progn 
	      (delete-other-windows)
	      (split-window-vertically df-height)))
	(let ((win (next-window)))
	  (show-buffer win (buffer-name df-main-buffer))
	  (set-window-point win (point-min))
	  )))
    (set-buffer save-buf)
    (recenter 't)))



(defun df-page-def-form (arg)
  (interactive "P")
  (scroll-other-window arg))

(defun df-page-back-def-form (arg)
  (interactive "P")
  (if arg
      (scroll-other-window (- arg))
    (scroll-other-window (- (window-height (next-window))))))

(defun df-evaluate-def-form ()
  "Evaluate the def-form cursor is on and flag it as evaluated."
  (interactive)
  (let ((buff (current-buffer)))
    (df-show-current-def-form)
    (set-buffer df-main-buffer)
    (tea-eval-expression
     (buffer-substring (point-min) (point-max)))
    (set-buffer buff)
    (df-flag-entry "E")
    (df-show-next-def-form)))

(defun df-flag-entry (flag)
  (let ((buffer-read-only nil))
    (save-restriction
      (let ((end (progn (end-of-line) (point))))
	(beginning-of-line)
	(re-search-forward df-number-regexp end t)
	(delete-char (length flag))
	(insert flag)))))


(defun df-quit ()
  "Quit df-e.
Start by running df-before-quit-hook.  Restore the previous window
configuration, if one exists.  Finish by running df-quit-hook."
  (interactive)
  (if df-previous-window-config
      (set-window-configuration df-previous-window-config))
  (set-buffer df-main-buffer)
  (widen)
  (run-hooks 'df-quit-hook))


(provide 'def-form-edit)
