/*----------------------------------------------------------------------------
    mystd.h	standard types and macros, Mar 5, 1992

    written by Andreas Hohmann, ZIB, Hohmann@sc.ZIB-Berlin.DE
-----------------------------------------------------------------------------*/

#define nil	NULL

#define SQR(x) ((x)*(x))

#define MAX(a,b) (((a)>=(b)) ? a : b)
#define MIN(a,b) (((a)<=(b)) ? a : b)

#define DABS(a) (((a)>=0) ? a : -a)

typedef double Real;
typedef int Int;
typedef enum { false, true } Bool;

#define SWAP(a,b,temp) {temp=a; a=b; b=temp;}
#define REALSWAP(a,b) {Real temp=a; a=b; b=temp;}
#define REALPTRSWAP(a,b) {Real* temp=a; a=b; b=temp;}
#define INTSWAP(a,b) {Int temp=a; a=b; b=temp;}

#define MAX(a,b) (((a)>=(b)) ? a : b)
#define MIN(a,b) (((a)<=(b)) ? a : b)

#define DABS(a) (((a)>=0) ? a : -a)
#define SIGN(a) (((a)>=0) ? 1 : -1)

#define POWER(x,i) (pow(x,(double)(i)))

extern void InitMystd(void), QuitMystd(void);
extern Real EpsMach(void);
extern Real epsMach, sqrtEpsMach;

