/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <stdio.h>
#include <strings.h>
 
#include "kask.h"
#include "kaskcmd.h"
#include "kasktri.h"

#define GETLINE() line=tp;lineNo++;while(((*tp)!='\n')&&((*tp)!=NUL))tp++;if ((*tp)!=NUL){*tp=NUL;tp++;}
 
#ifdef PROTO
static void CleanUp(char*);
#else
static void CleanUp();
#endif

static PT *PArray = nil;
static EDG *EArray = nil;
static TR *TArray = nil;
static BOUNDARY *BArray = nil;
static int ptdim, edgdim, trdim, bounddim;
static TRIANGULATION *rdTriang = nil;
static char *text = nil;
static int countP, countE, countT;
 
int RdTri(cmd)
  COMMAND *cmd;
  {
    double x,y;
    int rc, i, k, k1, k2, k3, length,
	    lineNo = 0, class, partner;
    char ch, *line, *tp;
	PT *p;
	EDG *ed;
	TR *t;

	if (ParsCheck(cmd,1,1)) return false;

	if (!ZIBReadFile((cmd->pars)[1],&text))
	  {
	    sprintf(globBuf, "ReadTri: could not open file '%s'\n", (cmd->pars)[1]);
		ZIBStdOut(globBuf);
		return false;
	  }
    tp = text;

	GETLINE();
    rdTriang = CrTri(line);
    if (rdTriang==nil)
      { CleanUp((cmd->pars)[1]); return false; }

    GETLINE();
    rc = sscanf(line,"Dimension:(%d,%d,%d,%d)",&ptdim,&edgdim,
                &trdim,&bounddim);
    if (rc==0)
      {
        sprintf(globBuf, "ReadTri: missing dimension, read: '%10.10s'...\n", line);
		ZIBStdOut(globBuf);
        CleanUp((cmd->pars)[1]);
        return false;
      }
    PArray = (PT*) ZIBAlloc((long)(ptdim*(sizeof(PT))));
    if (PArray==nil) { CleanUp((cmd->pars)[1]); return false; }
    EArray = (EDG*)ZIBAlloc((long)(edgdim*(sizeof(EDG))));
    if (EArray==nil) { CleanUp((cmd->pars)[1]); return false; }
    TArray = (TR*) ZIBAlloc((long)(trdim*(sizeof(TR))));
    if (TArray==nil) { CleanUp((cmd->pars)[1]); return false; }
    if (bounddim!=0)
      {
        BArray = (BOUNDARY*) ZIBAlloc((long)bounddim*sizeof(BOUNDARY));
        if (BArray==nil) { CleanUp((cmd->pars)[1]); return false; }
      }

    countP = 0; countE = 0; countT = 0;
	while (true)
      {
        GETLINE();
        rc = sscanf(line, "%d:(%le,%le),%c%s", &i, &x, &y,
		  			  &ch, globBuf);
        if (rc==0) break;
		p = &PArray[i];
        p->x = x;
        p->y = y;
        p->indexP = countP;
		p->level = 0;
		p->class = 0;
		p->mark = false;
        p->boundP = ((ch=='D')||(ch=='d'))?DIRICHLET:
                                    (((ch=='I')||(ch=='i'))?INTERIOR:
                                    (((ch=='N')||(ch=='n'))?NEUMANN:CAUCHY));

		p->next = &PArray[i+1];
		p->last = &PArray[i-1];
		p->maxNeighbors = 0;
		p->neighbors = nil;
		p->vec = (REAL*)GetElem(PTVEC);
		if ((rc==5)&&((*globBuf)!=NUL))
		  {
 		   	if (('0'<=*globBuf)&&(*globBuf<='9'))
			  {
			    rc = sscanf(globBuf,"%d,%le", &(p->class), &x);
				rc--;
			  }
			else rc = sscanf(globBuf, ",%le", &x);
			RA(p, R_SOL) = (rc==1)?x:ONE;
		  }
		else RA(p,R_SOL) = ONE;
		RA(p,R_RHS) = ZERO;
        countP++;
      }
    if (strncmp(line,"END",3)!=0)
      { 
	    sprintf(globBuf, "ReadTri: syntax error reading points (line %d)\n", lineNo);
		ZIBStdOut(globBuf);
		CleanUp((cmd->pars)[1]);
		return false;
	  }
    rdTriang->noOfPoints=countP;
	rdTriang->firstPoint = &PArray[0];
	PArray[0].last = nil;
	rdTriang->lastPoint = &PArray[ptdim-1];
	PArray[ptdim-1].next = nil;
 
	for (i=0; i<edgdim; i++)
	  {
		ed = &EArray[i];
		ed->pm = nil;
   		ed->t1 = nil;
		ed->t2 = nil;
	    ed->MidPoint = StdMidPoint;
		ed->bound = nil;
		ed->level = 0;
		ed->class = 0;
		ed->next = &EArray[i+1];
		ed->last = &EArray[i-1];
		ed->father = nil;
		ed->firstSon = nil;
		ed->type = T_WHITE;
		ed->mark = 0;
		ed->vec = (REAL*)GetElem(EDGVEC);
		RA(ed, R_SOL) = ZERO;
		RA(ed, R_RES) = -ONE;
	  }
	while (true)
      {
        GETLINE();
        rc = sscanf(line,"%d:(%d,%d),%c%s",
                   &i,&k1,&k2,&ch,globBuf);
        if (rc==0) break;
        if ((k1>=ptdim)||(k2>=ptdim))
          {
            sprintf(globBuf, "ReadTri: bound check error reading edge (line %d)\n", lineNo);
			ZIBStdOut(globBuf);
            CleanUp((cmd->pars)[1]);
            return false;
          }
        countE++;
		ed = &EArray[i];
        ed->p1 = &PArray[k1];
        ed->p2 = &PArray[k2];
        ed->boundP = ((ch=='D')||(ch=='d'))?DIRICHLET:
                                   (((ch=='I')||(ch=='i'))?INTERIOR:
                                   (((ch=='N')||(ch=='n'))?NEUMANN:CAUCHY));
		if ((rc==5)&&((*globBuf)!=NUL))
		  {
		    rc = sscanf(globBuf,"%d,%c%d", &class, &ch, &partner);
			if (rc==0)
			  {	rc = sscanf(globBuf,",%c%d", &ch, &partner);
			    if (rc==0)
				  {
			        sprintf(globBuf, "Not a number after boundary type (line %d)\n",
						    lineNo);
					ZIBStdOut(globBuf);
			      }
			  }
			else ed->class = class;
			if (rc>1)
			  {
			    if ((ch=='S')||(ch=='s'))
					ed->firstSon = &EArray[partner];
				else if ((ch=='F')||(ch=='f'))
				  {
				    EArray[i+1].father = ed->father = &EArray[partner];
					EArray[partner].pm =  &PArray[k2];
				  }
				else
				  {
				    sprintf(globBuf,"Unknown Character '%c' (line %d)\n",
				               ch, lineNo);
					ZIBStdOut(globBuf);
			      }
			  }
		  }
      }
    if (strncmp(line,"END",3)!=0)
      { 
	    sprintf(globBuf, "ReadTri: syntax error reading edges (line %d)\n", lineNo);
		ZIBStdOut(globBuf);
		CleanUp((cmd->pars)[1]);
		return false;
	  }
    rdTriang->noOfEdges=countE;
	rdTriang->firstEdge = &EArray[0];
	EArray[0].last = nil;
	rdTriang->lastEdge = &EArray[edgdim-1];
	EArray[edgdim-1].next = nil;
 
    while (true)
      {
        GETLINE();
        rc = sscanf(line,"%d:(%d,%d,%d)%s",&i,&k1,&k2,&k3,globBuf);
        if (rc==0) break;
        if ((k1>=edgdim)||(k2>=edgdim)||(k2>=edgdim))
          {
            sprintf(globBuf, "ReadTri: bound check error reading triangle (line %d)\n", lineNo);
			ZIBStdOut(globBuf);
            CleanUp((cmd->pars)[1]);
            return false;
          }
        countT++;
		t = &TArray[i];
        t->e1 = &EArray[k1];
        t->e2 = &EArray[k2];
        t->e3 = &EArray[k3];
		t->user = nil;
		t->next = &TArray[i+1];
		t->last = &TArray[i-1];
		t->father = nil;
		t->partner = nil;
		t->firstSon = nil;
		t->mark = false;
		t->type = T_WHITE;
		t->level = 0;
		t->depth = 0;
		t->class = 0;
		t->vec = (REAL*)GetElem(TRVEC);
        SetTP(t,(TR*)nil);
		SetTE(t);
		if ((rc==5)&&((*globBuf)!=NUL))
		  {
		    rc = sscanf(globBuf,",%d,%d", &class, &partner);
			if (rc==0)
			  {
			    sprintf(globBuf,"Not a number after triangle type (line %d)\n",
						  lineNo);
				ZIBStdOut(globBuf);
			  }
			else t->class = class;
			if (rc>1)
			  {
				if ((partner>=0)&&(partner<trdim))
				  t->partner = &TArray[partner];
				else
	              {
		      		sprintf(globBuf, "ReadTri: bound check error reading triangle (line %d)\n", lineNo);
					ZIBStdOut(globBuf);
		     		CleanUp((cmd->pars)[1]);
		    		return false;
		     	  }
			  }
		  }
      }
    if (strncmp(line,"END",3)!=0)
      { 
	    sprintf(globBuf, "ReadTri: syntax error reading triangles (line %d)\n", lineNo);
		ZIBStdOut(globBuf);
		CleanUp((cmd->pars)[1]);
		return false;
	  }
    rdTriang->noOfTriangles=countT;
	rdTriang->firstTriangle = &TArray[0];
	TArray[0].last = nil;
	rdTriang->lastTriangle = &TArray[trdim-1];
	TArray[trdim-1].next = nil;
 
    if (bounddim!=0)
      {
        for (k = 0;k<bounddim;k++)
          {
            GETLINE();
            rc = sscanf(line,"(%le,%le):%d\n",&x,&y,&k1);
            BArray[k].x = x;
            BArray[k].y = y;
            if (rc==0) break;
            for (i = 0;i<k1;i++)
              {
                GETLINE();
                rc = sscanf(line,"%d",&k2);
                EArray[k2].bound = &BArray[k];
                EArray[k2].MidPoint = ArcMidPoint;
              }
    	  }
		GETLINE();
	    if (strncmp(line,"END",3)!=0)
	      { 
		    sprintf(globBuf, "ReadTri: syntax error reading bounds (line %d)\n", lineNo);
			ZIBStdOut(globBuf);
			CleanUp((cmd->pars)[1]);
			return false;
		  }
      }
    if ((cmd->pars)[1]!=nil)
      {
        length  =strlen((cmd->pars)[1]);
        rdTriang->fileName = (char*)ZIBAlloc((long)(length+1));
        if ((rdTriang->fileName)!=nil)
          strcpy(rdTriang->fileName,(cmd->pars)[1]);
      }

    ApplyT(MkGreen,all);
	CleanUp((cmd->pars)[1]);
	
    return true;
  }
 
static void CleanUp(fname)
  char *fname;
  {
    ZIBFree((PTR)text);
	if (countP!=ptdim)
	  {
		ZIBStdOut("ReadTri: not enough points\n");
		if (PArray!=nil) ZIBFree((PTR)PArray);
		return;
      }
	if (countE!=edgdim)
	  {
		ZIBStdOut("ReadTri: not enough edges\n");
		if (EArray!=nil) ZIBFree((PTR)EArray);
		return;
      }
	if (countT!=trdim)
	  {
		ZIBStdOut("ReadTri: not enough triangles\n");
		if (TArray!=nil) ZIBFree((PTR)TArray);
		return;
      }
    sprintf(globBuf, "ReadTri: %d points, %d edges, %d triangles read from %s\n",
			countP, countE, countT, (fname==nil)?"input":fname);
	ZIBStdOut(globBuf);
	rdTriang->noOfInitPoints = ptdim;
	rdTriang->initPoints = PArray;
	rdTriang->noOfInitEdges = edgdim;
	rdTriang->initEdges = EArray;
	rdTriang->noOfInitTriangles = trdim;
	rdTriang->initTriangles = TArray;
    return;
  }

/*
   ---------------- Write Triangulation -----------------
*/

static int counter;
static FILE *outFile = stdout;

static int CountPt(p)
  PT *p;
  {
    counter++;
	return true;
  }

static int CountEdg(ed)
  EDG *ed;
  {
    counter++;
	return true;
  }

static int CountTr(t)
  TR *t;
  {
    counter++;
	return true;
  }

static int WritePt(p)
  PT *p;
  {
	p->counterP = counter;

    fprintf(outFile, "%d:(%e,%e),%c%d,%e\n",
			p->counterP, p->x, p->y,
			((p->boundP)==INTERIOR)?'I':
                         (((p->boundP)==DIRICHLET)?'D':
                         (((p->boundP)==NEUMANN)?'D':'C')),
			p->class,
			RA(p, R_SOL));
    counter++;
	return true;
  }

static int WriteEdg(ed)
  EDG *ed;
  {
    ed->counter = counter;
	fprintf(outFile, "%d:(%d,%d),%c%d\n",
			counter, (ed->p1)->counterP, (ed->p2)->counterP,
			((ed->boundP)==INTERIOR)?'I':
                         (((ed->boundP)==DIRICHLET)?'D':
                         (((ed->boundP)==NEUMANN)?'D':'C')),
			 ed->class);
	counter++;
	return true;
  }

static int WriteTr(t)
  TR *t;
  {
	fprintf(outFile, "%d:(%d,%d,%d),%d\n",
			counter, (t->e1)->counter, (t->e2)->counter,
			(t->e3)->counter, t->class);
	counter++;
	return true;
  }

int WrTri(cmd)
  COMMAND *cmd;
  {
	int noOfLines = 2, lev, dep, index, rc;
	int noOfPts, noOfEdgs, noOfTrs;
	char *tp;

	if (ParsCheck(cmd,2,3)) return false;

	if (actTriang==nil)
	  { ZIBStdOut("WriteTri: no triangulation to write\n"); return false; }
	lev = actTriang->refLevel;
	dep = actTriang->maxDepth;

	outFile = fopen((cmd->pars)[1], "w");
	if (outFile==nil)
	  {
	    sprintf(globBuf, "WriteTri: could not open file '%s'\n", (cmd->pars)[1]);
		ZIBStdOut(globBuf);
		return false;
	  }

	tp = (cmd->pars)[2];
	index = CheckName(&tp, cmd->names, nameClass);
	switch (index)
	  {
	  case -1:  
	    sprintf(globBuf, "WriteTri: unknown parameter '%s'\n", (cmd->pars)[2]);
		ZIBStdOut(globBuf);
		fclose(outFile);
		return false;
	  case  0:
	    if ((cmd->noOfPars)==2) lev = 0;
	    else
	      {
	        rc = sscanf((cmd->pars)[3], "%d", &lev);
		    if (rc!=1)
		      {
			    sprintf(globBuf, "WriteTri: '%s' not a level number\n",
						(cmd->pars)[2]);
				ZIBStdOut(globBuf);
				fclose(outFile);
				return false;
			  }
		    if ((lev>(actTriang->refLevel))||(lev<0))
		      {
			    sprintf(globBuf, "WriteTri: level %d does not exist\n", lev);
				ZIBStdOut(globBuf);
				fclose(outFile);
				return false;
			  }
	      }

	    counter = 0;
	    ApplyPLevel(CountPt, lev);
	    noOfPts = counter;
	    counter = 0;
	    ApplyELevel(CountEdg, lev);
	    noOfEdgs = counter;
	    counter = 0;
	    ApplyTLevel(CountTr, lev);
	    noOfTrs = counter;

	    fprintf(outFile, "%s\n", actTriang->name);
	    fprintf(outFile, "Dimension:(%d,%d,%d,%d)\n", noOfPts, noOfEdgs, noOfTrs, 0);

	    counter = 0;
	    ApplyPLevel(WritePt, lev);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfPts+1;

	    counter = 0;
	    ApplyELevel(WriteEdg, lev);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfEdgs+1;

	    counter = 0;
	    ApplyTLevel(WriteTr, lev);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfTrs+1;

	    fclose(outFile);
	    sprintf(globBuf, "WriteTri: %d lines written to '%s' for level %d\n",
				noOfLines, (cmd->pars)[1], lev);
		ZIBStdOut(globBuf);
	    break;
	  case  1:
	    if ((cmd->noOfPars)==2) dep = 0;
	    else
	      {
	        rc = sscanf((cmd->pars)[3], "%d", &dep);
		    if (rc!=1)
		      {
			    sprintf(globBuf, "WriteTri: '%s' not a depth number\n",
						(cmd->pars)[2]);
				ZIBStdOut(globBuf);
				fclose(outFile);
				return false;
			  }
		    if ((dep>(actTriang->maxDepth))||(dep<0))
		      {
			    sprintf(globBuf, "WriteTri: level %d does not exist\n", lev);
				ZIBStdOut(globBuf);
				fclose(outFile);
				return false;
			  }
	      }

	    counter = 0;
	    ApplyPDepth(CountPt, dep, TRIANGUL, all);
	    noOfPts = counter;
	    counter = 0;
	    ApplyEDepth(CountEdg, dep, TRIANGUL, all);
	    noOfEdgs = counter;
	    counter = 0;
	    ApplyTDepth(CountTr, dep, TRIANGUL, all);
	    noOfTrs = counter;

	    fprintf(outFile, "%s\n", actTriang->name);
	    fprintf(outFile, "Dimension:(%d,%d,%d,%d)\n", noOfPts, noOfEdgs, noOfTrs, 0);

	    counter = 0;
	    ApplyPDepth(WritePt, dep, TRIANGUL, all);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfPts+1;

	    counter = 0;
	    ApplyEDepth(WriteEdg, dep, TRIANGUL, all);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfEdgs+1;

	    counter = 0;
	    ApplyTDepth(WriteTr, dep, TRIANGUL, all);
	    fprintf(outFile, "END\n");
	    noOfLines += noOfTrs+1;

	    fclose(outFile);
	    sprintf(globBuf, "WriteTri: %d lines written to '%s' for depth %d\n",
				noOfLines, (cmd->pars)[1], lev);
		ZIBStdOut(globBuf);

	    break;
	  }
	return true;
  }
