/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <stdio.h>
#include <math.h>

#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

static int precond, allIt, verboseP;
static REAL eps, delta0, delta1, tau, beta;
static PROC      AXMul;
static VOIDPROC  PCXMul;
 
int CGFirst(iaxMul, ieps, res, iprecond, ipcxMul, iverboseP)
  REAL ieps, *res;
  PROC     iaxMul;
  VOIDPROC ipcxMul;
  int iprecond, iverboseP;
  {
	int countU = -1;
 
    eps = ieps;
    precond = iprecond;
	verboseP = iverboseP;
    AXMul = iaxMul;
    PCXMul = ipcxMul;

    areaKnown = false;

    countU = assign(R_CGG,R_RHS);

	if (verboseP)
	  {
		sprintf(globBuf, "Solve: start of CG, n=%d, eps=%9.3e(%9.3e)%s\n",
				countU, ieps, sqrt(ieps), (actSolve->preCondName) );
    	ZIBStdOut(globBuf);
	  }


    if ((*AXMul)(R_SOL, R_CGD)==false) return false;


    sub(R_CGG, R_CGD, R_CGG);


    if (precond) (*PCXMul)(R_CGG, R_CGH);
	else { assign(R_CGH,R_CGG); SetBoundZero(R_CGH); }

    assneg(R_CGD, R_CGH);

    delta0 = scalprod(R_CGG, R_CGH);
    *res = delta0;
    allIt = 1;
    return true;
  }
 
int CGStep(maxit, res, eps)
  int *maxit;
  REAL *res, eps;
  {
    int it = -1;
 
    while ((it++)<*maxit)
      {
		areaKnown = true;

        (*AXMul)(R_CGD, R_CGH);

        tau = delta0/scalprod(R_CGD, R_CGH);
        lin(R_SOL, R_SOL, R_CGD, tau);
        lin(R_CGG, R_CGG, R_CGH, tau);

        if (precond) (*PCXMul)(R_CGG, R_CGH);
		else { assign(R_CGH,R_CGG); SetBoundZero(R_CGH); }

        delta1 = scalprod(R_CGG, R_CGH);
        beta = delta1/delta0;
        delta0 = delta1;
        linneg(R_CGD, R_CGH, R_CGD, beta);

        allIt++;
		if (verboseP)
		  {
 			sprintf(globBuf, "Solve: CG step %d: delta=%9.3e(%9.3e)\n",
					allIt, delta0, sqrt(delta0));
  			ZIBStdOut(globBuf);
		  }
        if (delta1<=eps) 	break;   
      }

    *maxit = allIt;
    *res = delta1;
    return true;
  }

static PrValuesP(p)
  PT *p;
  {
	int ind = p->indexP;

	sprintf(globBuf,"       %3d: %11.3e %11.3e %11.3e %11.3e %11.3e %11.3e %11.3e",
			ind, RA(p,R_SOL), RA(p,R_RHS), RA(p,R_DIAG),
			RA(p,R_CGG), RA(p,R_CGD), RA(p,R_CGH), RA(p,R_AREA));
	ZIBStdOut(globBuf);
	return true;
  }

static PrValuesE(ed)
  EDG *ed;
  {
	int ind1 = (ed->p1)->indexP, ind2 = (ed->p2)->indexP;

	if ((ed->vec)==nil) return true;
	sprintf(globBuf,"       (%3d-%3d): %11.3e %11.3e %11.3e %11.3e %11.3e %11.3e",
			ind1,ind2,RA(ed,R_SOL),RA(ed,R_RHS),RA(ed,R_RQ),
			RA(ed,R_DIAG),RA(ed,R_RES), RA(ed,R_CGH));
	ZIBStdOut(globBuf);
	return true;
  }

PrintValues(withEdges)
  int withEdges;
  {
	ZIBStdOut("Solve: Point  R_SOL       R_RHS       R_DIAG      R_CGG       R_CGD       R_CGH\n");
	ApplyP(PrValuesP,all);
	if (withEdges)
	  {
		ZIBStdOut("Solve:     Edge     R_SOL       R_RHS       R_RQ        R_DIAG      R_RES\n");
		ApplyE(PrValuesE,nodal);
	  }
	return;
  }


static PrColumnP(p)
  PT *p;
  {
	int ind = p->indexP;

	sprintf(globBuf,"       %3d: %11.3e ",ind, RA(p,R_CGH));
	ZIBStdOut(globBuf);
	return true;
  }

static PrColumnE(ed)
  EDG *ed;
  {
	int ind1 = (ed->p1)->indexP, ind2 = (ed->p2)->indexP;

	if ((ed->vec)==nil) return true;
	sprintf(globBuf,"       (%3d-%3d): %11.3e ",ind1,ind2, RA(ed,R_CGH));
	ZIBStdOut(globBuf);
	return true;
  }

PrintColumn(withEdges)
  int withEdges;
  {
	ZIBStdOut("Solve: Point  R_CGH\n");
	ApplyP(PrColumnP,all);
	if (withEdges)
	  {
		ZIBStdOut("Solve:     Edge     R_CGH\n");
		ApplyE(PrColumnE,nodal);
	  }
	return;
  }


int assignI(a,column)
  int a, column;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;
	int count = 0;
printf("ifrom,ito,column,count %d %d %d %d \n",iFrom,iTo,column,count);
    if (iFrom==0)
	  while (p!=nil) 
		{ 
		if(count == column)	
			RA(p,a) = ONE; else RA(p,a) = ZERO;
		count++; p = p->next;
		}
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) 
			{
			if(count == column)	
			RA(ed,a) = ONE; else RA(ed,a) = ZERO;
			count++;
			}
		  ed = ed->next;
	    }
    return count;
  }

PrintMatrix()
	{
	int column;

	for (column=0; column< 13; column++)
		{
		assignI(R_CGD,column);
		axMul(R_CGD,R_CGH,false);
		PrintColumn(true);
		}
		return;
  }
