/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <math.h>
#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

static int     depth, maxDepth, BY, index, status, toAppl;
static PROC Rout;

static int     UpX(), InPolX(), Pre();

int	       areaKnown, refLevel=-1;

/* ***************************************************************
   ApplyTDepth      Apply a routine to triangles of a depth
   -----------
   PROC Routine    Routine to apply
   int dep         depth of triangulation
   int stat        status : EXACT = false or TRIANGUL = true
   int to          selection, see "kasktri.h"
   return int      true or false
*************************************************************** */

static int InDepth(t)
  TR *t;
  {
	if ((t->depth)>depth) return false;
        if ((t->depth)==depth) return true;
	if ((t->firstSon)==nil) return status;

        return false;
  }

static int ApplyTDepRec(Routine, t)
  PROC Routine;
  TR  *t;
  {
    TR *tt;
	int flag = false;

	switch (toAppl)
        {
        case all :
		flag = true;
		break;
	case allReds :
		if ((t->type) == T_RED)
			flag = true;
		break;
	case sonsOfRed :
		if ((t->father) != nil) 
			if (((t->father)->type) == T_RED)
				flag = true;
		break;
	}
	if (InDepth(t) && flag)
	  {
		return (*Routine)(t);
	  }
        if ((t->firstSon)==nil) return true;
	tt = TRED1SON(t);
	if (!ApplyTDepRec(Routine, tt)) return false;
	tt = TRED2SON(t);
	if (!ApplyTDepRec(Routine, tt)) return false;
	if ((t->type)!=T_RED) return true;
	tt = TRED3SON(t);
	if (!ApplyTDepRec(Routine, tt)) return false;
	tt = TRED4SON(t);
	return ApplyTDepRec(Routine, tt);
  }




int ApplyTDepth(Routine, dep, stat, to)
  PROC Routine;
  int dep, stat, to;
  {
    TR *t = actTriang->initTriangles;
    int rc, k;

    depth = dep;
    status = stat;
    toAppl = to;
	for (k = 0; k<(actTriang->noOfInitTriangles); k++) 
      {
        rc = ApplyTDepRec(Routine, &t[k]);
        if (!rc) return rc;
      }
    return true;
  }

/* ***************************************************************
   MarkPoints     Marks points of a triangle
   ----------
   TR *tr         triangle to be marked
   return int     always true
*************************************************************** */

static int MarkPoints(tr)
  TR *tr;
  {
     (tr->p1)->mark = true;
     (tr->p2)->mark = true;
     (tr->p3)->mark = true;

     return true;
  }

/* *************************************************************************
   ApplyToMarkedPoints    Apply a routine to the marked points of a triangle
   -------------------
   TR *tr                 triangle under consideration
   return int             true or false
************************************************************************* */

static int ApplyToMarkedPoints(tr)
  TR   *tr;
  {
    PT *p;
    int rc;

    p = tr->p1;
    if (p->mark)
       {
          p->mark = false;
	  rc = (*Rout)(p);
	  if (rc==false) return rc;
       }

    p = tr->p2;
    if (p->mark)
       {
          p->mark = false;
	  rc = (*Rout)(p);
	  if (rc==false) return rc;
       }

    p = tr->p3;
    if (p->mark)
       {
          p->mark = false;
	  rc = (*Rout)(p);
	  if (rc==false) return rc;
       }

     return true;
  }


/* ***************************************************************
   ApplyPDepth     Apply a routine to points of a depth
   -----------
   PROC Routine    Routine to apply
   int dep         depth of triangulation
   int stat        status : EXACT = false or TRIANGUL = true
   int to          selection, see "kasktri.h"
   return int      true or false
*************************************************************** */

int ApplyPDepth(Routine, dep, stat, to)
  PROC Routine;
  int dep, stat, to;
  {
    int rc;
 
    ApplyTDepth(MarkPoints, dep, stat, to);
    Rout = Routine;
    rc = ApplyTDepth(ApplyToMarkedPoints, dep, stat, to);

    return rc;
  }

/* ***************************************************************
   MarkEdges      Marks edges of a triangle
   ---------
   TR *tr         triangle to be marked
   return int     always true
*************************************************************** */

static int MarkEdges(tr)
  TR *tr;
  {
     (tr->e1)->mark = true;
     (tr->e2)->mark = true;
     (tr->e3)->mark = true;

     return true;
  }

/* *************************************************************************
   ApplyToMarkedEdges      Apply a routine to the marked edges of a triangle
   ------------------
   TR *tr                  triangle under consideration
   return int              true or false
************************************************************************* */

static int ApplyToMarkedEdges(tr)
  TR   *tr;
  {
    EDG *ed;
    int rc;

    ed = tr->e1;
    if (ed->mark)
       {
          ed->mark = false;
	  rc = (*Rout)(ed);
	  if (rc==false) return rc;
       }

    ed = tr->e2;
    if (ed->mark)
       {
          ed->mark = false;
	  rc = (*Rout)(ed);
	  if (rc==false) return rc;
       }
    ed = tr->e3;

    if (ed->mark)
       {
          ed->mark = false;
	  rc = (*Rout)(ed);
	  if (rc==false) return rc;
       }

     return true;
  }


/* ***************************************************************
   ApplyEDepth     Apply a routine to edges of a depth
   -----------
   PROC Routine    Routine to apply
   int dep         dep of triangulation
   int stat        status : EXACT = false or TRIANGUL = true
   int to          selection, see "kasktri.h"
   return int      true or false
*************************************************************** */

int ApplyEDepth(Routine, dep, stat, to)
  PROC Routine;
  int dep, stat, to;
  {
    int rc;
    ApplyTDepth(MarkEdges, dep, stat, to);
    Rout = Routine;
    rc = ApplyTDepth(ApplyToMarkedEdges, dep, stat, to);

    return rc;
  }

static int AddAreaP(tr)
	TR             *tr;
{
	REAL            area;
	PT             *p1 = tr->p1, *p2 = tr->p2, *p3 = tr->p3;

	area  = (p1->x) * ((p2->y) - (p3->y));
	area += (p2->x) * ((p3->y) - (p1->y));
	area += (p3->x) * ((p1->y) - (p2->y));
	area *= HALF;

	RA(p1, R_AREA) += area;
	RA(p2, R_AREA) += area;
	RA(p3, R_AREA) += area;

	return true;
}

static void UpdateX(x, depth)
	int  x, depth;
{
    index = x;
	ApplyEDepth(UpX, depth, EXACT, allReds);

	return;
}

static int UpX(ed)
	EDG   *ed;
{
	REAL  val = RA(PM(ed), index);

	RA(ed, index) = val;
	RA(ed, index+2) = RA((ed->p1), index);
	RA(ed, index+4) = RA((ed->p2), index);
	RA((ed->p1), index) += val * HALF;
	RA((ed->p2), index) += val * HALF;

	return true;
}

static void InterpolateX(x, depth)
	int             x, depth;
{
        index = x;
	ApplyEDepth(InPolX, depth, EXACT, allReds);

	return;
}

static int InPolX(ed)
	EDG            *ed;
{

	RA(PM(ed), index) = HALF * (RA((ed->p1), index) + RA((ed->p2), index));

	return true;
}

static int qVal(ed)
	EDG             *ed;
{
	PT		*p1 = ed->p1;
	REAL	xm, ym, *fVals= (actProblem->fVals);
	if ( (ed->level) > refLevel )
		{
 		 /* 
		Hier wird als (xm,ym) ein Endpunkt der Kante genommen,
		alternativ ist auch der Mittelpunkt sinnvoll.
 		 */ 
		xm = p1->x;
		ym = p1->y;
		(actProblem->F)(xm,ym,ed->class,fVals);
		RA(ed,R_BPX) = fVals[2];	
		}
	return true;
}


static void AddPre(depth)
	int		depth;
{
	ApplyTDepth(MarkPoints, depth, EXACT, allReds);
	ApplyEDepth(Pre, depth, EXACT, allReds);

	return;
}



static int Pre(ed)
	EDG             *ed;
{
	PT		*p1 = ed->p1, *p2 = ed->p2;
	int		k, j;
	REAL	factor, tau, q;

	k = depth + 1;
	j = maxDepth;

/*	q = RA(ed,R_BPX);	*/
	tau = 1.0;
 /*	if ( fabs(q) >= 1.e-8) tau /= q;	*/ 
	factor = tau * pow(4.0, (double) (j));
	factor /= 1.0 + tau*tau * pow(4.0, (double) (j+k));
	factor += 1.0 / (1.0 + tau * pow(4.0, (double) (j)));

/*	factor *= 0.5;   */
 	factor *= 0.3;    

	RA(PM(ed), BY) += factor * RA(ed, R_RS) / RA(ed, R_AREA);

	if ((p1->mark)) {
		p1->mark = false;
		RA(p1, BY) += factor * RA(ed, R_RS1) / RA(ed, R_AREA1);
	}
	if ((p2->mark)) {
		p2->mark = false;
		RA(p2, BY) += factor * RA(ed, R_RS2) / RA(ed, R_AREA2);
	}
	return true;
}

void bpxPcxMul(x, y)
	int             x, y;
{  int depth;

	BY = y;
	assign(R_RS,x);
	if (!areaKnown)
		{
        SetZeroField(R_AREA);
		ApplyT(AddAreaP, all);
		}
	maxDepth = actTriang->maxDepth;
	for (depth = maxDepth; depth > 0; depth--) 
		{
		UpdateX(R_RS, depth - 1);
		if(!areaKnown) 
			UpdateX(R_AREA, depth - 1);
		}
	SetBoundZero(R_RS);
	Lev0DirectSol(R_RS, BY);


/*	if ( refLevel < (actTriang->refLevel) )
		{
		ApplyE(qVal, all);
		refLevel = actTriang->refLevel;
		}
*/
	for (depth = 0; depth < maxDepth; depth++) {
		InterpolateX(BY, depth);
		AddPre(depth);
	}
	SetBoundZero(BY);

	return;
}

