/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

#define EDG_MAX 6

static int AX,AY,BX;
static REAL *vecX;

static int SetB(p)
  PT *p;
  {
    REAL *dirVals=actProblem->dirVals;
    (actProblem->DirichF)(p->x,p->y,p->class,dirVals);
    RA(p,BX) = dirVals[0];
    return true;
  }
static int SetBE(ed)
  EDG *ed;
  {
	PT *P1 = ed->p1, *P2 = ed->p2;
	REAL x, y;
	REAL *dirVals=actProblem->dirVals;

	x = (P1->x)+((P2->x)-(P1->x))*HALF;
	y = (P1->y)+((P2->y)-(P1->y))*HALF;
	(actProblem->DirichF)(x,y,ed->class,dirVals);
 	RA(ed,BX) = dirVals[0];	  
    return true;
  }
void SetBound(x)
  int x;
  {
    BX = x;
    ApplyP(SetB,dirichlet);
	if (iTo==6) ApplyE(SetBE,dirichlet);
	return;
  }

static int SetZero(p)
  PT *p;
  {
    RA(p,BX) = ZERO;
    return true;
  }

static int SetZeroE(ed)
  EDG *ed;
  {
    RA(ed,BX) = ZERO;
    return true;
  }

void SetBoundZero(x)
  int x;
  {
    BX = x;
    ApplyP(SetZero,dirichlet);
	if (iTo==6) ApplyE(SetZeroE,dirichlet);
	return;
  }

static int AddElem(t)
  TR *t;
  {
    int i, k;
	PT **pts = &(t->p1);
	REAL hilfe;

    if ((actProblem->NumAss)(t)==false) return false;
    for(i = iFrom; i < iTo; i++)
	  {
		if ( ((pts[i]->boundP)!=DIRICHLET) || (actSolve->compNormP))
    	  for(k = kFrom; k < kTo; k++)
		    {
    		  if (i>k)
        	   	 {
				hilfe = assA[i][k]*RA(pts[k],AX);
				RA(pts[i],AY) += hilfe;
		  		  }
		 	 else
		  		{
		    	hilfe = assA[k][i]*RA(pts[k],AX);
				RA(pts[i],AY) += hilfe;
			    }
		    }
	    else {
				RA(pts[i],AY) = RA(pts[i],AX);
			 }
		RA(pts[i],R_DIAG) += assA[i][i];

	  }
    return true;
  }
 
int axMul(x, y)
  int x, y;
  {
	partP = P_STIFF;
    SetZeroField(y);
    SetZeroField(R_DIAG);
    AX = x; AY=y;
    if (ApplyT(AddElem,all)==false) return false;
    return true;
  }

static int divD(p)
  PT *p;
  {
	RA(p,AX) = RA(p,AX)/RA(p,AY);
	return true;
  }

static int storeElem(p)
  PT *p;
  {
	RA(p,BX) = vecX[p->indexP];
	return true;
  }

static int fetchElem(p)
  PT *p;
  {
	vecX[p->indexP] = RA(p,BX);
	return true;
  }


int MulD(x,y)
  int x, y;
  {
	vecX = (REAL*)(actSolve->rhs);
	BX = x;
	ApplyP(fetchElem,direct);
	CholSol((REAL**)(actSolve->decomp),
			(REAL*)(actSolve->diagonal),
			(REAL*)(actSolve->rhs),
			(REAL*)(actSolve->solution),
			actSolve->dirDim);
	vecX = (REAL*)(actSolve->solution);
	ApplyP(storeElem,direct);
	AX = x; AY = y;
	ApplyP(divD,nonDirect);
	return true;
  }

static int sxE(ed)
  EDG *ed;
  {
    PT *pm = ed->pm;
	REAL hilfe;
  
    if (pm==nil)
	  if (iTo==6)
	    {
    	  hilfe = (RA(ed->p1,BX)+RA(ed->p2,BX))*0.5;
		  RA(ed,BX) += hilfe;
		  return true;
		}
	  else return true;
    hilfe = (RA(ed->p1,BX)+RA(ed->p2,BX))*0.5;
	RA(pm,BX) += hilfe;
    return true;
  }

static int stxE(ed)
  EDG *ed;
  {
    REAL xim;
    PT *pm = ed->pm;
  
	if (pm==nil)
	  if (iTo==6)
	    {
    	  xim = RA(ed,BX)*0.5;
    	  RA(ed->p1,BX) += xim; RA(ed->p2,BX) += xim;
		  return true;
		}
	  else return true;
    xim = RA(pm,BX)*0.5;
    RA(ed->p1,BX) += xim; RA(ed->p2,BX) += xim;
    return true;
  }

void pcxMul(x,y)
  int x, y;
  {
	assign(y,x);
    BX = y;
    ApplyE(stxE,allBackward);
	SetBoundZero(y);
	MulD(y,R_DIAG);
    ApplyE(sxE,all);
	SetBoundZero(y);

    return;
  }

static int AssB(t)
  TR *t;
  {
    int i;
	PT **pts = &(t->p1);
 
    if ((actProblem->NumAss)(t)==false) return false;
    for(i = iFrom; i<iTo; i++) RA(pts[i],BX) += assB[i];
    return true;
  }
  
int AssRSide()
  {
	partP = P_RHS;
    BX = R_RHS;
    SetZeroField(R_RHS);
    if (ApplyT(AssB,all)==false) return false;
    SetBound(R_RHS);
    return true;
  }

static int AssBDiag(t)
  TR *t;
  {
    int i;
	PT **pts = &(t->p1);
 
    if ((actProblem->NumAss)(t)==false) return false;
    for(i = iFrom; i<iTo; i++)
	  {
	    RA(pts[i], R_RHS) += assB[i];
		if ((pts[i]->boundP)==DIRICHLET) RA(pts[i], R_DIAG) = ONE; 
		else RA(pts[i], R_DIAG) += assA[i][i];
	  }
    return true;
  }
  
int AssRSideDiag()
  {
	InitNumAss(N_QQ);
	partP = P_ALL;
    SetZeroField(R_RHS);
    SetZeroField(R_DIAG);
    if (ApplyT(AssBDiag,all)==false) return false;
    SetBound(R_RHS);
    return true;
  }
 
/* ************ "utilities" for simple vector operations *********** */

int assign(a,b)
  int a,b;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;
	int count = 0;

    if (iFrom==0)
	  while (p!=nil) { RA(p,a) = RA(p,b); count++; p = p->next; }
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) { RA(ed,a) = RA(ed,b); count++; }
		  ed = ed->next;
	    }
    return count;
  }

void assneg(a,b)
  int a, b;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { RA(p,a) = -RA(p,b); p = p->next; }
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) RA(ed,a) = -RA(ed,b);
		  ed = ed->next;
	    }
    return;
  }
 
void lin(a,b,c,x)
  int a, b, c;
  REAL x;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { RA(p,a) = RA(p,b)+x*RA(p,c); p = p->next; }
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) RA(ed,a) = RA(ed,b)+x*RA(ed,c);
		  ed = ed->next;
	    }
    return;
  }
 
void linneg(a,b,c,x)
  int a, b, c;
  REAL x;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { RA(p,a) = -RA(p,b)+x*RA(p,c); p = p->next; }
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) RA(ed,a) = -RA(ed,b)+x*RA(ed,c);
		  ed = ed->next;
	    }
    return;
  }

void add(a,b,c)
  int a, b, c;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { RA(p,a) = RA(p,b)+RA(p,c); p = p->next; }
	if (iTo==6)
	  while (ed!=nil)
		{
		  if ((ed->firstSon)==nil) RA(ed,a) = RA(ed,b)+RA(ed,c);
		  ed = ed->next;
		}
    return;
  }
 
void sub(a,b,c)
  int a, b, c;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { RA(p,a) = RA(p,b)-RA(p,c); p = p->next; }
	if (iTo==6)
	  while (ed!=nil)
		{
		  if ((ed->firstSon)==nil) RA(ed,a) = RA(ed,b)-RA(ed,c);
		  ed = ed->next;
		}
    return;
  }
 
REAL scalprod(a,b)
  int a, b;
  {
    double sum = ZERO;
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
      while (p!=nil) { sum += RA(p,a)*RA(p,b); p = p->next; }
	if (iTo==6)
      while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) sum += RA(ed,a)*RA(ed,b);
		  ed = ed->next;
	    }
    return sum;
  }

void StoreVecToField(x,index)
  REAL *x;
  int index;
  {
    PT *p = actTriang->firstPoint;

	while (p!=nil) { RA(p,index) = x[p->indexP]; p = p->next; }
	return;
  }

void StoreFieldToVec(index,x)
  REAL *x;
  int index;
  {
    PT *p = actTriang->firstPoint;

	while (p!=nil) { x[p->indexP] = RA(p,index); p = p->next; }
	return;
  }

void SetZeroField(index)
  int index;
  {
    PT *p = actTriang->firstPoint;
	EDG *ed = actTriang->firstEdge;

    if (iFrom==0)
	  while (p!=nil) { RA(p,index) = ZERO; p = p->next; }
	if (iTo==6)
	  while (ed!=nil)
	    {
	      if ((ed->firstSon)==nil) RA(ed,index) = ZERO;
		  ed = ed->next;
	    }
	return;
  }

REAL CompRes(ires, irq, idqq, irhs, tau)
  int ires, irq, idqq, irhs;
  REAL *tau;
  {
    EDG *ed = actTriang->firstEdge;
	PT pm;
	REAL rvec[EDG_MAX];
	int count = 0;
	double sum = ZERO, res, u1, u2, um;

	pm.boundP = DIRICHLET;
	pm.vec = &(rvec[0]);

    while (ed!=nil)
	  {
		if ((ed->firstSon)!=nil) { ed = ed->next; continue; }
		RA(ed, irq) = RA(ed, irhs)-RA(ed, irq);
		if ((ed->boundP)==DIRICHLET)
		  {
			u1 = RA(ed->p1,R_SOL);
			u2 = RA(ed->p2,R_SOL);
			(ed->MidPoint)(ed,&pm);
			um = RD(pm,R_SOL);
			res = um-(u1+u2)*HALF;
			res = RA(ed,idqq)*res*res;
		  }
		else
		  {
			um = RA(ed,irq);
			res = um*um/RA(ed,idqq);
		  }
		RA(ed,ires) = res;
		sum = sum+res; count++;
		ed = ed->next;
	  }
	*tau = sum;
	return sum/count;
  }

REAL CompResExtrapol(ires, irq, idqq, irhs, tau)
  int ires, irq, idqq, irhs;
  REAL *tau;
  {
    EDG *ed = actTriang->firstEdge;
	PT pm;
	REAL rvec[EDG_MAX];
	REAL sum = ZERO, res, fatherRes, u1, u2, um, cutEta = ZERO, newRes;

	pm.boundP = DIRICHLET;
	pm.vec = &(rvec[0]);

    while (ed!=nil)
	  {
		if ((ed->firstSon)!=nil) { ed = ed->next; continue; }
		RA(ed, irq) = RA(ed, irhs)-RA(ed, irq);
		if ((ed->boundP)==DIRICHLET)
		  {
			u1 = RA(ed->p1,R_SOL);
			u2 = RA(ed->p2,R_SOL);
			(ed->MidPoint)(ed,&pm);
			um = RD(pm,R_SOL);
			res = um-(u1+u2)*HALF;
			res = RA(ed,idqq)*res*res;
		  }
		else
		  {
			um = RA(ed,irq);
			res = um*um/RA(ed,idqq);
		  }
		RA(ed,ires) = res;
		if ((ed->father) != nil) {
			fatherRes = RA((ed->father),ires);
			if (fatherRes == ZERO)
				newRes = ZERO;
			else 
				newRes = res*res/fatherRes;
		} else 
			newRes = ZERO;
		if (newRes > res)
			newRes = ZERO;
		if (newRes > cutEta)
			cutEta = newRes;
		sum = sum+res;
		ed = ed->next;
	  }
	*tau = sum;
	return cutEta;
  }

void Lev0DirectSol(x, y)
        int x, y;
  {
	assign(y,x);
	vecX = (REAL*)(actSolve->rhs);
	BX = y;
	ApplyP(fetchElem,direct);
	CholSol((REAL**)(actSolve->decomp),
			(REAL*)(actSolve->diagonal),
			(REAL*)(actSolve->rhs),
			(REAL*)(actSolve->solution),
			actSolve->dirDim);
	vecX = (REAL*)(actSolve->solution);
	ApplyP(storeElem,direct);

	return;
  }
