#include "cell.h"
#include "tissue.h"

extern Tissue* tissue[];
extern Cell* cell[];

void initializeTissue(){
tissue[ 0] = new Tissue( "environment",0);
tissue[ 1] = new Tissue( "observer",8);
tissue[ 2] = new Tissue( "generic",1);
tissue[ 3] = new Tissue( "PaceMaker",2);
tissue[ 4] = new Tissue( "slimeMold",4);
tissue[ 5] = new Tissue( "space",3);
Cell::intervalf = 1.000000;
Cell::height = 102;
Cell::width = 102;
cell[ 0] = new Cell( (Cell*) 0, FALSE);
}

void Cell::endTimeStep()
//  Set all the cell variables to the new values 
{
 _CPLcAMP = _CPLcAMPNext;
}

void Cell::divideCopyVar( Cell* p)
// Copy all the cell variables from p after a division 
{
 _CPLcAMP = p->_CPLcAMP/2;
 _CPLcAMPNext = p->_CPLcAMPNext/2;
 _CPLcAMPchange = p->_CPLcAMPchange;
 _CPLclock = p->_CPLclock;
 _CPLcAMP_dir = p->_CPLcAMP_dir;
 _CPLr_dir = p->_CPLr_dir;
 _CPLRelayPeriod = p->_CPLRelayPeriod;
}

void Cell::saveVar(ofstream& s)
//  Save the user defined variables and biochemicals 
{
s << _CPLcAMP << ' ' <<  _CPLcAMPNext <<'\n';
 s << _CPLcAMPchange <<'\n';
s << _CPLclock <<'\n';
_CPLcAMP_dir.saveState(s);
_CPLr_dir.saveState(s);
s << _CPLRelayPeriod <<'\n';
}

void Cell::recoverVar(ifstream& s)
//  recover the user defined variables and biochemicals 
{
s >> _CPLcAMP >>  _CPLcAMPNext;
s >> _CPLcAMPchange;
s >> _CPLclock;
_CPLcAMP_dir.recoverState(s);
_CPLr_dir.recoverState(s);
s >> _CPLRelayPeriod;
}

void Cell::_CPLdoNothing() {}

void Cell::_CPLunnamedState_a() {
if ((matrix->getLocation( cellNumber) == Point(51,51))) {
 code = &_CPLunnamedState_b;
 tissueType = 3;
stateCounter = 2;
 return;
}
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();
// cpl statements in for loop
if ((currentNeighbor->cell->getTissueType() == 0)) {
code = &_CPLdoNothing;
return;
}
}; // end for each neighbor do

if ((randBetween(1,100) <= 10)) {
 code = &_CPLwaitForSignal;
 tissueType = 4;
stateCounter = 4;
 return;
}
 else {
 code = &_CPLunnamedState_c;
 tissueType = 5;
stateCounter = 3;
 return;
}
}

void Cell::_CPLunnamedState_b() {
_CPLclock -=  1.000000e+00 ;
if ((_CPLclock < 0)) {
_CPLcAMPNext += (1.000000e+00 *(33));
}
if ((_CPLclock + 60 <= 0)) {
_CPLclock = _CPLRelayPeriod - 60 - 12;
}
_CPLcAMPNext += (1.000000e+00 * -(_CPLcAMP - (1)) / 12.0);
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();
// cpl statements in for loop
_CPLcAMPNext += (1.000000e+00 *(currentNeighbor->cell->_CPLcAMP - _CPLcAMP) / 8.0);
}; // end for each neighbor do

}

void Cell::_CPLunnamedState_c() {
_CPLcAMPNext += (1.000000e+00 * -(_CPLcAMP - (1)) / 12.0);
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();
// cpl statements in for loop
_CPLcAMPNext += (1.000000e+00 *(currentNeighbor->cell->_CPLcAMP - _CPLcAMP) / 8.0);
}; // end for each neighbor do

}

void Cell::_CPLwaitForSignal() {
_CPLCOMMON();
if ((_CPLcAMPchange > 0.02 && _CPLclock < 0)) {
_CPLcAMP_dir = Point(0,0);
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();
// cpl statements in for loop
_CPLcAMP_dir += currentNeighbor->direction * (currentNeighbor->cell->_CPLcAMP - _CPLcAMP);
}; // end for each neighbor do

_CPLclock = _CPLRelayPeriod;
code = &_CPLwaitToSignal;
 stateCounter = 6;
 return;
}
}

void Cell::_CPLwaitToSignal() {
_CPLCOMMON();
if ((_CPLclock <= _CPLRelayPeriod - 12)) {
code = &_CPLsignal;
 stateCounter = 7;
 return;
}
}

void Cell::_CPLsignal() {
_CPLCOMMON();
_CPLcAMPNext += (1.000000e+00 *(33));
if ((_CPLclock <= _CPLRelayPeriod - 12 - 60)) {
_CPLRelayPeriod -= 10;
if ((_CPLRelayPeriod < 180)) {
_CPLRelayPeriod = 180;
}
code = &_CPLwaitForSignal;
 stateCounter = 4;
 return;
}
}

void Cell::_CPLCOMMON() {
_CPLclock -=  1.000000e+00 ;
_CPLcAMPNext += (1.000000e+00 * -(_CPLcAMP - (1)) / 12.0);
_CPLcAMPchange = 0;
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();
// cpl statements in for loop
_CPLcAMPchange += (currentNeighbor->cell->_CPLcAMP - _CPLcAMP) / 8.0;
}; // end for each neighbor do

_CPLcAMPNext += (1.000000e+00 *_CPLcAMPchange);
if ((randBetween(1,_CPLRelayPeriod) <= 2 && _CPLclock > 0)) {
{// with neighbor do 
 FPoint _CPLdirection = matrix->getLocation( cellNumber) +_CPLcAMP_dir;
 int neighb = matrix->findNeighborInDirection( cellNumber, _CPLdirection);
 if (neighborListCurrent)
neighbor->resetList();
else {
 // reconstruct neighbor list
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
neighborListCurrent = TRUE;
}
while (!neighbor->emptyList() && neighb != 
(currentNeighbor = neighbor->nextItemInList() )->cell->cellNumber);
if ( neighb != currentNeighbor->cell->cellNumber){
error("Error:cplCode.cc-> Shouldn't be in this part of the code, In with neighbor do, mistakenly thought neighbors were current");
}
// with neighbor do cpl statements
if ((currentNeighbor->cell->getTissueType() == 5)) {
cout <<matrix->getLocation( cellNumber) << ' ';
cout << currentNeighbor->cell->getState();
cout << "\n";
matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +_CPLcAMP_dir);
neighborListCurrent = FALSE;
cout <<matrix->getLocation( cellNumber) << ' ';
cout << getState();
cout << "\n";
}
 else {
_CPLclock = currentNeighbor->cell->_CPLclock;
}
currentNeighbor = (neighborInfo* ) Undefined;
}// end with neighbor do 
}
if ((randBetween(1,240) <= 1)) {
_CPLr_dir = matrix->randomDirection();
{// with neighbor do 
 FPoint _CPLdirection = matrix->getLocation( cellNumber) +_CPLr_dir;
 int neighb = matrix->findNeighborInDirection( cellNumber, _CPLdirection);
 if (neighborListCurrent)
neighbor->resetList();
else {
 // reconstruct neighbor list
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
neighborListCurrent = TRUE;
}
while (!neighbor->emptyList() && neighb != 
(currentNeighbor = neighbor->nextItemInList() )->cell->cellNumber);
if ( neighb != currentNeighbor->cell->cellNumber){
error("Error:cplCode.cc-> Shouldn't be in this part of the code, In with neighbor do, mistakenly thought neighbors were current");
}
// with neighbor do cpl statements
if ((currentNeighbor->cell->getTissueType() == 5)) {
cout <<matrix->getLocation( cellNumber) << ' ';
cout << currentNeighbor->cell->getState();
cout << "\n";
matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +_CPLr_dir);
neighborListCurrent = FALSE;
cout <<matrix->getLocation( cellNumber) << ' ';
cout << getState();
cout << "\n";
}
currentNeighbor = (neighborInfo* ) Undefined;
}// end with neighbor do 
}
}

void Cell::_CPLunnamedState_d() {
cout << "Time = ";
cout <<time << ' ';
cout << "\n";
if ((int(time) % (500) == 1)) {
matrix->stateImage();
}
}

 void Cell::_cellInitialize()
 {
PointList InFigure; 
// Define the observer cell
cell[ 1] = new Cell( cell[0], FALSE);
cell[ 1]->area = 0;
cell[ 1]->dummy = TRUE;
cell[ 1]->tissueType = 1;
cell[ 1]->stateCounter  = tissue[ 1]->state;
cell[ 1]->code = stateCode[ cell[ 1]->stateCounter];

InFigure.AddRectangle(1,1,100,100);
while ( !InFigure.emptyList()) {
cellNumber = Cell::numberDefined;
matrix->markCell( InFigure.delget(), cellNumber);
cell[ cellNumber] = new Cell( cell[0], FALSE);
cell[ cellNumber]->area = matrix->getArea( cellNumber);

cell[ cellNumber]->tissueType = 2;
cell[ cellNumber]->stateCounter  = tissue[ 2]->state;
cell[ cellNumber]->code = stateCode[ cell[ cellNumber]->stateCounter];
cell[ cellNumber]->_CPLcAMPNext = (1);
cell[ cellNumber]->_CPLclock = 0;
cell[ cellNumber]->_CPLcAMP_dir = Point(0,0);
cell[ cellNumber]->_CPLRelayPeriod = 420;
}
cellNumber = 0;
} // end _cellInitialize()

void Cell::setCodePointers()
//link the code function in each state to its correct code
{
  stateCode[ 0] = &_CPLdoNothing;
  stateCode[ 1] = &_CPLunnamedState_a;
  stateCode[ 2] = &_CPLunnamedState_b;
  stateCode[ 3] = &_CPLunnamedState_c;
  stateCode[ 4] = &_CPLwaitForSignal;
  stateCode[ 5] = &_CPLCOMMON;
  stateCode[ 6] = &_CPLwaitToSignal;
  stateCode[ 7] = &_CPLsignal;
  stateCode[ 8] = &_CPLunnamedState_d;
}
