#ifdef NEEDS_TYPES_H
#include <sys/types.h>
#endif

#include "pq_defs.h"
#include "pcp_vars.h"
#include "pq_functions.h"
#include "constants.h"
#include "pq_author.h"
#include "menus.h"
#include "global.h"
#include "standard.h"

#if defined (QUOTPIC)
#include "times.h"
#endif 

/* main routine for p-quotient program; the run-time parameters are 

   -b to choose basic format for input of presentation; 
   -c to write CAYLEY group library;
   -g to write GAP group library and to run pq from within GAP;
   -m to write Magma group library;
   -i to choose standard presentation menu;
   -k to read from file using key words; 
   -q to choose quotpic menu; 
   -s <integer> to allocate array of size <integer> for workspace y;
   -t to pass time limit in CPU seconds for computation 
      where t = 0 implies infinite time;
   -w <filename> to write group descriptions in CAYLEY/GAP/Magma format 
      to <filename> -- used in conjunction with -c or -g or -m

   if workspace not passed, the default size of y is the constant PQSPACE */

int work_space = PQSPACE;
int format = PRETTY;
int menu = DEFAULT_MENU;
Logical StandardPresentation = FALSE;

main (argc, argv)
int argc;
char *argv[];
{
#include "define_y.h"

   int t;
   struct pcp_vars pcp;

   t = runTime ();

#ifdef MALLOC_DEBUG
   malloc_debug (2|4|8);   
#endif

#ifndef VMS
   setbuf (stdout, NULL);
#endif

#if defined (QUOTPIC)
   time_limit = 0;
#endif 

   Compact_Description = FALSE;

   /* process run-time parameters */
   if (process_parameters (argc, argv) == 0) {
      printf ("Usage: pq [-b] [-c] [-g] [-i] [-k] [-m] [-s <integer>] [-w <filename>]\n");
      exit (FAILURE);
   }

#ifdef Magma
   y = (int *) allocate_vector (work_space + 1000, 0, FALSE);
   bh_initialize (y, work_space + 1000, NULL);
   bh_set_no_zeroing (1);
#endif
       
   Allocate_WorkSpace (work_space, &pcp);

   /* print startup message */
   print_message (work_space);

#if defined (QUOTPIC)
   if (menu == QUOTPIC_MENU)
      quotpic_menu (format, &pcp);
   else 
#endif
#if defined (STANDARD_PCP)
      if (menu == ISOM_MENU) 
         isom_options (format, &pcp); 
      else 
#endif 
         options (DEFAULT_MENU, format, &pcp); 

/*
   t = runTime () - t;
*/
t = runTime ();
   printf ("Total user time in seconds is %.2f\n", t * CLK_SCALE);

   exit (SUCCESS);
}

/* process run-time parameters */

int process_parameters (argc, argv)
int argc;
char *argv[];
{
   int i;
   Logical error;

   Group_library_file = NULL;

   for (i = 1; i < argc; ++i) {
      if (strcmp (argv[i], "-s") == 0) {
         if (i == argc - 1) 
            return (0);
         work_space = string_to_int (argv[++i], &error);
         if (error)
            return (0);
      }
      else if (strcmp (argv[i], "-w") == 0) {
         if (i == argc - 1 || argv[++i][0] == '-') 
            return (0);
         Group_library_file = allocate_char_vector (strlen (argv[i]), 0, FALSE);
         strcpy (Group_library_file, argv[i]);
      }
#if defined (QUOTPIC)
      else if (strcmp (argv[i], "-t") == 0) {
         if (i == argc - 1) 
            return (0);
         time_limit = (string_to_int (argv[++i], &error)) * CLK_TCK;
         if (error)
            return (0);
      }
#endif 
      else {
         if (strcmp (argv[i], "-b") == 0)  
            format = BASIC;
#if defined (STANDARD_PCP)
         else if (strcmp (argv[i], "-i") == 0)  
            menu = ISOM_MENU;
#endif
         else if (strcmp (argv[i], "-k") == 0)  
            format = FILE_INPUT;
         else if (strcmp (argv[i], "-c") == 0)  
            Group_library = CAYLEY_LIBRARY;
         else if (strcmp (argv[i], "-g") == 0)  
            Group_library = GAP_LIBRARY;
         else if (strcmp (argv[i], "-m") == 0)  
            Group_library = Magma_LIBRARY;
#if defined (QUOTPIC)
         else if (strcmp (argv[i], "-q") == 0)  
            menu = QUOTPIC_MENU;
#endif 
         else 
            return (0);
      }
   }        

#if defined (GAP)
   CreateGAPLibraryFile ();
#endif 

   return 1;
}

#if defined (GAP)

/* if pq is called successfully from GAP, we want GAP_library file to exist 
   in all cases, even if no group descriptions have been saved to it */

int CreateGAPLibraryFile ()
{
   FILE *GAP_library;
   
   if (Group_library == GAP_LIBRARY) {
      if (Group_library_file == NULL)
	 Group_library_file = "GAP_library";
      GAP_library = OpenFile (Group_library_file, "a+");
      fprintf (GAP_library, "ANUPQmagic := \"groups saved to file\";\n");
      CloseFile (GAP_library);
   }
}

#endif 
