#############################################################################
## AUTHOR:            C. Rhodes
## DATE:              Fri Jan 22 14:33:09 EST 1993
## STATUS:            2.0
#############################################################################
# check the ranks and classes of the groups library
#############################################################################

check_rank_order := function(torder)

 local l,totals,i;

  #initialise
  totals :=[];            
  for i in [1..8] do
    totals[i]:=0;
  od;

  #retrieve the groups
  l:=AllThreeGroups(Size,torder);

  #and count the ranks
  for i in [1..Length(l)] do
    totals[l[i].rank]:=totals[l[i].rank]+1;
  od;

  return totals;

end;


check_class_order := function(torder)

 local l,totals,i;

  #initialise
  totals :=[];            
  for i in [1..8] do
    totals[i]:=0;
  od;

  #retrieve the groups
  l:=AllThreeGroups(Size,torder);

  #and count the ranks
  for i in [1..Length(l)] do
    totals[l[i].pclass]:=totals[l[i].pclass]+1;
  od;

  return totals;

end;

for j in [3,9,27,81,243,729] do
  Print("Groups of order ",j," have rank ",check_rank_order(j),"\n");
  Print(" and class",check_class_order(j),"\n");
od;