#ifdef hp700
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <fcntl.h>
#include <stdio.h>
#include "startmpqs.h"
#include "file-name.h"

#ifndef PRIO_MAX
#define PRIO_MAX 20
#endif

/*
 *	start mpqs with the right inputs and so on.
 */

int
startmpqs(char	*av[])
{
	int	jobno;
	int	pid;
	int	pipefd;
	int	outfd;
	char	outfile[BUFSIZ];

	buildfilename(outfile, LOGDIR, LOG_FILE, NULL);

	while((jobno = getnum(TASKLIST)) <= 0) {
		/* Didn't get a job number.  Sit and wait for one,
		 * rather than trying to start with job zero!
		 */
		if ((outfd = open(outfile, O_RDWR | O_APPEND | O_CREAT, 
				  0777)) == -1) {
			fprintf(stderr, "Cannot open %s: ignoring.\n",
				outfile);
		}
#define ERROR_MSG "No tasks available or error reading tasks.  Sleeping.\n"
		write(outfd, ERROR_MSG, strlen(ERROR_MSG));
		close(outfd);
		sleep(600);
	}

	switch (pid = fork()) {
	case -1:			/* error */
		fputs("Cannot fork.\n", stderr);
		return -1;
	case 0:				/* child */
#ifdef hp700
		nice(PRIO_MAX);
#else
		setpriority(PRIO_PROCESS, getpid(), PRIO_MAX);
#endif
		writepid_job(getpid(), jobno);
		pipefd = subsjobno(jobno);
		dup2(pipefd, 0);
		close(pipefd);
		if ((outfd = open(outfile, O_RDWR | O_APPEND | O_CREAT, 0777)) == -1) {
			fprintf(stderr, "Cannot open %s: ignoring.\n",
			    outfile);
		}
		dup2(outfd, 1);
		dup2(outfd, 2); 
		close(outfd);
#define	TESTMESSAGE	"\tMPQS restarted\n\n"
		write(1, TESTMESSAGE, strlen(TESTMESSAGE));
		execv(av[0], av);
		fprintf(stderr, "cannot exec %s\n", av[0]);
		exit(1);
		break;
	default:			/* parent */
		return pid;
	}
}
