
(define (make-loopthunk n)    ;;returns thunk s.t. (( ...  (thunk) ...)) is (thunk . 'anything)
 (letrec ((aux (lambda (m)    ;;                   |<--n-->|
           (if (zero? m)
               (cons (lambda () (aux n)) 'anything)
               (lambda () (aux (- m 1)))))))
         (aux n)))

(define (test loopthunk)
  (letrec ((repeat
            (lambda (thunk result)
              (cond ((pair? thunk) result)
                    (else
                     (repeat (thunk)
                             (cons
                              (1+ (car result))
                              result)))))))
    (repeat loopthunk (list 0))))

(define lt2 (make-loopthunk 2))

(test lt2)
