(define system-constant-suffix 0)

(define (systemeval exp)
  (scheme->subeval (eval exp user-initial-environment)))

(define (scheme->subeval obj)
  (cond ((null? obj) nil-builtin)
        ((list? obj)
	 (cons '<<list>> (map scheme->subeval obj)))
	((pair? obj)
	 (list '<<cons>>
	       (scheme->subeval (car obj))
	       (scheme->subeval (cdr obj))))
	((procedure? obj)
         (install-system-constant! obj))
	((symbol? obj)
	 `(quote ,obj))
	((equal? obj (if #f 'dontcare))     ;;;;;  undefined value
	 undefined-value)
	((boolean? obj) obj)
        ((number? obj) obj)
        ((string? obj) obj)
        (else
         (sm-error
          "scheme->subeval: unrepresentable object" obj))))
        
(define (install-system-constant! obj)
  (let ((name (get-next-fresh-sys-name)))
    (eval `(define ,name ,obj) user-initial-environment)
    (add-to-functional-constants! name)
    name))                              ;REVISED

(define (get-next-fresh-sys-name)       ;REVISED
  (set! system-constant-suffix (1+ system-constant-suffix))
  (add-angle-brackets
   (string->symbol
    (string-append
     "system-procedure"
     "#"
     (number->string system-constant-suffix)))))

(define (add-angle-brackets name)  ;REVISE here and in import.scm: wasteful symbol->string calls
  (string->symbol
   (string-append
    "<<"
    (symbol->string name)
    ">>")))

(define (add-to-functional-constants! name)          ;REVISED
    (if (not (member name functional-constants))
        (set! functional-constants
              (cons name functional-constants))))
