/*
 *	Test of General Matrix routines for type <T>
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xgemattest.cc	2.2	9/26/89
 */

/* 
Note that in what follows, explicit type conversions have been used.
For example,

    c(1) = <T>(-1.0);
    c[2] = <T>(-2.0);

This is for the benefit of type complex.  It is not necessary to do
this when using the GNU compiler and its class Complex (as declared in
Complex.h).  However, it is necessary when using the AT&T class
complex, as declared in complex.h.  I have not tried the GNU Complex.h
file with the AT&T compiler.  
*/

#define NO_VECTOR_MATHFUN
#include "rw/<A>GEMatrix.h"
#define TYPE <T>_TYPE
#include "vecdefs.h"
#include <stream.h>
extern Cdecl void exit(int);

main()
{
  cout << "\n**** Constructors / destructors ****\n";
  
  // <A>GEMatrix();
  <A>GEMatrix a;
  cout << NL << "<A>GEMatrix a:\n" << a <<NL;
  
  // <A>GEMatrix(int rows, int cols);
  <A>GEMatrix aa(4, 4);
  cout << NL << "<A>GEMatrix aa(4, 4):\n" << aa <<NL;
  
  // <A>GEMatrix(int rows, int cols, <T> initval);
  <A>GEMatrix b(4, 4, <T>(1));
  cout << NL << "<A>GEMatrix b(4, 4, 1):\n" << b <<NL;

  // <A>GEMatrix(const <T>Vec&, int, int);
  <A>GEMatrix c(<T>Vec(16, <T>(2)), 4, 4);
  cout << NL << "<A>GEMatrix c(<T>Vec(16,2.0),4,4):\n" << c <<NL;

  // <A>GEMatrix(const <A>GEMatrix&);
  <A>GEMatrix d = c;
  cout << NL << "<A>GEMatrix d = c:\n" << d <<NL;

  // <A>GEMatrix::deepenShallowCopy();
  d.deepenShallowCopy();
  cout << NL << "d.deepenShallowCopy():\n" << d <<NL;

  cout << "\n**** Assignments ****\n";

  // <A>GEMatrix		operator=(const <A>GEMatrix&);
  d = b;
  cout << NL << "d = b:\n" << d <<NL;

  // <A>GEMatrix		operator=(<T>);
  d = <T>(-1);
  cout << NL << "d = <T>(-1):\n" << d <<NL;

  cout << "\n**** Slice and subscripting operators ****\n";

  // <T>Slice		operator[](int j);	// Return a col as a slice
  d[1] = <T>(-2);
  cout << NL << "d[1] = <T>(-2):\n" << d <<NL;

  //<T>Slice		row(int i);		// Return a row as a slice
  d.row(1) = <T>(-3);
  cout << NL << "d.row(1) = <T>(-3):\n" << d <<NL;

  //<T>&		operator()(int i, int j); // Subscripting
  d(1,1) = <T>(-4);
  cout << NL << "d(1,1) = <T>(-4):\n" << d <<NL;

  // <T>Vec		diagonal(int idiag=0);	// Return a diagonal as a slice
  d.diagonal(-1) = <T>(-5);
  cout << NL << "d.diagonal(-1) = -5:\n" << d <<NL;

  d.diagonal(1) = <T>(5);
  cout << NL << "d.diagonal(1) = 5:\n" << d <<NL;

  <A>GEMatrix e(5,4,<T>(1));
  for(int irow=0; irow<e.rows(); irow++)e.row(irow) = <T>(irow);
  cout << NL << "e:\n" << e <<NL;
  cout << NL << "transpose(e):\n" << transpose(e) <<NL;

  cout << "\n**** Resize ****\n";

  <A>GEMatrix f(d);
  cout << NL <<"f:\n" << f <<NL;
  f.resize(7,3);
  cout << NL <<"f.resize(7,3)\n" << f <<NL;
  f.resize(3,7);
  cout << NL <<"f.resize(3,7)\n" << f <<NL;
  f.resize(2,2);
  cout << NL <<"f.resize(2,2)\n" << f <<NL;
  f.resize(4,4);
  cout << NL <<"f.resize(4,4)\n" << f <<NL;

  cout << "\n**** Arithmetic operators ****\n";

  cout << NL <<"c:\n" << c <<NL;
  cout << NL <<"d:\n" << d <<NL;

  //friend	<A>GEMatrix	operator-(const <A>GEMatrix&);   // Unary minus
  cout << NL <<"-d:\n" << -d <<NL;

#if HAS_INCRDECR
  //friend	<A>GEMatrix	operator++(const <A>GEMatrix&);
  cout << NL <<"d++:\n" << d++ <<NL;

  //friend	<A>GEMatrix	operator--(const <A>GEMatrix&);
  cout << NL <<"d--:\n" << d-- <<NL;
#endif

  //friend	<A>GEMatrix	operator*(const <A>GEMatrix&, const <A>GEMatrix&);
  cout << NL << "d * c:\n" << d * c <<NL;

#if HAS_DIVIDE
  //friend	<A>GEMatrix	operator/(const <A>GEMatrix&, const <A>GEMatrix&);
  cout << NL << "d / c:\n" << d / c <<NL;
#endif

  //friend	<A>GEMatrix	operator+(const <A>GEMatrix&, const <A>GEMatrix&);
  cout << NL << "d + c:\n" << d + c <<NL;

  //friend	<A>GEMatrix	operator-(const <A>GEMatrix&, const <A>GEMatrix&);
  cout << NL << "d - c:\n" << d - c <<NL;

  //friend	<A>GEMatrix	operator*(const <A>GEMatrix&, <T>);
  cout << NL << "<T>(2) * d:\n" << <T>(2) * d <<NL;

#if HAS_DIVIDE
  //friend	<A>GEMatrix	operator/(const <A>GEMatrix&, <T>);
  cout << NL << "d / <T>(2):\n" << d / <T>(2) <<NL;

  //friend	<A>GEMatrix	operator/(<T>, const <A>GEMatrix&);
  cout << NL << "<T>(2) / d:\n" << <T>(2) / d <<NL;
#endif

  //friend	<A>GEMatrix	operator+(const <A>GEMatrix&, <T>);
  cout << NL << "<T>(2) + d:\n" << <T>(2) + d <<NL;

  // friend	<A>GEMatrix	operator-(const <A>GEMatrix&, <T>);
  cout << NL << "d - <T>(2):\n" << d - <T>(2) <<NL;

  // friend	<A>GEMatrix	operator-(<T>, const <A>GEMatrix&);
  cout << NL << "<T>(2) - d:\n" << <T>(2) - d <<NL;

  exit(0);
};
