/*
 *	Definitions for <T>Block
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xblock.cc	2.2	9/18/89
 */


#define NO_VECTOR_MATHFUN
#include "rw/<T>Vec.h"
#define TYPE <T>_TYPE
#include "vecdefs.h"

static const char SCCSid[] = "@(#)xblock.cc	2.2 9/18/89";

<T>Block::<T>Block(unsigned n)
{

#ifdef DEBUG
  if(this){
    RWnote("<T>Block::<T>Block()", "Not on free store.");
    RWerror(FATAL);
  }
#endif
#ifdef __ATT__
  // cfront can't handle zero lengthed arrays
  int nxtra = (n<=1 ? 0 : n-1);
#else
#define nxtra n-1
#endif  
  this = (<T>Block *)new char[sizeof(<T>Block) + sizeof(<T>)*(nxtra)];
  npts = n;
  refs = 1;
}

<T>Block::<T>Block(unsigned n, <T> val)
{

#ifdef DEBUG
  if(this){
    RWnote("<T>Block", "Not on free store.");
    RWerror(FATAL);
  }
#endif
#ifdef __ATT__
  int nxtra = (n<=1 ? 0 : n-1);
#else
#define nxtra n-1
#endif  
  this = (<T>Block *)new char[sizeof(<T>Block) + sizeof(<T>)*(nxtra)];
  refs = 1;
  register int i = npts = n;
  register <T>* dp = data();
  REGISTER <T> value = val;
  while(i--) *dp++ = value;
}

<T>Block::<T>Block(unsigned n, <T> val, <T> by)
{

#ifdef DEBUG
  if(this){
    RWnote("<T>Block", "Not on free store.");
    RWerror(FATAL);
  }
#endif
#ifdef __ATT__
  int nxtra = (n<=1 ? 0 : n-1);
#else
#define nxtra n-1
#endif  
  this = (<T>Block *)new char[sizeof(<T>Block) + sizeof(<T>)*(nxtra)];
  refs = 1;
  register int i = npts = n;
  register <T>* dp = data();
  REGISTER <T> value = val;
  REGISTER <T> byvalue = by;
  while(i--) {*dp++ = value; value += byvalue;}
}

<T>Block::~<T>Block()
{
  if(--refs) this = 0;
}

        
