/*
 *	Utilities used by the Vector routines
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)utility.cc	2.2	9/18/89
 */

#include "rw/vdefs.h"
#include <stream.h>
#include <ctype.h>
#ifdef __GNUG__
#include <std.h>
#else
#include <osfcn.h>
#include <stdlib.h>
#endif

static const char SCCSid[] = "@(#)utility.cc	2.2 9/18/89";

void
RWerror(Severity gravity)
{
  switch (gravity) {
  case WARNING:
    fputs("** Processing continues.\n", stderr);
    break;
  case DEFAULT:
  case FATAL:
  default:
    fputs("** Processing terminated.\n", stderr);
    exit(gravity);
  }
}

void
RWnote(const char* routine, const char* comment)
{
  fputs("\n",stderr);
  fputs("** ",stderr);
  fputs(routine,stderr);
  fputs("\n",stderr);

  fputs("** ", stderr);
  fputs(comment, stderr);
  fputs("\n", stderr);
}

void
RWreadBin( fileDescTy& fd, void* ptr, unsigned len, const char* routine )
{
  int retval = read( fd, (char*)ptr, len );
  if (retval < 1) {
    RWnote(routine,"Error in binary IO read call");
    RWerror(DEFAULT);
  }
  if (retval < len) {
    RWreadBin( fd, ((char*)ptr)+retval, len-retval, routine );  // read the rest
  }
}

void
RWstoreBin( fileDescTy& fd, const void* ptr, unsigned len, const char* routine )
{
  int retval = write( fd, (char*)ptr, len );
  if (retval < 1) {
    RWnote(routine,"Error in binary IO write call");
    RWerror(DEFAULT);
  }
  if (retval < len) {
    RWstoreBin( fd, ((char*)ptr)+retval, len-retval, routine ); //write the rest
  }
}

void
RWstoreID(ostream& s, const char* ID, const char*)
{
  s << ID;
}

void
RWstoreID(fileDescTy& fd, const char* ID, const char* routine)
{
  RWstoreBin( fd, "B", 1, routine ); // Store a "B" to indicate binary 
  int stringLen = 0;	  // Don't want to rely on a strlen() function
  for( const char* index = ID; *index; index++,stringLen++ );
  RWstoreBin( fd, ID, stringLen, routine );
}

static void
typeIDReadErr(const char* routine)
{
  RWnote(routine,"Error in ID read");
  RWerror(DEFAULT);
}

void
RWreadID(istream& s, const char* ID, const char* routine)
{
  char c;
  int typeok = 1;
  s >> c;
  while ( isspace(c) ) s >>c;	// Eat white space
  for( const char *index = ID; *index; index++ ) {
    if (c != *index) typeok=0;
    if ( *(index+1) ) s.get(c);	// Use get to avoid missing white space
  }
  if (!typeok) typeIDReadErr(routine);
}

void
RWreadID(fileDescTy& fd, const char* ID, const char* routine)
{
  int typeok = 1;
  char c;
  RWreadBin( fd, &c, 1, routine );
  if ( c != 'B' ) typeok=0;
  for( const char* index = ID; typeok && *index; index++ ) {
    RWreadBin( fd, &c, 1, routine );
    if (c != *index) typeok=0;
  }
  if (!typeok) typeIDReadErr(routine);
}
