c   imsl routine name   - vbla=dswap                                    vbdl0010
c
c-----------------------------------------------------------------------
c
c   computer            - vax/double
c
c   latest revision     - january 1, 1978
c
c   purpose             - interchange vectors x and y, both
c                           double precision
c
c   usage               - call dswap (n,dx,incx,dy,incy)
c
c   arguments    n      - length of vectors x and y. (input)
c                dx     - double precision vector of length
c                           max(n*iabs(incx),1). (input/output)
c                           dswap interchanges x(i) with y(i) for
c                           i=1,...,n.
c                           x(i) and y(i) refer to specific elements
c                           of dx and dy, respectively. see incx and
c                           incy argument descriptions.
c                incx   - displacement between elements of dx. (input)
c                           x(i) is defined to be..
c                           dx(1+(i-1)*incx) if incx.ge.0 or
c                           dx(1+(i-n)*incx) if incx.lt.0.
c                dy     - double precision vector of length
c                           max(n*iabs(incy),1). (input/output)
c                incy   - displacement between elements of dy. (input)
c                           y(i) is defined to be..
c                           dy(1+(i-1)*incy) if incy.ge.0 or
c                           dy(1+(i-n)*incy) if incy.lt.0.
c
c   precision/hardware  - double/all
c
c   reqd. imsl routines - none required
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   copyright           - 1978 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
      subroutine dswap  (n,dx,incx,dy,incy)
c
c                                  specifications for arguments
      double precision   dx(1),dy(1)
      integer            n,incx,incy
c                                  specifications for local variables
      double precision   dtemp1,dtemp2,dtemp3
      integer            i,ix,iy,m,mp1,ns
c                                  first executable statement
      if (n.le.0) return
      if (incx.eq.incy) if (incx-1) 5,15,35
    5 continue
c                                  code for unequal or nonpositive
c                                    increments.
      ix = 1
      iy = 1
      if (incx.lt.0) ix = (-n+1)*incx+1
      if (incy.lt.0) iy = (-n+1)*incy+1
      do 10 i=1,n
         dtemp1 = dx(ix)
         dx(ix) = dy(iy)
         dy(iy) = dtemp1
         ix = ix+incx
         iy = iy+incy
   10 continue
      return
c                                  code for both increments equal to 1
c                                    clean-up loop so remaining vector
c                                    length is a multiple of 3.
   15 m = n-(n/3)*3
      if (m.eq.0) go to 25
      do 20 i=1,m
         dtemp1 = dx(i)
         dx(i) = dy(i)
         dy(i) = dtemp1
   20 continue
      if (n.lt.3) return
   25 mp1 = m+1
      do 30 i=mp1,n,3
         dtemp1 = dx(i)
         dtemp2 = dx(i+1)
         dtemp3 = dx(i+2)
         dx(i) = dy(i)
         dx(i+1) = dy(i+1)
         dx(i+2) = dy(i+2)
         dy(i) = dtemp1
         dy(i+1) = dtemp2
         dy(i+2) = dtemp3
   30 continue
      return
   35 continue
c                                  code for equal, positive, nonunit
c                                    increments.
      ns = n*incx
      do 40 i=1,ns,incx
         dtemp1 = dx(i)
         dx(i) = dy(i)
         dy(i) = dtemp1
   40 continue
      return
      end
