
#include <sys/time.h>
#include <stdio.h>


void clip1( int n, int x[], int y[], int mask[], int width, int height )
{
   int i;

   for (i=0;i<n;i++) {
      mask[i] = (x[i]>=0) && (y[i]>=0) && (x[i]<width) && (y[i]<height);
   }
}


void clip2( int n, int x[], int y[], int mask[], int width, int height )
{
   int i;

   for (i=0;i<n;i++) {
      if (x[i]<0 || y[i]<0 || x[i]>=width || y[i]>=height) {
	 mask[i] = 0;
      }
      else {
	 mask[i] = 1;
      }
   }
}


void clip3( int n, int x[], int y[], int mask[], int width, int height )
{
   int i;

   i = 0;
   while (i<n) {
      mask[i] = (x[i]>=0) & (y[i]>=0) & (x[i]<width) & (y[i]<height);
      i++;
   }
}


unsigned int get_time()
{
   struct timeval t;

   if (gettimeofday( &t, 0) < 0) {
      printf("ERROR:  gettimeofday() failed\n");
   }

   return t.tv_sec * 1000 + t.tv_usec / 1000;
}


#define MAX 4000
#define ITER 1600


main()
{
   unsigned int t0, t1, t2, t3;
   int x[MAX], y[MAX], mask[MAX];
   int i, j;

   for (i=0;i<MAX;i++) {
      x[i] = i*2;
      y[i] = i+4;
   }


   t0 = get_time();
   for (j=0;j<ITER;j++) {
      clip1( MAX, x, y, mask, 120, 80 );
   }

   t1 = get_time();
   for (j=0;j<ITER;j++) {
      clip2( MAX, x, y, mask, 120, 80 );
   }

   t2 = get_time();
   for (j=0;j<ITER;j++) {
      clip3( MAX, x, y, mask, 120, 80 );
   }

   t3 = get_time();

   printf("clip1: %d\n", t1-t0);
   printf("clip2: %d\n", t2-t1);
   printf("clip3: %d\n", t3-t2);

}
