/* nurbs.c */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: nurbs.c,v 1.9 1995/05/30 13:12:39 brianp Exp $

$Log: nurbs.c,v $
 * Revision 1.9  1995/05/30  13:12:39  brianp
 * added gluNurbsCallback() stub
 *
 * Revision 1.8  1995/05/29  20:09:11  brianp
 * added gluGetNurbsProperty()
 *
 * Revision 1.7  1995/05/24  13:44:11  brianp
 * added gluBeginTrim, gluEndTrim, gluPwlCurve stubs
 *
 * Revision 1.6  1995/05/22  16:56:20  brianp
 * Release 1.2
 *
 * Revision 1.5  1995/05/16  19:17:21  brianp
 * minor changes to allow compilation with real OpenGL headers
 *
 * Revision 1.4  1995/04/28  20:06:23  brianp
 * print an error message when trying to use gluNewNurbsRenderer()
 *
 * Revision 1.3  1995/04/28  14:37:32  brianp
 * moved GLUnurbsObj struct from .h to .c file
 *
 * Revision 1.2  1995/03/04  19:39:18  brianp
 * version 1.1 beta
 *
 * Revision 1.1  1995/02/24  15:45:01  brianp
 * Initial revision
 *
 */


#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "gluP.h"



struct GLUnurbsObj {
	GLboolean Culling;
};




GLUnurbsObj *gluNewNurbsRenderer( void )
{
   GLUnurbsObj *n;

   fprintf(stderr,"Error: NURBS not implemented in Mesa\n");

   n = (GLUnurbsObj *) malloc( sizeof(struct GLUnurbsObj) );
   if (n) {
      /* init */
   }
   return n;
}



void gluDeleteNurbsRenderer( GLUnurbsObj *nobj )
{
   if (nobj) {
      free( nobj );
   }
}



void gluLoadSamplingMatrices( GLUnurbsObj *nobj,
			      const GLfloat modelMatrix[16],
			      const GLfloat projMatrix[16],
			      const GLint viewport[4] )
{
}


void gluNurbsProperty( GLUnurbsObj *nobj, GLUenum property, GLfloat value )
{
   switch (property) {
      case GLU_SAMPLING_TOLERANCE:
         break;
      case GLU_DISPLAY_MODE:
         break;
      case GLU_CULLING:
	 nobj->Culling = (GLboolean) value;
         break;
      case GLU_AUTO_LOAD_MATRIX:
         break;
   }
}


void gluGetNurbsProperty( GLUnurbsObj *nobj, GLenum property, GLfloat *value )
{
   /* TODO: this function is incomplete */
   switch (property) {
      case GLU_SAMPLING_TOLERANCE:
         *value = 0.0;
         break;
      case GLU_DISPLAY_MODE:
         *value = 0.0;
         break;
      case GLU_CULLING:
	 *value = nobj->Culling ? 1.0 : 0.0;
         break;
      case GLU_AUTO_LOAD_MATRIX:
         *value = 0.0;
	 break;
      default:
	 /* TODO??? */
	 ;
   }
}



void gluBeginCurve( GLUnurbsObj *nobj )
{
}


void gluEndCurve( GLUnurbsObj * nobj )
{
}


void gluNurbsCurve( GLUnurbsObj *nobj, GLint nknots, GLfloat *knot,
		    GLint stride, GLfloat *ctlarray, GLint order, GLenum type )
{
}


void gluBeginSurface( GLUnurbsObj *nobj )
{
}


void gluEndSurface( GLUnurbsObj * nobj )
{
}


void gluNurbsSurface( GLUnurbsObj *nobj,
		      GLint sknot_count, GLfloat *sknot,
		      GLint tknot_count, GLfloat *tknot,
		      GLint s_stride, GLint t_stride,
		      GLfloat *ctlarray,
		      GLint sorder, GLint torder,
                      GLenum type )
{
}



void gluBeginTrim( GLUnurbsObj *nobj )
{
}



void gluEndTrim( GLUnurbsObj *nobj )
{
}



void gluPwlCurve( GLUnurbsObj *nobj, GLint count, GLfloat *array,
		  GLint stride, GLenum type )
{
}


void gluNurbsCallback( GLUnurbsObj *nobj, GLenum which, void (*fn)() )
{
}

