//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        stranslate.C
//
// Purpose:     implementation of class STranslate
//
// Created:     29 Mar 94   Michael Pichler
//
// Changed:     24 Oct 95   Tomas Torron-Mack (added Spanish)
//
// Changed:     15 Dec 95   ric Plante <planteer@JSP.UMontreal.CA> (added French)
//
// Changed:     25 Jan 96   Michael Pichler
//
// $Id: stranslate.C,v 1.19 1996/02/01 10:05:21 mpichler Exp $
//
//</file>



#include "stranslate.h"



// English, German, Styrian, French, Italian, Spanish


static const char* sstringtable [STranslate::NumStrings][HgLanguage::NumLanguages] =
{
  // AboutSCENEVIEWER
  { "VRweb - 3D Scene Viewer", "VRweb - 3D Szenen-Viewer", "Wie-Aar-web - Drei De Wiua", "VRweb - Visionneur 3-D", 0, 0 },
  // AboutVERSIONtemplate
  { "Version 1.1.2 (%s)\nof %s\n\n"
    "by Michael Pichler (mpichler@iicm.tu-graz.ac.at) et.al.\n\n"
    "latest VRweb info:\n"
    "http:/""/hyperg.iicm.tu-graz.ac.at/vrweb\n"
    "Please, send error reports to\nvrweb-bugs@iicm.tu-graz.ac.at",
    0, 0, 0, 0, 0 },  // %s should be filled with comment and compilation date via sprintf

  /* Anchor highglighting */
  // AnchBRIGHTNESS
  { "Brightness", "Helligkeit", "Hlligkeit", "Surbrillance", 0, "Brillo" },
  // AnchBOUNDINGCUBE
  { "Bounding Cube", "Begrenzungswrfel", "Wirfl ummadum", /*FR?*/ 0, "Cubo Delimitante" },
  // AnchCOLORCODE
  { "Colour Code", "Farbkodierung", "ondare Foab", "Code de couleur", 0, "Cdigo de Color" },
  // AnchCOLOREDGES
  { "Colour Edges", "Kanten hervorheben", "Kanten nochimolen", "Artes de couleur", 0, "Colorear Lados" },

  /* Anchor Definition, Object Selection */
  // AnchorDEFAULTDESTINATION
  { "Use Default Destination", "Verwende Defaultziel", "Nimm's normale Zl", "Utiliser destination par dfaut", 0, "Usar Destino Estndar" },
  // AnchorDEFINEDESTINATION
  { "Define As Destination", "Definiere als Ziel", "Nimm's als Zl", "Dfinir comme destination", 0, "Definir como Destino" },
  // AnchorDEFINESOURCE
  { "Define As Source", "Definiere als Quelle", "Nimm's als Qulln", "Dfinir comme source", 0, "Definir como Orgen" },
  // AnchorDELETE
  { "Delete", "Lschen", "Lschn", "Effacer", 0, "Eliminar" },
  // AnchorDESELECT
  { "Deselect Object/Group", "Selektion entfernen", "Nix auswhln", "Annuler slection d'objet/groupe", 0, "Deseleccionar Objeto/Grupo" },
  // AnchorDISPLAY
  { "Display", "Anzeigen", "Anzagn", "Afficher", 0, "Monitor" },
  // AnchorFOLLOW
  { "Follow", "Verfolgen"/* I'd prefer "Aktivieren"*/, "Nchlaffn", "Suivre", 0, "Activar" },
  // AnchorNEXT
  { "Next", "Nchster", "Nexta", "Suivant", 0, "Siguiente" },
//  // AnchorSELECTANCHORS
//  { "Select Anchors", "Anker selektieren", "nka auswhln", "Choisir ancres", 0, "Seleccionar Anclas" },
  // AnchorSELECTGROUPS
  { "Select Groups", "Gruppen selektieren", "Gruppn auswhln", "Choisir groupes", 0, "Seleccionar Grupos" },
  // AnchorSELECTOBJECTS
  { "Select Objects", "Objekte selektieren", "Objekte auswhln", "Choisir objets", 0, "Seleccionar Objetos" },

  /* Hint how to select anchors */
  // AnchorHintACTIVATION
  { "Activate anchors with ctrl+click", "Anker aktivieren mittels ctrl+click", "nka auswhln mit ctrl+click", "Faites ctrl+clic pour activer une ancre", 0, "Activar Anclas con ctrl+click" },

  /* Buttons */
  // ButtonROTATE
  { "rotate", "Rotation", "drahn", "Pivoter", 0, "Rotacin" },
  // ButtonSHOWANCHORS
  { "Anchors", "Anker", "nka", "Ancres", 0, "Anclas" },
  // ButtonTRANSL
  { "transl", "Transl", "vaschiabn", "Dplacer", 0, "Transl" },
  // ButtonZOOM
  { "zoom", "Zoomen", "zuwaziagn", "Zoom", 0, "Zoom" },

  /* Colors */
  // ColBLACK
  { "black", "schwarz", "schwoaz", "noir", "nero", "negro" },
  // ColCYAN
  { "cyan", "trkis", "trkis", 0, 0, "turquesa" },
  // ColGRAY
  { "grey", "grau", "grau", "gris", 0, "gris" },
  // ColGREEN
  { "greeen", "grn", "grn", "vert", "verde", "verde" },
  // ColLIGHTGRAY
  { "lt.grey", "hellgrau", "hllgrau", "gris ple", 0, "gris claro" },
  // ColMAGENTA
  { "magenta", "rosa", "rosa", 0, 0, "magenta" },
  // ColORANGE
  { "orange", "orange", "oronsch", 0, 0, "naranja" },
  // ColPURPLE
  { "purple", "lila", "lila", "mauve", 0, "prpura" },
  // ColREDBROWN
  { "red-brown", "rot-braun", "rot-braun", "brun rouge", 0, "marrn rojizo" },
  // ColYELLOW
  { "yellow", "gelb", "glb", "jaune", "giallo", "amarillo" },
  // ColWHITE
  { "white", "wei", "wei", "blanc", "bianco", "blanco" },

  /* Color Submenus */
  // ColorANCHOREDGES
  { "Anchor Edges", "Anker-Kanten", "nka Kantn", "Artes des ancres", 0, "Lados del Ancla" },
  // ColorANCHORFACES
  { "Anchor Faces", "Anker-Flchen", "nka Flchn", "Surface des ancres", 0, "Caras del Ancla" },
  // ColorBACKGROUND
  { "Background", "Hintergrund", "Hintagrund", "Fond", 0, "Fondo" },
  // ColorHEADSUP
  { "Heads-up Display", "Kontrollsymbole", "Die klanen Kastln", "Console", 0, "Controles" },
  // ColorOTHER
  { "Choose...", "auswhlen...", "auswhln...", "Slection...", 0, "Elejir..." },
  /* { "other...", "andere...", "ndare...", "autres...", "altri...", "otros..." }, */
  // ColorVIEWINGLIGHT
  { "Viewing Light", "Standard-Lichtquelle", "s' normale Licht", "Lumire standard", 0, "Fuente de Luz" },

  /* Demo Menu Items */
  // DemoCAR_VW
  { "Car (VW)", "VW-Kfer", "FauWeh-Kfa", "Automobile (VW)", 0, "Coche (VW)" },
  // DemoCLOCKTOWER
  { "Clock Tower", "Uhrturm", "Uahtuam", "Clocher", 0, "Torre del Reloj" },
  // DemoCORVETTE
  { "Corvette", "Corvette", "Korwett", 0, 0, "Corvette" },
  // DemoCUBE
  { "Cube", "Wrfel", "Wirfl", 0, 0, "Cubo" },
  // DemoENGINE
  { "Engine", "Motor", "Motoa", "Moteur", 0, "Motor" },
  // DemoIICMFOYER
  { "IICM Foyer", "IICM Vorraum", "EiEiSiEm Vuarraum", "Foyer de l'IICM", 0, "Vestbulo de IICM" },
  // DemoIICMINST
  { "IICM Institute", "IICM Institut", "EiEiSiEm Inschtitut", "L'Institut IICM", 0, "Instituto IICM" },
  // DemoKANDHLEIT
  { "Office Andrews/Leitner", "Bro Andrews/Leitner", "Bhro Andrews/Leitner", "Bureau Andrews/Leitner", 0, "Oficina Andrews/Leitner" },
  // DemoROOM
  { "Room", "Zimmer", "Zimma", "Pice", 0, "Habitacin" },
  // DemoWORLD
  { "World", "Globus", "Wltkugl", "Monde", 0, "Mundo" },

  /* dialog buttons */
  // DialogButtonOPEN
  { "Open", "ffnen", "Aufmchn", "Ouvrir", 0, "Abrir" },
  // DialogButtonSAVE
  { "Save", "Speichern", "Speichan", "Sauvegarder", 0, "Guardar" },

  /* dialog strings (labels) */
  // DialogStringCOLLISIONDISTANCE
  { "Collision Distance", "Kollisions-Distanz", "Koulischn-Entfernung", 0, 0, 0 },
  // DialogStringFILENAME
  { "Filename:", "Dateiname:", "Feilnm:", "Fichier:", 0, "Fichero:" },
  // DialogStringNAVSPEEDFACTOR
  { "Navigation Speed Factor", "Beschleunigungsfaktor", "Beschleinigungsfaktor", 0, 0, 0 },
  // DialogStringOVERWRITEEXISTENTFILE
  { "Overwrite existent File?", "Bestehende Datei berschreiben?", "ba vorhndenes Feil drbaschreibn?", "Remplacer le fichier existant?", 0, "Reemplazar fichero existente?" },
  // DialogStringROTATIONSPEED
  { "Rotation Speed", "Rotationsgeschwindigkeit", "Routationsgeschwindigkeit", 0, 0, 0 },
  // DialogStringZOOMSPEED
  { "Zoom Speed", "Zoomgeschwindigkeit", "Zoomgeschwindigkeit", 0, 0, 0 },

  /* dialog title */
  // DialogTitleCOLOURCHOOSER
  { "Colour Chooser", "Farbe whlen", "Foab auswhln", "Slecteur de couleurs", 0, "Seleccionar Color" },
  // DialogTitleNAVIGATIONSETTINGS
  { "VRweb Settings", "VRweb Einstellungen", "VRweb Einstllungan", /*F?*/0, 0, "VRweb Valores de Ajuste" },
  // DialogTitleOPENFILE
  { "Open File", "Datei ffnen", "Feil aufmchn", "Ouverture de fichier", 0, "Abrir Fichero" },
  // DialogTitlePARSEROUTPUT
  { "Parser Output", 0, 0, "Sortie de l'analyse grammaticale", 0, 0 },
  // DialogTitleSAVEFILE
  { "Save Scene", "Szene speichern", "Szene speichan", "Sauvegarder la scne", 0, "Guardar Escena" },

  /* display modes */
  // DisplayAALIASING
  { "Line Antialiasing", 0, "Ecken wegbgeln", "Adoucissement des lignes", 0, 0 },
  // DisplayBOUNDINGBOX
  { "Bounding Boxes", "Begrenzungswrfel", "Schochtln ummadum", "Cubes dlimitants", 0, "Cubo Delimitante" },
  // DisplayFLATSHADING
  { "Flat Shading", "konstant schattiert", "gleiche Foab", "Nuances constantes", 0, "Sombreado Constante" },
  // DisplayHIDDENLINE
  { "Hidden Line", "hidden line (Umrisse)", "nua die Kanten ummadum", "Lignes caches", 0, "Hidden Line (Permetro)" },
  // DisplayINTERACTIVE
  { "Interactive", "interaktiv", "beim ummadumfoahn", "Interaction", 0, "Interactivo" },
  // DisplaySMOOTHSHADING
  { "Smooth Shading", "verlaufend schattiert", "vaschmiate Foab", "Nuances varies", 0, "Sombreado Progresivo" },
  // DisplayTEXTURING
  { "Texturing", "Texturen", "Bldln auf die Flchn", "Texturation", 0, "Texturas" },
  // DisplayTHESAME
  { "The same", "Dieselbe", "die gleiche", "Mme chose", 0, "El mismo" },
  // DisplayWIREFRAME
  { "Wireframe", "Kantenmodell", "olle Kanten", "Fil de fer", 0, "Modelo Alambre" },

  /* Document Information */
  // DocumentANNOTATIONS
  { "Annotations", "Annotationen", "nmerkungan", 0, 0, "Notas" },
  // DocumentATTRIBUTES
  { "Attributes", "Attribute", "Attribute", "Attributs", 0, "Atributos" },
  // DocumentPARENTS
  { "Parents", "Vorfahren", "Vurfhrn", 0, 0, "Padres" },
  // DocumentREFERENCES
  { "References", "Referenzen", "Referenzen", "Rfrences", 0, "Referencias" },
  // DocumentTEXTURES
  { "Textures", "Texturen", "Bldln auf die Flchn", "Texturation", 0, "Texturas" },

  /* File Menu Items */
  // FileDEMO
  { "Demo", "Demo", "Zag her", "Dmonstrations", 0, "Demo" },
  // FileEDIT
  { "Edit", "Bearbeiten", "Editieren", "dition", 0, "Editar" },
  // FileEXITVIEWER
  { "Exit Viewer", "Beende Viewer", "her auf!", "Terminer", 0, "Terminar Viewer" },
  // FileEXPORT
  { "Export...", 0, "Expoat...", "Exporter...", 0, "Exportar..." },
  // FileMAIL
  { "Mail to...", "Mail an...", "Schick' a mail n...", "Poster ...", 0, "Enviar a..." },
  // FileOPEN
  { "Open...", "ffnen...", "Mch auf...", "Ouvrir...", 0, "Abrir..." },
  // FilePARSERERRORS
  { "View Parser Output...", "Parser Output anzeigen...", "Parsa Autput nzagn...", "Sortie de l'analyseur grammatical...", 0, "Ver Output del Parser..." },
  // FilePRINT
  { "Print...", "Drucken...", "Druck's...", "Imprimer...", 0, "Imprimir..." },
  // FileSAVEAS
  { "Save as...", "Speichern unter...", "Speicher's als...", "Sauvegarder sous...", 0, "Guardar como..." },
  // FileUSABILITYTESTS
  { "Usability Test", "Benutzer-Test", "Benutza-Test", "Test d'usage", 0, "Test Usuario" },

  // HARMONY3DVIEWER
  { "Harmony VRweb", "Harmony VRweb", "Arnie/Hamroni VRweb", 0, 0, "Harmony VRweb" },
  // VRWEBSCENEVIEWER
  { "VRweb Scene Viewer", "VRweb Szenen-Viewer", "VRweb Szenen-Wiua", "Visionneur de scnes VRweb", 0, "VRweb Scene Viewer" },

  /* Help Menu Items */
  // HelpABOUTPRODUCT
  { "About", "Info ber...", "Info ba...", " propos...", 0, "Info..." },
  // HelpINDEX
  { "Index", "Index", "Index", 0, 0, "Indice" },
  // HelpOVERVIEW
  { "Overview", "bersicht", "basicht", "Survol", 0, "Panorama" },

  /* Menubar Items */
  // MenuANCHORS
  { "Anchors", "Anker", "nka", "Ancres", 0, "Anclas" },
  // MenuCOLOR
  { "Colour", "Farben", "Foab", "Couleurs", "Colore", "Color" },
  // MenuDOCUMENT
  { "Document", "Dokument", "Doukument", 0, 0, "Documento" },
  // MenuFILE
  { "File", "Datei", "Feil", "Fichier", 0, "Fichero" },
  // MenuHELP
  { "Help", "Hilfe", "Hlfe", "Aide", "Aiuto", "Ayuda" },
  // MenuNAVIGATE
  { "Navigate", "Navigation", "Ummadumkumman", "Navigation", 0, "Navegacin" },
  // MenuOPTIONS
  { "Options", "Optionen", "Optionen", 0, 0, "Opciones" },
  // MenuSPECIAL
  { "Special", "Extras", "Spezill", "Particularits", 0, "Extras" },
  // MenuVIEW
  { "Display", "Anzeige", "nzeige", "Affichage", 0, "Monitor" },  // { "View", "Ansicht", "Ansicht", 0, 0, "Vista" },
  // MenuVIEWPOINTS
  { "Viewpoints", "Ansichten", "nsichten", "Points de vue", 0, "Perspectivas" },

  /* Messages (Errors, Warnings, Hints) */
  // MessageERRORNOINPUTFILE
  { "Original input not available for saving\n(got it through pipe; use Export)", "Originaldaten nicht mehr verfgbar\n(stammen aus pipe; Ersatz: Export)", "Die Originaldaten hb i nimma\n(pipe; nimm'n Expoat)", "Entre originale non disponible\n(obtenue par pipeline; servez vous de Exporter).", 0, "Datos originales ya no estn a disposicin \npara ser almacenados (provenientes de pipe; usar Export)" },
  // MessageERRORONREADING
  { "Error on reading ", "Fehler beim Lesen von ", "Fhla beim Lesn va ", "Erreur pendant la lecture de ", 0, "Error al leer " },
  // MessageERRORONWRITING
  { "Error on writing ", "Fehler beim Schreiben von ", "Fhla beim Schreibn va ", "Erreur pendant l'criture de ", 0, "Error al grabar " },
  // MessageSUCCESSFULLYWRITTEN
  { "File written: ", "Datei gespeichert: ", "Feil gschpeichat: ", "Fichier crit: ", 0, "Fichero almacenado: " },
  // MsgboxtitleERROR
  { "Error", "Fehler", "Fhla", "Erreur", "Errore", "Error" },

  /* Navigation Modes */
  // NavFLIPOBJECT
  { "Flip", "Objekt bewegen", "Schupfn", "Pivoter objet", 0, "Mover Objeto" },
  // NavFLY
  { "Fly", "Fliegen", "Fliagn", "Voler", 0, "Volar" },
  // NavFLYTO
  { "Fly To", "Fliegen auf Ziel", "Flieg duathin", "Voler vers", 0, "Volar hacia" },
  // NavHEADSUP
  { "Heads Up", "Kontrollsymbole", "Kastln (Box!)", "Console", 0, "Controles" },
  // NavWALK
  { "Walk", "Gehen", "Hatschn", "Marcher", "Andare", "Caminar" },

  /* Hints for using navigation modes */
  // NavHintFLIPOBJECT
  { "Drag mouse to translate/rotate/zoom the model",
    "Objekt verschieben/rotieren/zoomen durch Ziehen der Maus",
    "Vaschiab'/drah'/ziach's Objekt mit da Maus",
    "Maintenir enfonc le bouton de souris pour dplacer/faire pivoter/faire un zoom sur l'objet", 0, 
    "Mover el ratn para trasladar/rotar/agrandar-achicar el objeto" },
  // NavHintFLY
  { "Use mouse buttons to activate/accelerate/decelerate flight",
    "Flug aktivieren/beschleunigen/abbremsen mit den Maustasten",
    "Fliagn einscholtn/beschleinign/bremsn mit die Maustastn",
    "Utilisez les boutons de souris pour enclencher le vol/acclrer/dclrer", 0,
    "Usar el ratn para activar/acelerar/desacelerar el vuelo" },
  // NavHintFLYTO
  { "Press mouse buttons to set target/fly to it/fly away from it",
    "Ziel positionieren/anfliegen/verlassen mit den Maustasten",
    "Zl setzen/oufliagn/davoufliagn mit die Maustastn",
    "Utilisez les boutons de souris pour fixer la cible/l'approcher/l'loigner", 0, 
    "Usar botones del ratn para ajustar/volar hacia/abandonar el objetivo" },
  // NavHintFLYTOINHU
  { "Set target/fly to it/fly away with mouse buttons; double-click to return to icons",
    "Ziel positionieren/anfliegen/verlassen mit den Maustasten; Doppelklick fr Rckkehr zu Symbolen",
    "Zl setzen/oufliagn/davoufliagn mit die Maustastn; doupplt klickn um za die Kastln zruckzkumman",
    "Fixez/volez vers/loignez vous de la cible avec les boutons de souris; cliquez deux fois pour revenir aux icnes", 0,
    "Usar botones del ratn para ajustar/volar hacia/abandonar el objetivo; doble-click para retornar a los iconos" },
  // NavHintHEADSUP
  { "Drag mouse out of icons for movement (or select fly-to icon)",
    "Fr Navigation Maus aus Symbol hinausziehen (oder Ziel-Symbol clicken)",
    "Zum Ummadumkumman Maus va de Kastln aussiziagn (oder aufs Zl-Kastl druckn)",
    "Sortez le pointeur d'un icne avec un bouton enfonc pour naviguer (ou choisissez l'icne Voler vers)", 0, 
    "Retirar el ratn de los iconos para navegar ( seleccionar icono 'Volar hacia')" },
  // NavHintWALK
  { "Drag mouse to walk/move/look around",
    "Gehen/verschieben/schauen durch Ziehen der Maus",
    "Ziag die Maus zum Hatschn/Vaschiabn/Augn vadrahn", 
    "Maintenez enfonc un bouton pour marcher/vous dplacer/tourner la tte", 0, 
    "Mover ratn para caminar/trasladar/mirar" },

  /* Navigation Functions */
  // NavigateBACK
  { "Back", "Rckwrts", "Z'ruck", "Prcdent", 0, "Atrs" },
  // NavigateFORWARD
  { "Forward", "Vorwrts", "Firi", "Suivant", 0, "Adelante" },
  // NavigateHISTORY
  { "History", "Befehlsgeschichte", "G'schicht", "Historique", 0, "Historia" },
  // NavigateHOLD
  { "Hold", "Halte Dokument", "Hoits", "Maintenir cette fentre", 0, "Mantener" },

  // NavigateLEVELVIEW
  { "Level View", "Horizontale Ansicht", "Mch's ebn", "Niveler la vue", 0, "Vista Horizontal" },
  // NavigateRESETVIEW
  { "Reset View", "Ansicht zurcksetzen", "Ansicht zrucksetzen", "Rtablir la vue", 0, "Reajustar Vista" },
  // NavigateUNTILTVIEW
  { "Untilt View", "Neigung zurcksetzen", "Mch's grod", "Rtablir l'inclinaison", 0, "Reajustar Inclinacin" },
  // NavigateVIEWPOINT
  { "Camera", "Kamera", "Kmera", "Camra", 0, "Cmara" },
  // NavigateSETTINGS
  {  "Settings...", "Einstellungen...", "Einstllungan...", /*F?*/0, 0, "Valores..." },
  // NavigateSPACEBALL
  { "Spaceball...", 0, 0, 0, 0, 0 },

  /* options */
  // OptionARBITRARYROTATIONS
  { "Free Rotation Control", "Beliebige Rotationen", "Drah's wias'd wlsd", "Libre contrle de la rotation", 0, "Rotacin Libre" },
  // OptionCOLLISIONDETECTION
  { "Collision Detection", "Kollisions-Erkennung", "kane Bruchlndungen", 0, 0, 0 },
  // OptionDOLIGHTING
  { "Lighting Calculations", "Licht-Berechnungen", "Lichta ausrechnan", "Calcul de l'clairage", 0, "Clculos de Luz" },
  // OptionENABLEMOTION
  { "Enable Motion with Anchors", "Navigation bei Ankerhervorhebung", "Weita ummadumfoan", "Permettre mouvements avec ancres", 0, "Navegacin Mediante Anclas" },
  // OptionSHOWFRAMERATE
  { "Show Framerate", "Zeit pro Bild anzeigen", "zag wia schnll da'd bist", "Afficher frquence d'image", 0, "Ver Relacin Tiempo/Imgen" },
  // OptionSHOWTITLE
  { "Show Title", "Titel anzeigen", "zag an Titl n", "Afficher titre", 0, 0 },
  // OptionTEXTURELIGHTING
  { "on texturing", "mit Texturen", "mit die Bldln", "sur textures", 0, "con texturas" },
  // OptionTWOSIDEDPOLYS
  { "Two-sided Polygons", "Zweiseitige Polygone", "zwoaseitige Polgone", "Calcul des deux faces", 0, "Polgonos de Doble Lado" },
  // OptionVELOCITYCONTROL
  { "Velocity Control", "Geschwindigkeitsregelung", "Regl die G'schwindigkeit", "Rglage de la vitesse", 0, "Control de Velocidad" },

  /* progress labels */
  // ProgressPROCESSCAMERAS
  { "processing camera information", "Kameradaten verarbeiten", "Kmeradatn verorbeitn", "traitment de l'information des camras", 0, "procesando informacin de cmara" },
  // ProgressREADINGACTORS
  { "reading scene actors", "Szenenbeschreibung einlesen", "Szenenbeschreibung einlesn", "lecture des acteurs de la scne", 0, "leyendo descripcin de escena" },
  // ProgressREADINGCAMERAS
  { "reading camera information", "Kameradaten einlesen", "Kmeradatn einlesn", "lecture de l'information des camras", 0, "leyendo informacin de cmara" },
  // ProgressREADINGLIGHTS
  { "reading light sources", "Lichtquellen einlesen", "Lichta einlesn", "lecture des sources de lumire", 0, "leyendo fuentes de luz" },
  // ProgressREADINGMATERIALS
  { "reading material definitions", "Materialdaten einlesen", "Materialdatn einlesn", "lecture des dfinitions de matriaux", 0, "leyendo definicin de materiales" },
  // ProgressREADINGOBJECTS
  { "reading object data", "Objektdaten einlesen", "Objektdatn einlesn", "lecture des donnes d'objets", 0, "leyendo datos de objeto" },
  // ProgressREADINGPOSITIONS
  { "reading object positions", "Objektpositionen einlesen", "Objektpositionen einlesn", "lecture des positions d'objets", 0, "leyendo posiciones de objeto" },
  // ProgressREADINGTEXTURE
  { "reading texture image", "Texturbild einlesen", "Flchenbld'l einlesn", "lecture de l'image des textures", 0, "leyendo imgen de textura" },
  // ProgressREADINGVRML
  { "reading VRML scene", "VRML-Szene einlesen", "VRML-Datn einlesn", "lecture de la scne VRML", 0, "leyendo escena VRML" },
  // ProgressREADY
  { "ready", "bereit", "featig", "prt", "pronto", "listo" },
  // ProgressREQUESTINLINEVRML
  { "requesting inline VRML", "hole Inline-VRML", "hul' inlain VRML", "VRML en ligne demand", 0, "buscando inline-VRML" },
  // ProgressREQUESTTEXTURE
  { "requesting texture", "hole Texturbild", "hul' Texturbld'l", "texture demande", 0, "buscando textura" },

  /* Spaceball */
#ifdef SPACEBALL
  // SpaceballDECREASE
  { "decrease", "verringern", "weniga", 0, 0, 0 },
  // SpaceballINCREASE
  { "increase", "erhhen", "mehr", 0, 0, 0 },
  // SpaceballRESETSENSITIVITY
  { "reset", "zurcksetzen", "zrucksetzen", 0, 0, "reajustar" },
  // SpaceballREZERO
  { "rezero", "Ruhelage", "Ruhelage", 0, 0, 0 },
  // SpaceballROTATION
  { "Rotation", 0, 0, 0, 0, 0 },
  // SpaceballSENSITIVITY
  { "Sensitivity", "Empfindlichkeit", "Empfindlichkeit", 0, 0, 0 },
  // SpaceballSINGLEAXISFILTER
  { "Single Axis Filter", "Dominante Achse", "Dominante Achse", 0, 0, 0 },
  // SpaceballTRANSLATION
  { "Translation", 0, 0, 0, 0, 0 },
#else
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
#endif

  /* status line info */
  // StatuslineFPS
  { "fps", "F/s", "B/s", "i/s", 0, 0 },
  // StatuslineLASTFRAME
  { "last frame", "letzter Frame", "letztes Bldl", "dernire image", 0, 0 },
  // StatuslinePOLYGONS
  { "polygons", "Polygone", "Polgone", "polygones", 0, "polgonos" },
  // StatuslinePRIMITIVES
  { "primitives", "Grundobjekte", "ndare Objekte", 0, 0, "objetos base" },

  /* special menu items */
  // SpecialCAMERAINFO
  { "Camera Info", "Kamera Information", "Kamera Infou", "Info de camra", 0, "Informacin sobre Cmara" },
  // SpecialPRINTALL
  { "Print All", "Alle Daten ausgeben", "Schmei olle Daten aussi", "Tout imprimer", 0, "Imprimir Todo" },
  // SpecialPRINTDATA
  { "Print Data", "Datenstruktur ausgeben", "Schmei a poor Daten aussi", "Imprimer donnes", 0, "Imprimir Datos" },

  /* twosided polygons */
  // TwosidedAUTO
  { "auto", 0, 0, 0, 0, 0 },
  // TwosidedOFF
  { "off", "aus", "aus", "dsactiv", 0, "desactivar" },
  // TwosidedON
  { "on", "ein", "ein", "activ", 0, "activar" },

  /* usability tests */
  // UTestEAST
  { "Test E", "Test O", "Test O", 0, 0, 0 },
  // UTestNORTH
  { "Test N", 0, 0, 0, 0, 0 },
  // UTestSOUTH
  { "Test S", 0, 0, 0, 0, 0 },
  // UTestWEST
  { "Test W", 0, 0, "Test O", 0, 0 },

}; // sstringtable



const char* STranslate::str (SStrSym strsym, HgLanguage::Language language)
{
  const char* res = sstringtable [strsym][language];

  if (res)
    return res;
  else
    return sstringtable [strsym][HgLanguage::Default];  // english
}
