//<file>
//
// File:        gecontext.h - glyph for 3D drawing
//
// Created:     10 Nov 92   Michael Pichler
//
// Changed:     25 Jul 95   Michael Pichler
//
//
//</file>

//<copyright>
//
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
//
//</copyright>



#ifndef hg_viewer_scene_gecontext_h
#define hg_viewer_scene_gecontext_h


#include <InterViews/monoglyph.h>
class Cursor;
class Display;
class Window;
class GLWindow;

// renamed from GLContext to GEContext (name conflict with InterViews)

class GEContext: public MonoGlyph
{
  public:
    enum { RequestOverlay = 0x1 };

    GEContext (Glyph*, int requests = 0);
    ~GEContext ();

    void allocate (Canvas*, const Allocation&, Extension&);  // told my actual geometry
    void draw (Canvas*, const Allocation&) const  { }        // draw myself

    void redraw (                       // damage canvas
      int shading                       //   hint whether shading will be performed
    );                                  //   pass 0 for wireframe drawings to speed up Mesa

    void unbind ();                     // delete GLX window

    Window* window ();

    void setCursor (Cursor*);           // set a cursor
    void resetCursor ();                // restore original cursor
    void pushCursor (Cursor*);
    void popCursor ();

    int overlaySupport ();                   // platform supports overlay planes
    void activateOverlay (int clear = 1);    // switch to overlay planes
    void deactivateOverlay ();               // switch back to normal bitplanes

    static const char* implementation ();    // implementation info (e.g.: "IrisGL", "OpenGL")
    enum { impl_slow = 0x1, impl_notextures = 0x2, impl_requiresTrueColor = 0x4 };
    static int implementationHints ();  // hints to implementation properties

    static int graphicsSupport (        // query for graphics support
      Display* dis = 0);                //   on specified or default display

  private:
    GLWindow* glwin_;
    Cursor* origcur_;

    int requestoverlay_;
};  // GEContext



#endif
