// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name:       colorviewer.h
//
// Purpose:    Interface to observer glyph of ocolor, which shows
//             the current colour by filling its allocation
//
// Created:     6 Apr 93    Michael Pichler
//
// Modified:   18 May 93    Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_colorviewer_h
#define harmony_widgets_colorviewer_h


#include <InterViews/observe.h>
#include <InterViews/patch.h>
class Color;

class OColor;



// Class ColorViewer

// This is class is an observer which pays attention to the changes 
// in three adjustables.  These adjustable's values should fall within
// the range 0.0 and 1.0 because they will be interpreted as color 
// intensities (i.e. a percentage of a color's intensity in the range
// 0-255).  
// This class is also a patch (i.e. it remembers its canvas and
// allocation so that it can be redrawn independently).

class ColorViewer: public Patch, public Observer
{
  public:
    ColorViewer (OColor*);
    virtual ~ColorViewer();

    virtual void request (Requisition&) const;
    virtual void allocate (Canvas*, const Allocation&, Extension&);
    virtual void draw (Canvas*, const Allocation&) const;

    virtual void update (Observable*);
    virtual void disconnect (Observable*);

  private:
    OColor* oc_;
    Color* color_;
};



#endif
