// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        about.h
//
// Purpose:     interface to about dialog
//
// Created:     25 Apr 94   Michael Pichler
//
// Changed:     29 Jun 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_about_h
#define harmony_widgets_about_h


#include <hyperg/hyperg/language.h>

#include <InterViews/enter-scope.h>
class Font;
class Glyph;
class Image;
class ManagedWindow;
class Patch;
class PolyGlyph;



// Class About - about box
//
// style name: About
//
// style attributes:
//
// infofontbig     large font (default helvetica 17)
// infofontsmall   small font (default helvetica 12)
// iconpath        path of icons (need not end with '/')
// aboutlogo       file name of about logo (TIFF)
// hyperglogo      file name of Hyper-G logo (TIFF)
// hypergmask      file name of HG-logo mask (X-Bitmap, bit set on background)
//
// example for call:
//
// if (About::ismapped ())
//   About::unmap ();
// else
//   About::map (language, "The Hyper-G Client for X11/Unix",
//               "Version 0.8f\nof Mon 25th April 1994");


class About
{
  public:
    static void map(                    // create and map About dialog
      HgLanguage::Language lang,        //   language (for copyright)
      const char* description,          //   program description
      const char* version,              //   version (several lines, separated with '\n')
      const char* wintitle = 0,         //   window title (default provided)
      int biglogo = 0                   //   show big logo (default small icon)
    );

    static void unmap();                // unmap and destroy About dialog

    static int ismapped()               // check whether About is mapped
    { return aboutwin_ != 0; }

    static void credits(Glyph*);
    static const Font* getBigFont();
    static const Font* getSmallFont();
    static void toggleCard ();

  private:
    static void lookupFonts ();

    static ManagedWindow* aboutwin_;
    static float hleft_, hbottom_;
    static Glyph* crglyph_;
    static Patch* winpatch_;
    static Glyph* credits_;
    static PolyGlyph* crbox_;
    static PolyGlyph* bigbox_;
    static int crindex_;
    static int card_;
    static const Font* bigfont_;
    static const Font* smallfont_;
};



#endif
