// This may look like C code, but it is really -*- C++ -*-

// **********************************************************
// File hgviewer.h
// ----------------------------------------------------------
// Created: J. Faschingbauer
// **********************************************************
#ifndef have_viewer_h
#define have_viewer_h

#include "vwboss.h"



enum HgViewerError {
   OK,
   NC,
   TIMEOUT
} ;


class HgViewer {
public:
   HgViewer (ViewerBoss*) ;
   virtual ~HgViewer() ;

   virtual void load (const char* doc, const char* anchors) = 0 ;
   virtual void browse (const char* dest) = 0 ;
   virtual void terminate() = 0 ;

   HgViewerError error()  { return _error; }

protected:
   ViewerBoss* _boss ;
   HgViewerError _error ;
} ;

inline HgViewer :: HgViewer (ViewerBoss* boss)
: _boss (boss) ,
  _error (OK) {}

inline HgViewer :: ~HgViewer() {}





#endif
