/*
 * Granite - using a 1/f fractal noise function for color values.  
 */

#include <math.h>
#include <stdio.h>

#include "sipp.h"
#include "noise.h"
#include "shaders.h"


extern bool noise_ready;


static void 
granite (p, color, gd)
    Vector *p;
    Color *color;
    Granite_desc *gd;
{
    int i;
    Vector v;
    double temp, n = 0.5, freq = 1.0;

    v = *p;
    
    for (i = 0; i < 6 ; freq *= 2.0, i++) {
        v.x *= 4.0 * freq;
        v.y *= 4.0 * freq;
        v.z *= 4.0 * freq;
        temp = 0.5 * noise(&v);
/*        temp = fabs(temp);*/
        n += temp / freq;
    }

   color->red = gd->col1.red * n + gd->col2.red * (1.0 - n);
   color->grn = gd->col1.grn * n + gd->col2.grn * (1.0 - n);
   color->blu = gd->col1.blu * n + gd->col2.blu * (1.0 - n);
}


void
granite_shader(nx, ny, nz, u, v, w, view_vec, lights, gd, color)
    double  nx, ny, nz, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Granite_desc *gd;
    Color *color;
{
    Vector     tmp;
    Surf_desc  surface;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * gd->scale;
    tmp.y = v * gd->scale;
    tmp.z = w * gd->scale;
    granite(&tmp, &surface.color, gd);
    surface.ambient  = gd->ambient;
    surface.specular = gd->specular;
    surface.c3       = gd->c3;
    basic_shader(nx, ny, nz, u, v, w, view_vec, lights, &surface, color);
}
